/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class MixinProxy
implements InvocationHandler {
    private final Object[] delegates;
    private final Map<Method, Target> methodMap = new HashMap<Method, Target>();

    public MixinProxy(Object ... delegates) {
        this.delegates = delegates;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Target t = this.methodMap.get(method);
        if (t == null) {
            for (Object object : this.delegates) {
                try {
                    Method m = object.getClass().getMethod(method.getName(), method.getParameterTypes());
                    t = new Target();
                    t.m = m;
                    t.obj = object;
                    this.methodMap.put(method, t);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        if (t != null) {
            try {
                return t.m.invoke(t.obj, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        return this.noSuchMethodFound(proxy, method, args);
    }

    protected Object noSuchMethodFound(Object proxy, Method method, Object[] args) throws Throwable {
        throw new RuntimeException("Could not determine target delegate for method " + String.valueOf(method));
    }

    private static class Target {
        Object obj;
        Method m;

        private Target() {
        }
    }
}

