/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.util;

import com.kubling.teiid.core.BundleUtil;
import com.kubling.teiid.core.CorePlugin;
import com.kubling.teiid.core.TeiidException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ReflectionHelper {
    private final Class<?> targetClass;
    private Map<String, LinkedList<Method>> methodMap = null;

    public ReflectionHelper(Class<?> targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException(CorePlugin.Util.getString("ReflectionHelper.errorConstructing"));
        }
        this.targetClass = targetClass;
    }

    public Method findBestMethodOnTarget(String methodName, Object[] arguments) throws NoSuchMethodException, SecurityException {
        this.createMethodMap();
        List methods = this.methodMap.get(methodName);
        if (methods != null && methods.size() == 1) {
            return (Method)methods.get(0);
        }
        if (arguments == null) {
            return this.findBestMethodWithSignature(methodName, Collections.EMPTY_LIST);
        }
        int size = arguments.length;
        ArrayList argumentClasses = new ArrayList(size);
        for (int i = 0; i != size; ++i) {
            if (arguments[i] != null) {
                Class<?> clazz = arguments[i].getClass();
                argumentClasses.add(clazz);
                continue;
            }
            argumentClasses.add(null);
        }
        return this.findBestMethodWithSignature(methodName, argumentClasses);
    }

    public Method findBestMethodWithSignature(String methodName, Object[] argumentsClasses) throws NoSuchMethodException, SecurityException {
        List<Object> argumentClassesList = Arrays.asList(argumentsClasses);
        return this.findBestMethodWithSignature(methodName, argumentClassesList);
    }

    public Method findBestMethodWithSignature(String methodName, List<Class<?>> argumentsClasses) throws NoSuchMethodException, SecurityException {
        Method result = null;
        Class[] classArgs = new Class[argumentsClasses.size()];
        try {
            argumentsClasses.toArray(classArgs);
            result = this.targetClass.getMethod(methodName, classArgs);
            return result;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.createMethodMap();
            LinkedList<Method> methodsWithSameName = this.methodMap.get(methodName);
            if (methodsWithSameName == null) {
                throw new NoSuchMethodException(methodName);
            }
            for (Method method : methodsWithSameName) {
                Class[] args = method.getParameterTypes();
                boolean allMatch = ReflectionHelper.argsMatch(argumentsClasses, args);
                if (!allMatch) continue;
                if (result != null) {
                    throw new NoSuchMethodException(methodName + " Args: " + String.valueOf(argumentsClasses) + " has multiple possible signatures.");
                }
                result = method;
            }
            if (result != null) {
                return result;
            }
            throw new NoSuchMethodException(methodName + " Args: " + String.valueOf(argumentsClasses));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMethodMap() {
        if (this.methodMap == null) {
            ReflectionHelper reflectionHelper = this;
            synchronized (reflectionHelper) {
                if (this.methodMap != null) {
                    return;
                }
                HashMap<String, LinkedList<Method>> newMethodMap = new HashMap<String, LinkedList<Method>>();
                Method[] methods = this.targetClass.getMethods();
                for (int i = 0; i != methods.length; ++i) {
                    Method method = methods[i];
                    LinkedList methodsWithSameName = newMethodMap.computeIfAbsent(method.getName(), k -> new LinkedList());
                    methodsWithSameName.addFirst(method);
                }
                this.methodMap = newMethodMap;
            }
        }
    }

    private static boolean argsMatch(List<Class<?>> argumentsClasses, Class[] args) {
        if (args.length != argumentsClasses.size()) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            Class<?> primitiveClazz;
            Class<?> objectClazz = argumentsClasses.get(i);
            if (!(objectClazz != null ? !args[i].equals(primitiveClazz = ReflectionHelper.convertArgumentClassesToPrimitive(objectClazz)) && !args[i].isAssignableFrom(objectClazz) : args[i].isPrimitive())) continue;
            return false;
        }
        return true;
    }

    private static Class<?> convertArgumentClassesToPrimitive(Class<?> clazz) {
        if (clazz == Boolean.class) {
            clazz = Boolean.TYPE;
        } else if (clazz == Character.class) {
            clazz = Character.TYPE;
        } else if (clazz == Byte.class) {
            clazz = Byte.TYPE;
        } else if (clazz == Short.class) {
            clazz = Short.TYPE;
        } else if (clazz == Integer.class) {
            clazz = Integer.TYPE;
        } else if (clazz == Long.class) {
            clazz = Long.TYPE;
        } else if (clazz == Float.class) {
            clazz = Float.TYPE;
        } else if (clazz == Double.class) {
            clazz = Double.TYPE;
        } else if (clazz == Void.class) {
            clazz = Void.TYPE;
        }
        return clazz;
    }

    private static Class<?> loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> cls = classLoader == null ? Class.forName(className.trim()) : Class.forName(className.trim(), true, classLoader);
        return cls;
    }

    public static Object create(String className, Collection<?> ctorObjs, ClassLoader classLoader) throws TeiidException {
        try {
            int size = ctorObjs == null ? 0 : ctorObjs.size();
            Class[] names = new Class[size];
            Object[] objArray = new Object[size];
            int i = 0;
            if (size > 0) {
                for (Object obj : ctorObjs) {
                    if (obj != null) {
                        names[i] = obj.getClass();
                        objArray[i] = obj;
                    }
                    ++i;
                }
            }
            return ReflectionHelper.create(className, objArray, names, classLoader);
        }
        catch (Exception e) {
            throw new TeiidException((BundleUtil.Event)CorePlugin.Event.TEIID10033, (Throwable)e);
        }
    }

    public static Object create(String className, Object[] ctorObjs, Class<?>[] argTypes, ClassLoader classLoader) throws TeiidException {
        Class<?> cls;
        try {
            cls = ReflectionHelper.loadClass(className, classLoader);
        }
        catch (Exception e) {
            throw new TeiidException((BundleUtil.Event)CorePlugin.Event.TEIID10034, (Throwable)e);
        }
        Constructor<?> ctor = null;
        try {
            ctor = cls.getDeclaredConstructor(argTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (ctor == null && argTypes != null && argTypes.length > 0) {
            List<Class<?>> argumentsClasses = Arrays.asList(argTypes);
            for (Constructor<?> possible : cls.getDeclaredConstructors()) {
                if (!ReflectionHelper.argsMatch(argumentsClasses, possible.getParameterTypes())) continue;
                ctor = possible;
                break;
            }
        }
        if (ctor == null) {
            throw new TeiidException((BundleUtil.Event)CorePlugin.Event.TEIID10035, className + String.valueOf(CorePlugin.Event.TEIID10035) + Arrays.toString(argTypes));
        }
        try {
            return ctor.newInstance(ctorObjs);
        }
        catch (InvocationTargetException e) {
            throw new TeiidException((BundleUtil.Event)CorePlugin.Event.TEIID10036, e.getTargetException());
        }
        catch (Exception e) {
            throw new TeiidException((BundleUtil.Event)CorePlugin.Event.TEIID10036, (Throwable)e);
        }
    }
}

