/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types;

import com.kubling.teiid.core.types.BlobImpl;
import com.kubling.teiid.core.types.BlobType;
import com.kubling.teiid.core.types.InputStreamFactory;
import com.kubling.teiid.core.util.UnitTestUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import javax.sql.rowset.serial.SerialBlob;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBlobValue {
    public void testBlobValue() throws Exception {
        String testString = "this is test blob";
        SerialBlob blob = new SerialBlob(testString.getBytes());
        BlobType bv = new BlobType((Blob)blob);
        Assertions.assertEquals((Object)testString, (Object)new String(bv.getBytes(1L, (int)bv.length())));
    }

    public void testBlobValuePersistence() throws Exception {
        String testString = "this is test clob";
        SerialBlob blob = new SerialBlob(testString.getBytes());
        BlobType bv = new BlobType((Blob)blob);
        String key = bv.getReferenceStreamId();
        BlobType read = UnitTestUtil.helpSerialize(bv);
        Assertions.assertEquals((Object)key, (Object)read.getReferenceStreamId());
        Assertions.assertNull((Object)read.getReference());
    }

    @Test
    public void testReferencePersistence() throws Exception {
        String testString = "this is test clob";
        SerialBlob blob = new SerialBlob(testString.getBytes());
        BlobType bv = new BlobType((Blob)blob);
        bv.setReferenceStreamId(null);
        BlobType read = UnitTestUtil.helpSerialize(bv);
        Assertions.assertNull((Object)read.getReferenceStreamId());
        Assertions.assertEquals((Object)testString, (Object)new String(read.getBytes(1L, (int)blob.length())));
    }

    public void testBlobCompare() throws Exception {
        String testString = "this is test clob";
        SerialBlob blob = new SerialBlob(testString.getBytes());
        BlobType bv = new BlobType((Blob)blob);
        SerialBlob blob1 = new SerialBlob(testString.getBytes());
        BlobType bv1 = new BlobType((Blob)blob1);
        Assertions.assertEquals((int)0, (int)bv1.compareTo(bv));
    }

    public void testBlobImplGetBytes() throws Exception {
        BlobImpl b = new BlobImpl(new InputStreamFactory(this){

            public InputStream getInputStream() {
                return new ByteArrayInputStream(new byte[0]);
            }
        });
        byte[] b1 = b.getBytes(1L, 0);
        Assertions.assertEquals((int)0, (int)b1.length);
        byte[] b2 = b.getBytes(1L, 1);
        Assertions.assertEquals((int)0, (int)b2.length);
        b = new BlobImpl(new InputStreamFactory(this){

            public InputStream getInputStream() {
                return new ByteArrayInputStream(new byte[]{1, 2});
            }
        });
        byte[] b3 = b.getBytes(1L, 1);
        Assertions.assertEquals((int)1, (int)b3.length);
    }
}

