/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types;

import com.kubling.teiid.core.types.BinaryType;
import com.kubling.teiid.core.types.BlobType;
import com.kubling.teiid.core.types.DataTypeManager;
import com.kubling.teiid.core.types.GeographyType;
import com.kubling.teiid.core.types.GeometryType;
import com.kubling.teiid.core.types.JDBCSQLTypeInfo;
import com.kubling.teiid.core.types.Transform;
import com.kubling.teiid.core.types.TransformationException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.sql.rowset.serial.SerialBlob;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDataTypeManager {
    public static String[] dataTypes = new String[]{"string", "char", "boolean", "byte", "short", "integer", "long", "biginteger", "float", "double", "bigdecimal", "date", "time", "timestamp", "object", "blob", "clob", "xml"};
    public static char[][] conversions = new char[][]{{'O', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'I', 'N', 'I', 'C'}, {'I', 'O', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'O', 'I', 'I', 'I', 'I', 'I', 'I', 'I', 'I', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'C', 'O', 'I', 'I', 'I', 'I', 'I', 'I', 'I', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'C', 'C', 'O', 'I', 'I', 'I', 'I', 'I', 'I', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'C', 'C', 'C', 'O', 'I', 'I', 'C', 'I', 'I', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'C', 'C', 'C', 'C', 'O', 'I', 'C', 'C', 'I', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'C', 'C', 'C', 'C', 'C', 'O', 'C', 'C', 'I', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'C', 'C', 'C', 'C', 'C', 'C', 'O', 'I', 'I', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'O', 'I', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'O', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'O', 'N', 'I', 'I', 'N', 'N', 'N'}, {'I', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'O', 'I', 'I', 'N', 'N', 'N'}, {'I', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'C', 'C', 'O', 'I', 'N', 'N', 'N'}, {'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'O', 'C', 'C', 'C'}, {'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'I', 'O', 'N', 'N'}, {'C', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'I', 'N', 'O', 'N'}, {'C', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'I', 'N', 'N', 'O'}};

    private void helpDetermineDataType(Object value, Class<?> expectedClass) {
        Class actualClass = DataTypeManager.determineDataTypeClass((Object)value);
        Assertions.assertEquals(expectedClass, (Object)actualClass, (String)("Mismatch in expected and actual MetaMatrix type class for [" + String.valueOf(value) + "]: "));
    }

    @Test
    public void testTypeMappings() {
        Set dataTypeNames = DataTypeManager.getAllDataTypeNames();
        for (String dataTypeName : dataTypeNames) {
            Class dataTypeClass = DataTypeManager.getDataTypeClass((String)dataTypeName);
            Assertions.assertNotNull((Object)dataTypeClass, (String)("Data type class was null for type " + dataTypeName));
            String dataTypeName2 = DataTypeManager.getDataTypeName((Class)dataTypeClass);
            Assertions.assertEquals((Object)dataTypeName, (Object)dataTypeName2);
        }
    }

    @Test
    public void testCheckConversions() {
        for (int src = 0; src < dataTypes.length; ++src) {
            for (int tgt = 0; tgt < dataTypes.length; ++tgt) {
                char c = conversions[src][tgt];
                if (c == 'I') {
                    Assertions.assertTrue((boolean)DataTypeManager.isImplicitConversion((String)dataTypes[src], (String)dataTypes[tgt]), (String)("src=" + dataTypes[src] + " target=" + dataTypes[tgt] + " should be Implicit"));
                    Assertions.assertFalse((boolean)DataTypeManager.isExplicitConversion((String)dataTypes[src], (String)dataTypes[tgt]), (String)("src=" + dataTypes[src] + " target=" + dataTypes[tgt] + " should be not be Explicit"));
                    Assertions.assertTrue((boolean)DataTypeManager.isTransformable((String)dataTypes[src], (String)dataTypes[tgt]), (String)("src=" + dataTypes[src] + " target=" + dataTypes[tgt] + " transform should be avaialble"));
                    continue;
                }
                if (c == 'C') {
                    Assertions.assertFalse((boolean)DataTypeManager.isImplicitConversion((String)dataTypes[src], (String)dataTypes[tgt]), (String)("src=" + dataTypes[src] + " target=" + dataTypes[tgt] + " should not be Implicit"));
                    Assertions.assertTrue((boolean)DataTypeManager.isExplicitConversion((String)dataTypes[src], (String)dataTypes[tgt]), (String)("src=" + dataTypes[src] + " target=" + dataTypes[tgt] + " should be Explicit"));
                    Assertions.assertTrue((boolean)DataTypeManager.isTransformable((String)dataTypes[src], (String)dataTypes[tgt]), (String)("src=" + dataTypes[src] + " target=" + dataTypes[tgt] + " transform should be avaialble"));
                    continue;
                }
                if (c != 'O' && c != 'N') continue;
                Assertions.assertFalse((boolean)DataTypeManager.isImplicitConversion((String)dataTypes[src], (String)dataTypes[tgt]), (String)("src=" + dataTypes[src] + " target=" + dataTypes[tgt] + " should not be Implicit"));
                Assertions.assertFalse((boolean)DataTypeManager.isExplicitConversion((String)dataTypes[src], (String)dataTypes[tgt]), (String)("src=" + dataTypes[src] + " target=" + dataTypes[tgt] + " should not be Explicit"));
                Assertions.assertFalse((boolean)DataTypeManager.isTransformable((String)dataTypes[src], (String)dataTypes[tgt]), (String)("src=" + dataTypes[src] + " target=" + dataTypes[tgt] + " No transform should be avaialble"));
            }
        }
    }

    @Test
    public void testDetermineDataType1() {
        this.helpDetermineDataType("abc", DataTypeManager.DefaultDataClasses.STRING);
    }

    @Test
    public void testDetermineDataType2() {
        this.helpDetermineDataType(null, DataTypeManager.DefaultDataClasses.NULL);
    }

    @Test
    public void testDetermineDataType3() throws Exception {
        URL url = new URL("http://fake");
        this.helpDetermineDataType(url, DataTypeManager.DefaultDataClasses.OBJECT);
    }

    @Test
    public void testCheckAllConversions() {
        Set allTypes = DataTypeManager.getAllDataTypeNames();
        for (String src : allTypes) {
            for (String tgt : allTypes) {
                boolean isImplicit = DataTypeManager.isImplicitConversion((String)src, (String)tgt);
                boolean isExplicit = DataTypeManager.isExplicitConversion((String)src, (String)tgt);
                if (!isImplicit || !isExplicit) continue;
                Assertions.fail((String)("Can't be both implicit and explicit for " + src + " to " + tgt));
            }
        }
    }

    @Test
    public void testTimeConversions() {
        Transform t = DataTypeManager.getTransform((String)"timestamp", (String)"date");
        Assertions.assertEquals((Object)DataTypeManager.DefaultDataClasses.DATE, (Object)t.getTargetType());
        t = DataTypeManager.getTransform((String)"time", (String)"timestamp");
        Assertions.assertEquals((Object)DataTypeManager.DefaultDataClasses.TIMESTAMP, (Object)t.getTargetType());
    }

    @Test
    public void testJDBCSQLTypeInfo() {
        Set types = JDBCSQLTypeInfo.getMMTypeNames();
        for (String type : types) {
            Assertions.assertEquals((int)JDBCSQLTypeInfo.getSQLType((String)type), (int)JDBCSQLTypeInfo.getSQLTypeFromRuntimeType((Class)DataTypeManager.getDataTypeClass((String)type)), (String)("Didn't get match for " + type));
            if (type.equalsIgnoreCase("null") || type.equalsIgnoreCase("varbinary") || type.equalsIgnoreCase("xml") || type.equalsIgnoreCase("clob") || type.equalsIgnoreCase("blob") || type.equalsIgnoreCase("json")) continue;
            Assertions.assertEquals((int)JDBCSQLTypeInfo.getSQLType((String)type), (int)JDBCSQLTypeInfo.getSQLTypeFromClass((String)DataTypeManager.getDataTypeClass((String)type).getName()), (String)("Didn't get match for " + type));
        }
        Assertions.assertEquals((int)93, (int)JDBCSQLTypeInfo.getSQLTypeFromRuntimeType((Class)DataTypeManager.DefaultDataClasses.TIMESTAMP));
        Assertions.assertEquals((int)2009, (int)JDBCSQLTypeInfo.getSQLTypeFromRuntimeType((Class)DataTypeManager.DefaultDataClasses.XML));
        Assertions.assertEquals((Object)"string", (Object)JDBCSQLTypeInfo.getTypeName((int)1));
        Assertions.assertEquals((int)1, (int)JDBCSQLTypeInfo.getSQLTypeFromRuntimeType((Class)DataTypeManager.DefaultDataClasses.CHAR));
        Assertions.assertEquals((int)2003, (int)JDBCSQLTypeInfo.getSQLType((String)DataTypeManager.getDataTypeName((Class)DataTypeManager.getArrayType((Class)DataTypeManager.DefaultDataClasses.BIG_DECIMAL))));
    }

    @Test
    public void testRuntimeTypeConversion() throws Exception {
        Assertions.assertNull((Object)DataTypeManager.convertToRuntimeType(null, (boolean)true));
        Assertions.assertInstanceOf(BlobType.class, (Object)DataTypeManager.convertToRuntimeType((Object)new SerialBlob(new byte[0]), (boolean)true));
        Object foo = new Object();
        Assertions.assertEquals((Object)foo, (Object)DataTypeManager.convertToRuntimeType((Object)foo, (boolean)true));
        Integer bar = 1;
        Assertions.assertEquals((Object)bar, (Object)DataTypeManager.convertToRuntimeType((Object)bar, (boolean)true));
    }

    @Test
    public void testObjectType() {
        Assertions.assertEquals((Object)DataTypeManager.DefaultDataClasses.OBJECT, (Object)DataTypeManager.getDataTypeClass((String)"foo"));
        Assertions.assertEquals((Object)"object", (Object)DataTypeManager.getDataTypeName(TestDataTypeManager.class));
    }

    @Test
    public void testImplicitConversions() {
        ArrayList c = new ArrayList();
        DataTypeManager.getImplicitConversions((String)"integer", c);
        Assertions.assertEquals(Arrays.asList("long", "biginteger", "double", "bigdecimal", "string", "object"), c);
    }

    @Test
    public void testStringToXML() {
        Assertions.assertThrows(TransformationException.class, () -> DataTypeManager.transformValue((Object)"hello", (Class)DataTypeManager.DefaultDataClasses.XML));
    }

    @Test
    public void testObjectToString() throws Exception {
        Assertions.assertEquals((Object)"hello", (Object)DataTypeManager.transformValue((Object)new Foo(), (Class)DataTypeManager.DefaultDataClasses.STRING));
    }

    @Test
    public void testObjectArrayToObject() throws Exception {
        Object[] value = new Object[]{1, 2};
        Assertions.assertArrayEquals((Object[])value, (Object[])((Object[])DataTypeManager.transformValue((Object)value, value.getClass(), (Class)DataTypeManager.DefaultDataClasses.OBJECT)));
    }

    @Test
    public void testByteArray() {
        byte[] value = new byte[]{1, 2};
        Assertions.assertArrayEquals((byte[])value, (byte[])((byte[])DataTypeManager.convertToRuntimeType((Object)value, (boolean)false)));
        Assertions.assertEquals((Object)new BinaryType(value), (Object)DataTypeManager.convertToRuntimeType((Object)value, (boolean)true));
    }

    @Test
    public void testObjectTypeArray() throws Exception {
        Object[] value = new Object[]{"a", "b"};
        DataTypeManager.transformValue((Object)value, value.getClass(), String[].class);
    }

    @Test
    public void isHashable() {
        Assertions.assertFalse((boolean)DataTypeManager.isHashable((Class)DataTypeManager.DefaultDataClasses.STRING, (boolean)true, null));
        Assertions.assertFalse((boolean)DataTypeManager.isHashable(String[].class, (boolean)false, (String)"Something"));
    }

    @Test
    public void testGeographyToGeometry() throws Exception {
        Assertions.assertInstanceOf(GeometryType.class, (Object)DataTypeManager.transformValue((Object)new GeographyType(new byte[0]), (Class)DataTypeManager.DefaultDataClasses.GEOMETRY));
    }

    static class Foo {
        Foo() {
        }

        public String toString() {
            return "hello";
        }
    }
}

