/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types;

import com.kubling.teiid.core.types.SQLXMLImpl;
import com.kubling.teiid.core.util.ObjectConverterUtil;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import javax.xml.transform.stream.StreamSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSQLXMLImpl {
    String testStr = "<foo>test</foo>";

    @Test
    public void testGetSource() throws Exception {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        Assertions.assertInstanceOf(StreamSource.class, (Object)xml.getSource(null));
        StreamSource ss = (StreamSource)xml.getSource(null);
        Assertions.assertEquals((Object)this.testStr, (Object)new String(ObjectConverterUtil.convertToByteArray((InputStream)ss.getInputStream()), "UTF-8"));
    }

    @Test
    public void testGetCharacterStream() throws Exception {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        Assertions.assertEquals((Object)this.testStr, (Object)ObjectConverterUtil.convertToString((Reader)xml.getCharacterStream()));
    }

    @Test
    public void testGetBinaryStream() throws Exception {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        Assertions.assertEquals((Object)this.testStr, (Object)new String(ObjectConverterUtil.convertToByteArray((InputStream)xml.getBinaryStream()), "UTF-8"));
    }

    @Test
    public void testGetString() throws Exception {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        Assertions.assertEquals((Object)this.testStr, (Object)xml.getString());
    }

    @Test
    public void testSetBinaryStream() {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        Assertions.assertThrows(SQLException.class, () -> ((SQLXMLImpl)xml).setBinaryStream());
    }

    @Test
    public void testSetCharacterStream() {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        Assertions.assertThrows(SQLException.class, () -> ((SQLXMLImpl)xml).setCharacterStream());
    }

    @Test
    public void testSetString() {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        Assertions.assertThrows(SQLException.class, () -> xml.setString(this.testStr));
    }

    @Test
    public void testGetString1() throws Exception {
        SQLXMLImpl clob = new SQLXMLImpl(){

            public Reader getCharacterStream() {
                return new Reader(this){
                    int pos = 0;

                    @Override
                    public void close() {
                    }

                    @Override
                    public int read(char[] cbuf, int off, int len) {
                        if (this.pos < 5) {
                            cbuf[off] = 97;
                            ++this.pos;
                            return 1;
                        }
                        return -1;
                    }
                };
            }
        };
        Assertions.assertEquals((Object)"aaaaa", (Object)clob.getString());
    }
}

