/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types;

import com.kubling.teiid.core.types.InputStreamFactory;
import com.kubling.teiid.core.types.SQLXMLImpl;
import com.kubling.teiid.core.types.Streamable;
import com.kubling.teiid.core.types.XMLType;
import com.kubling.teiid.core.util.UnitTestUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.sql.SQLXML;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestXMLValue {
    @Test
    public void testXMLValue() throws Exception {
        String testString = "<foo>this is an xml value test</foo>";
        SQLXMLImpl xml = new SQLXMLImpl(testString);
        XMLType xv = new XMLType((SQLXML)xml);
        Assertions.assertEquals((Object)testString, (Object)xv.getString());
    }

    @Test
    public void testXMLValuePersistence() throws Exception {
        String testString = "<foo>this is an xml value test</foo>";
        SQLXMLImpl xml = new SQLXMLImpl(testString);
        XMLType xv = new XMLType((SQLXML)xml);
        String key = xv.getReferenceStreamId();
        XMLType read = UnitTestUtil.helpSerialize(xv);
        Assertions.assertEquals((Object)key, (Object)read.getReferenceStreamId());
        Assertions.assertNull((Object)read.getReference());
    }

    @Test
    public void testReferencePersistence() throws Exception {
        String testString = "<foo>this is an xml value test</foo>";
        SQLXMLImpl xml = new SQLXMLImpl(testString);
        XMLType xv = new XMLType((SQLXML)xml);
        xv.setReferenceStreamId(null);
        XMLType read = UnitTestUtil.helpSerialize(xv);
        Assertions.assertEquals((Object)testString, (Object)read.getString());
    }

    @Test
    public void testLength() throws Exception {
        String testString = "<foo>this is an xml value test</foo>";
        SQLXMLImpl xml = new SQLXMLImpl(testString);
        XMLType xv = new XMLType((SQLXML)xml);
        Assertions.assertEquals((long)36L, (long)xv.length());
        xml = new SQLXMLImpl(new InputStreamFactory(this){

            public InputStream getInputStream() {
                return new ByteArrayInputStream("<bar/>".getBytes(Streamable.CHARSET));
            }
        });
        xv = new XMLType((SQLXML)xml);
        try {
            xv.length();
            Assertions.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

