/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.util;

import com.kubling.teiid.core.CorePlugin;
import com.kubling.teiid.core.TeiidException;
import com.kubling.teiid.core.util.FileUtils;
import com.kubling.teiid.core.util.ObjectConverterUtil;
import com.kubling.teiid.core.util.UnitTestUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public final class TestFileUtils {
    private static final String FILE_NAME = UnitTestUtil.getTestDataPath() + File.separator + "fakeScript.txt";
    private static final String TEMP_DIR_NAME = "tempdir";
    File tempDir;
    public static final String TEMP_FILE = "delete.me";
    public static final String TEMP_FILE_RENAMED = "delete.me.old";
    private static final String TEMP_FILE_NAME = UnitTestUtil.getTestDataPath() + File.separator + "tempfile.txt";
    private static final String TEMP_FILE_NAME2 = "tempfile2.txt";

    @BeforeEach
    public void setUp() {
        this.tempDir = new File(TEMP_DIR_NAME);
        this.tempDir.mkdir();
    }

    @AfterEach
    public void tearDown() {
        try {
            this.tempDir.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new File(TEMP_FILE_NAME).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            new File(TEMP_FILE_NAME2).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testTestDirectoryPermissions() throws Exception {
        TestFileUtils.testDirectoryPermissions(TEMP_DIR_NAME);
        try {
            TestFileUtils.testDirectoryPermissions("fakeDir");
            Assertions.fail((String)"Expected a MetaMatrixCoreException");
        }
        catch (TeiidException teiidException) {
            // empty catch block
        }
    }

    @Test
    public void testRemove() throws Exception {
        ObjectConverterUtil.write((InputStream)new FileInputStream(FILE_NAME), (String)TEMP_FILE_NAME);
        FileUtils.remove((File)new File(TEMP_FILE_NAME));
        Assertions.assertFalse((boolean)new File(TEMP_FILE_NAME).exists(), (String)"Expected File to not exist");
        FileUtils.remove((File)new File(TEMP_FILE_NAME));
    }

    public static void testDirectoryPermissions(String dirPath) throws TeiidException {
        File tmpFile = new File(dirPath + File.separatorChar + TEMP_FILE);
        boolean success = false;
        try {
            success = tmpFile.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!success) {
            throw new TeiidException("cannot create file in " + dirPath);
        }
        if (!tmpFile.canWrite()) {
            throw new TeiidException("cannot write " + dirPath);
        }
        if (!tmpFile.canRead()) {
            throw new TeiidException("cannot read " + dirPath);
        }
        File newFile = new File(dirPath + File.separatorChar + TEMP_FILE_RENAMED);
        success = false;
        try {
            success = tmpFile.renameTo(newFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!success) {
            throw new TeiidException("failed to rename " + dirPath);
        }
        success = false;
        try {
            success = newFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!success) {
            String msg = CorePlugin.Util.getString("FileUtils.Unable_to_delete_file_in", new Object[]{dirPath});
            throw new TeiidException(msg);
        }
    }
}

