/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.util;

import com.kubling.teiid.core.util.ObjectConverterUtil;
import com.kubling.teiid.core.util.ReaderInputStream;
import com.kubling.teiid.core.util.UnitTestUtil;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestReaderInputStream {
    @Test
    public void testUTF8() throws Exception {
        int value;
        FileInputStream fis = new FileInputStream(UnitTestUtil.getTestDataFile("legal_notice.xml"));
        ReaderInputStream ris = new ReaderInputStream((Reader)new FileReader(UnitTestUtil.getTestDataFile("legal_notice.xml")), StandardCharsets.UTF_8);
        do {
            value = fis.read();
            Assertions.assertEquals((int)value, (int)ris.read());
        } while (value != -1);
    }

    @Test
    public void testUTF16() throws Exception {
        String actual = "!?abc";
        ReaderInputStream ris = new ReaderInputStream((Reader)new StringReader(actual), StandardCharsets.UTF_16.newEncoder(), 2);
        byte[] result = ObjectConverterUtil.convertToByteArray((InputStream)ris);
        String resultString = new String(result, StandardCharsets.UTF_16);
        Assertions.assertEquals((Object)resultString, (Object)actual);
    }

    @Test
    public void testASCII() throws Exception {
        String actual = "!?abc";
        ReaderInputStream ris = new ReaderInputStream((Reader)new StringReader(actual), StandardCharsets.US_ASCII.newEncoder(), 1);
        byte[] result = ObjectConverterUtil.convertToByteArray((InputStream)ris);
        String resultString = new String(result, StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)resultString, (Object)actual);
    }

    @Test
    public void testASCIIError() {
        String actual = "!?abc\uffffafs";
        Charset cs = StandardCharsets.US_ASCII;
        ReaderInputStream ris = new ReaderInputStream((Reader)new StringReader(actual), cs.newEncoder(), 1);
        Assertions.assertThrows(IOException.class, () -> ObjectConverterUtil.convertToByteArray((InputStream)ris));
    }
}

