/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core;

import com.kubling.teiid.core.BundleUtil;
import com.kubling.teiid.core.TeiidException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMetaMatrixException {
    @Test
    public void testMetaMatrixExceptionWithNullThrowable() {
        TeiidException err = new TeiidException((Throwable)null);
        Assertions.assertNull((Object)err.getCode());
        Assertions.assertNull((Object)err.getMessage());
    }

    @Test
    public void testMetaMatrixExceptionWithMessage() {
        TeiidException err = new TeiidException("Test");
        Assertions.assertNull((Object)err.getCode());
        Assertions.assertEquals((Object)"Test", (Object)err.getMessage());
    }

    @Test
    public void testMetaMatrixExceptionWithCodeAndMessage() {
        TeiidException err = new TeiidException((BundleUtil.Event)Event.Code, "Test");
        Assertions.assertEquals((Object)"Code", (Object)err.getCode());
        Assertions.assertEquals((Object)"Code Test", (Object)err.getMessage());
    }

    @Test
    public void testMetaMatrixExceptionWithExceptionAndMessage() {
        TeiidException child = new TeiidException((BundleUtil.Event)Event.propertyValuePhrase, "Child");
        TeiidException err = new TeiidException((Throwable)child, "Test");
        Assertions.assertEquals((Object)"propertyValuePhrase", (Object)err.getCode());
        Assertions.assertEquals((Object)"propertyValuePhrase Test", (Object)err.getMessage());
    }

    @Test
    public void testMetaMatrixExceptionWithExceptionAndCodeAndMessage() {
        TeiidException child = new TeiidException((BundleUtil.Event)Event.propertyValuePhrase, "Child");
        TeiidException err = new TeiidException((BundleUtil.Event)Event.Code, (Throwable)child, "Test");
        Assertions.assertEquals((Object)"Code", (Object)err.getCode());
        Assertions.assertEquals((Object)"Code Test", (Object)err.getMessage());
    }

    public static enum Event implements BundleUtil.Event
    {
        Code,
        propertyValuePhrase;

    }
}

