/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.crypto;

import com.kubling.teiid.core.crypto.CryptoException;
import com.kubling.teiid.core.crypto.DhKeyGenerator;
import com.kubling.teiid.core.crypto.SymmetricCryptor;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDhKeyGenerator {
    @Test
    public void testKeyGenerationDefault() throws CryptoException {
        DhKeyGenerator keyGenServer = new DhKeyGenerator();
        DhKeyGenerator keyGenClient = new DhKeyGenerator();
        byte[] serverKey = keyGenServer.createPublicKey(true);
        byte[] clientKey = keyGenClient.createPublicKey(true);
        SymmetricCryptor serverCryptor = keyGenServer.getSymmetricCryptor(clientKey, false, TestDhKeyGenerator.class.getClassLoader(), true, true);
        SymmetricCryptor clientCryptor = keyGenClient.getSymmetricCryptor(serverKey, false, TestDhKeyGenerator.class.getClassLoader(), true, true);
        String cleartext = "cleartext!";
        byte[] ciphertext = serverCryptor.encrypt(cleartext.getBytes(StandardCharsets.UTF_8));
        byte[] cleartext2 = clientCryptor.decrypt(ciphertext);
        Assertions.assertArrayEquals((byte[])cleartext.getBytes(StandardCharsets.UTF_8), (byte[])cleartext2);
        Object sealed = serverCryptor.sealObject((Object)cleartext);
        Object unsealed = clientCryptor.unsealObject(sealed);
        Assertions.assertEquals((Object)cleartext, (Object)unsealed);
        Assertions.assertNotEquals((Object)sealed, (Object)unsealed);
    }
}

