/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.json.unflattener;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.wnameless.json.base.GsonJsonCore;
import com.github.wnameless.json.base.JacksonJsonCore;
import com.github.wnameless.json.base.JsonCore;
import com.github.wnameless.json.base.JsonPrinter;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.kubling.teiid.core.json.flattener.FlattenMode;
import com.kubling.teiid.core.json.flattener.PrintMode;
import com.kubling.teiid.core.json.unflattener.JsonUnflattener;
import com.kubling.teiid.core.json.unflattener.JsonUnflattenerFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JsonUnflattenerFactoryTest {
    Consumer<JsonUnflattener> configurer;
    JsonCore<?> jsonCore;
    JsonUnflattenerFactory jsonUnflattenerFactory;
    static String expectedJson;

    @BeforeAll
    public static void init() throws IOException {
        URL url = Resources.getResource((String)"test_mongo.json");
        expectedJson = JsonPrinter.prettyPrint((String)Resources.toString((URL)url, (Charset)Charsets.UTF_8));
    }

    @BeforeEach
    public void setUp() {
        this.configurer = ju -> {
            ju.withFlattenMode(FlattenMode.MONGODB);
            ju.withPrintMode(PrintMode.PRETTY);
        };
        this.jsonCore = new GsonJsonCore();
        this.jsonUnflattenerFactory = new JsonUnflattenerFactory(this.configurer, this.jsonCore);
    }

    @Test
    public void testBuildWithJSONString() throws IOException {
        URL url = Resources.getResource((String)"test_mongo_flattened.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        JsonUnflattener ju = this.jsonUnflattenerFactory.build(json);
        Assertions.assertEquals((Object)expectedJson, (Object)ju.unflatten());
        this.jsonUnflattenerFactory = new JsonUnflattenerFactory(this.configurer);
        ju = this.jsonUnflattenerFactory.build(json);
        Assertions.assertEquals((Object)expectedJson, (Object)ju.unflatten());
    }

    @Test
    public void testBuildWithMap() throws IOException {
        URL url = Resources.getResource((String)"test_mongo_flattened.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        JsonUnflattener ju = this.jsonUnflattenerFactory.build((Map)new ObjectMapper().readValue(json, Map.class));
        Assertions.assertEquals((Object)expectedJson, (Object)ju.unflatten());
        this.jsonUnflattenerFactory = new JsonUnflattenerFactory(this.configurer);
        ju = this.jsonUnflattenerFactory.build((Map)new ObjectMapper().readValue(json, Map.class));
        Assertions.assertEquals((Object)expectedJson, (Object)ju.unflatten());
    }

    @Test
    public void testBuildWithJsonReader() throws IOException {
        URL url = Resources.getResource((String)"test_mongo_flattened.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        JsonUnflattener ju = this.jsonUnflattenerFactory.build((Reader)new StringReader(json));
        Assertions.assertEquals((Object)expectedJson, (Object)ju.unflatten());
        this.jsonUnflattenerFactory = new JsonUnflattenerFactory(this.configurer);
        ju = this.jsonUnflattenerFactory.build((Reader)new StringReader(json));
        Assertions.assertEquals((Object)expectedJson, (Object)ju.unflatten());
    }

    @Test
    public void testHashCode() {
        int result = 27;
        result = 31 * result + this.configurer.hashCode();
        result = 31 * result + this.jsonCore.hashCode();
        Assertions.assertEquals((int)result, (int)this.jsonUnflattenerFactory.hashCode());
        this.configurer = ju -> ju.withPrintMode(PrintMode.PRETTY);
        this.jsonCore = new JacksonJsonCore();
        this.jsonUnflattenerFactory = new JsonUnflattenerFactory(this.configurer, this.jsonCore);
        Assertions.assertNotEquals((int)result, (int)this.jsonUnflattenerFactory.hashCode());
    }

    @Test
    public void testEquals() {
        Assertions.assertEquals((Object)this.jsonUnflattenerFactory, (Object)this.jsonUnflattenerFactory);
        JsonUnflattenerFactory otherJsonUnflattenerFactory = new JsonUnflattenerFactory(this.configurer, this.jsonCore);
        Assertions.assertEquals((Object)this.jsonUnflattenerFactory, (Object)otherJsonUnflattenerFactory);
        otherJsonUnflattenerFactory = new JsonUnflattenerFactory(this.configurer);
        Assertions.assertNotEquals((Object)this.jsonUnflattenerFactory, (Object)otherJsonUnflattenerFactory);
        this.jsonCore = new JacksonJsonCore();
        otherJsonUnflattenerFactory = new JsonUnflattenerFactory(this.configurer, this.jsonCore);
        Assertions.assertNotEquals((Object)this.jsonUnflattenerFactory, (Object)otherJsonUnflattenerFactory);
        this.configurer = ju -> ju.withPrintMode(PrintMode.MINIMAL);
        otherJsonUnflattenerFactory = new JsonUnflattenerFactory(this.configurer, this.jsonCore);
        Assertions.assertNotEquals((Object)this.jsonUnflattenerFactory, (Object)otherJsonUnflattenerFactory);
        Assertions.assertNotEquals((Object)this.jsonUnflattenerFactory, null);
    }

    @Test
    public void testToString() {
        this.jsonUnflattenerFactory = new JsonUnflattenerFactory(this.configurer);
        Assertions.assertEquals((Object)("JsonUnflattenerFactory{configurer=" + this.configurer.toString() + ", jsonCore=" + String.valueOf(Optional.empty()) + "}"), (Object)this.jsonUnflattenerFactory.toString());
        this.jsonCore = new GsonJsonCore();
        this.jsonUnflattenerFactory = new JsonUnflattenerFactory(this.configurer, this.jsonCore);
        Assertions.assertEquals((Object)("JsonUnflattenerFactory{configurer=" + this.configurer.toString() + ", jsonCore=" + String.valueOf(Optional.of(this.jsonCore)) + "}"), (Object)this.jsonUnflattenerFactory.toString());
    }
}

