/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types;

import com.kubling.teiid.core.types.BaseClobType;
import com.kubling.teiid.core.types.ClobImpl;
import com.kubling.teiid.core.types.ClobType;
import com.kubling.teiid.core.util.UnitTestUtil;
import java.io.Reader;
import java.sql.Clob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestClobValue {
    @Test
    public void testClobValue() throws Exception {
        String testString = "this is test clob";
        SerialClob clob = new SerialClob(testString.toCharArray());
        ClobType cv = new ClobType((Clob)clob);
        Assertions.assertEquals((Object)testString, (Object)cv.getSubString(1L, (int)cv.length()));
    }

    @Test
    public void testClobValuePersistence() throws Exception {
        String testString = "this is test clob";
        SerialClob clob = new SerialClob(testString.toCharArray());
        ClobType cv = new ClobType((Clob)clob);
        String key = cv.getReferenceStreamId();
        ClobType read = UnitTestUtil.helpSerialize(cv);
        Assertions.assertTrue((read.length() > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((Object)key, (Object)read.getReferenceStreamId());
        Assertions.assertNull((Object)read.getReference());
    }

    @Test
    public void testReferencePersistence() throws Exception {
        String testString = "this is test clob";
        SerialClob clob = new SerialClob(testString.toCharArray());
        ClobType cv = new ClobType((Clob)clob);
        cv.setReferenceStreamId(null);
        ClobType read = UnitTestUtil.helpSerialize(cv);
        Assertions.assertTrue((read.length() > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((Object)testString, (Object)read.getSubString(1L, testString.length()));
    }

    @Test
    public void testReferencePersistenceError() throws Exception {
        String testString = "this is test clob";
        SerialClob clob = new SerialClob(testString.toCharArray()){

            @Override
            public Reader getCharacterStream() throws SerialException {
                throw new SerialException();
            }
        };
        ClobType cv = new ClobType((Clob)clob);
        cv.setReferenceStreamId(null);
        ClobType read = UnitTestUtil.helpSerialize(cv);
        Assertions.assertTrue((read.length() > 0L ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)read.getReferenceStreamId());
        Assertions.assertNull((Object)read.getReference());
    }

    @Test
    public void testClobSubstring() throws Exception {
        ClobImpl clob = new ClobImpl(){

            public Reader getCharacterStream() {
                return new Reader(this){
                    int pos = 0;

                    @Override
                    public void close() {
                    }

                    @Override
                    public int read(char[] cbuf, int off, int len) {
                        if (this.pos < 2) {
                            cbuf[off] = 97;
                            ++this.pos;
                            return 1;
                        }
                        return -1;
                    }
                };
            }
        };
        Assertions.assertEquals((Object)"aa", (Object)clob.getSubString(1L, 3));
        Assertions.assertEquals((Object)"", (Object)clob.getSubString(1L, 0));
        clob = new ClobImpl("hello world");
        Assertions.assertEquals((Object)"hel", (Object)clob.getSubString(1L, 3));
        Assertions.assertEquals((Object)"orld", (Object)clob.getSubString(8L, 5));
    }

    @Test
    public void testClobCompare() throws Exception {
        String testString = "this is test clob";
        SerialClob clob = new SerialClob(testString.toCharArray());
        ClobType ct = new ClobType((Clob)clob);
        SerialClob clob1 = new SerialClob(testString.toCharArray());
        ClobType ct1 = new ClobType((Clob)clob1);
        Assertions.assertEquals((int)0, (int)ct1.compareTo((BaseClobType)ct));
    }

    @Test
    public void testClobHashError() throws Exception {
        String testString = "this is test clob";
        SerialClob clob = new SerialClob(testString.toCharArray());
        clob.free();
        ClobType ct = new ClobType((Clob)clob);
        Assertions.assertEquals((int)0, (int)ct.hashCode());
    }

    @Test
    public void testClobPosition() throws Exception {
        String testString = "this is \u10000 test clob";
        ClobImpl clobImpl = new ClobImpl(testString);
        Assertions.assertEquals((long)testString.indexOf("test"), (long)(clobImpl.position("test", 2L) - 1L));
    }
}

