/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;

public class UnitTestUtil {
    public static final String PATH_SEPARATOR = "/";
    private static final String DEFAULT_TESTDATA_PATH = "src/test/resources";
    private static final String DEFAULT_TEMP_DIR = "scratch";
    static Map<String, Logger> loggers = new HashMap<String, Logger>();

    public static void helpTestEquivalence(int correctCompareToResult, Object obj1, Object obj2) {
        if (obj1 != null) {
            boolean equal;
            if (obj2 != null) {
                UnitTestUtil.helpTestEquals(obj1);
                UnitTestUtil.helpTestEqualsTransitivity(obj1, obj2);
            }
            if (equal = obj1.equals(obj2)) {
                if (correctCompareToResult != 0) {
                    Assertions.fail((String)"obj1.equals(obj2) returned true but was expected to return false");
                }
            } else if (correctCompareToResult == 0) {
                Assertions.fail((String)"obj1.equals(obj2) returned false but was expected to return true");
            }
            UnitTestUtil.helpTestHashCode(equal, obj1, obj2);
        }
        if (obj2 != null) {
            UnitTestUtil.helpTestEquals(obj2);
        }
        if (obj1 instanceof Comparable || obj2 instanceof Comparable) {
            Comparable comp1 = (Comparable)obj1;
            Comparable comp2 = (Comparable)obj2;
            UnitTestUtil.helpTestCompareTo(correctCompareToResult, comp1, comp2);
            UnitTestUtil.helpTestReflexiveCompareTo(comp1);
            UnitTestUtil.helpTestReflexiveCompareTo(comp2);
        }
    }

    protected static void helpTestCompareTo(int correctCompareToResult, Comparable obj1, Comparable obj2) {
        if (obj1 != null) {
            if (obj2 != null) {
                int result2;
                int result1 = obj1.compareTo(obj2);
                if (result1 != (result2 = obj2.compareTo(obj1))) {
                    if (result1 < 0) {
                        if (correctCompareToResult >= 0) {
                            Assertions.fail((String)("obj1.compareTo(obj2) returned <0 (actual=" + result1 + ") and did not match the expected result (" + correctCompareToResult + ")"));
                        }
                        if (result2 <= 0) {
                            Assertions.fail((String)("The compareTo call was not commutative: obj1.compareTo(obj2) returned <0 (actual=" + result1 + ") but obj2.compareTo(obj2) did not return >0 (actual=" + result2 + ") "));
                        }
                    } else if (result1 > 0) {
                        if (correctCompareToResult <= 0) {
                            Assertions.fail((String)("obj1.compareTo(obj2) returned >0 (actual=" + result1 + ") and did not match the expected result (" + correctCompareToResult + ")"));
                        }
                        if (result2 >= 0) {
                            Assertions.fail((String)("The compareTo call was not commutative: obj1.compareTo(obj2) returned >0 (actual=" + result1 + ") but obj2.compareTo(obj2) did not return <0 (actual=" + result2 + ") "));
                        }
                    } else {
                        if (correctCompareToResult != 0) {
                            Assertions.fail((String)("obj1.compareTo(obj2) returned 0 but did not match the expected result (" + correctCompareToResult + ") and the second compareTo call didn't match the first"));
                        }
                        Assertions.fail((String)("The compareTo call was not commutative: obj1.compareTo(obj2) returned 0 while obj2.compareTo(obj2) returned " + result2));
                    }
                } else if (correctCompareToResult != 0) {
                    Assertions.fail((String)("obj1.compareTo(obj2) and obj2.compareTo(obj1) both returned " + result1 + " but did not match the expected result (" + correctCompareToResult + ")"));
                }
            } else {
                int result = 0;
                try {
                    result = obj1.compareTo(obj2);
                    Assertions.fail((String)("The second comparable object was null but no IllegalArgumentException was thrown in " + obj1.getClass().getName() + ".compareTo(Object)"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (correctCompareToResult <= 0) {
                    Assertions.fail((String)("obj1.compareTo(null) returned " + result + " but did not match the expected result (" + correctCompareToResult + ")"));
                }
            }
        } else if (obj2 != null) {
            int result = 0;
            try {
                result = obj2.compareTo(obj1);
                Assertions.fail((String)("The first comparable object was null but no IllegalArgumentException was thrown in " + obj2.getClass().getName() + ".compareTo(Object)"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (correctCompareToResult >= 0) {
                Assertions.fail((String)("obj2.compareTo(null) returned " + result + " but did not match the expected result (" + correctCompareToResult + ")"));
            }
        } else if (correctCompareToResult != 0) {
            Assertions.fail((String)"The expected result was not 0 even though both references were null");
        }
    }

    protected static void helpTestEquals(Object obj) {
        Assertions.assertNotNull((Object)obj);
        Assertions.assertFalse((boolean)obj.equals(null), (String)("The equals method of Object " + String.valueOf(obj) + " (Class " + obj.getClass().getName() + ") does not return false for null parameter"));
        Assertions.assertEquals((Object)obj, (Object)obj, (String)("The equals method of Object " + String.valueOf(obj) + " (Class " + obj.getClass().getName() + ") is not reflexive."));
    }

    protected static void helpTestEqualsTransitivity(Object test, Object control) {
        Assertions.assertNotNull((Object)test);
        Assertions.assertNotNull((Object)control);
        Assertions.assertEquals((Object)test.equals(control), (Object)control.equals(test), (String)("Equals methods of test Object and control Object are not symmetric: " + String.valueOf(test) + ", " + String.valueOf(control)));
    }

    protected static void helpTestHashCode(boolean shouldBeEqual, Object obj1, Object obj2) {
        if (obj1 != null && obj2 != null) {
            int hash1 = obj1.hashCode();
            int hash2 = obj2.hashCode();
            if (shouldBeEqual) {
                Assertions.assertEquals((int)hash1, (int)hash2, (String)("The two objects are supposed to be equal but do not have the same hash code value; obj1.hashCode()=" + hash1 + "; obj2.hashCode()=" + hash2));
            }
        }
    }

    protected static void helpTestReflexiveCompareTo(Comparable obj) {
        if (obj != null && obj.compareTo(obj) != 0) {
            Assertions.fail((String)"The compareTo method is not reflexive; obj.compareTo(obj) does not equal 0");
        }
    }

    protected UnitTestUtil() {
    }

    public static File getTestDataFile(String fileName) {
        return new File(UnitTestUtil.getTestDataPath(), fileName);
    }

    public static File getTargetTestDirDataFile(String fileName) {
        return new File("test-classes", fileName);
    }

    public static File getTestScratchFile(String fileName) {
        String path = UnitTestUtil.getTestScratchPath();
        return new File(path, fileName);
    }

    public static String getTestDataPath() {
        return DEFAULT_TESTDATA_PATH;
    }

    public static String getTestScratchPath() {
        File scratchDirectory;
        String filePath = DEFAULT_TEMP_DIR;
        File scratch = new File(filePath);
        if (!scratch.exists() && !scratch.mkdirs() && (filePath = System.getProperty("java.io.tmpdir")) == null) {
            filePath = ".";
        }
        if (!(scratchDirectory = new File(filePath)).exists()) {
            scratchDirectory.mkdir();
        }
        return filePath;
    }

    public static <T extends Serializable> T helpSerialize(T object) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        return (T)((Serializable)ois.readObject());
    }

    public static void enableTraceLogging(String loggerName) {
        UnitTestUtil.enableLogging(Level.FINEST, loggerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableLogging(Level level, String loggerName) {
        Handler[] handlerArray = loggers;
        synchronized (loggers) {
            Logger logger = loggers.get(loggerName);
            if (logger == null) {
                logger = Logger.getLogger(loggerName);
                loggers.put(loggerName, logger);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            logger.setLevel(level);
            if (logger.getHandlers().length > 0) {
                for (Handler h : logger.getHandlers()) {
                    h.setLevel(level);
                }
            } else {
                logger.setUseParentHandlers(false);
                ConsoleHandler ch = new ConsoleHandler();
                ch.setFormatter(new LogFormatter());
                ch.setLevel(level);
                logger.addHandler(ch);
            }
            return;
        }
    }

    public static final class LogFormatter
    extends Formatter {
        @Override
        public String format(LogRecord record) {
            final StringBuilder result = new StringBuilder();
            result.append(new Timestamp(record.getMillis()));
            result.append(" ");
            result.append(record.getLoggerName());
            result.append(" ");
            result.append(record.getLevel());
            result.append(" ");
            result.append(Thread.currentThread().getName());
            result.append(" ");
            result.append(record.getMessage());
            result.append('\n');
            if (record.getThrown() != null) {
                record.getThrown().printStackTrace(new PrintWriter(new Writer(this){

                    @Override
                    public void close() {
                    }

                    @Override
                    public void flush() {
                    }

                    @Override
                    public void write(char[] cbuf, int off, int len) {
                        result.append(new String(cbuf, off, len));
                    }
                }));
                result.append('\n');
            }
            return result.toString();
        }
    }
}

