/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types;

import com.kubling.teiid.core.BundleUtil;
import com.kubling.teiid.core.CorePlugin;
import com.kubling.teiid.core.TeiidRuntimeException;
import com.kubling.teiid.core.types.ClobImpl;
import com.kubling.teiid.core.types.Sequencable;
import com.kubling.teiid.core.types.Streamable;
import com.kubling.teiid.core.util.EquivalenceUtil;
import com.kubling.teiid.core.util.HashCodeUtil;
import com.kubling.teiid.core.util.ObjectConverterUtil;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;

public class BaseClobType
extends Streamable<Clob>
implements NClob,
Sequencable,
Comparable<BaseClobType> {
    private static final long serialVersionUID = 2753412502127824104L;
    private int hash;
    private static final int CHAR_SEQUENCE_BUFFER_SIZE = 4096;

    public BaseClobType() {
    }

    public BaseClobType(Clob clob) {
        super(clob);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return ((Clob)this.reference).getAsciiStream();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return ((Clob)this.reference).getCharacterStream();
    }

    @Override
    public String getSubString(long pos, int len) throws SQLException {
        return ((Clob)this.reference).getSubString(pos, len);
    }

    @Override
    long computeLength() throws SQLException {
        return ((Clob)this.reference).length();
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        return ((Clob)this.reference).position(searchstr, start);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        return ((Clob)this.reference).position(searchstr, start);
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        return ((Clob)this.reference).setAsciiStream(pos);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        return ((Clob)this.reference).setCharacterStream(pos);
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        return ((Clob)this.reference).setString(pos, str, offset, len);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return ((Clob)this.reference).setString(pos, str);
    }

    @Override
    public void truncate(long len) throws SQLException {
        ((Clob)this.reference).truncate(len);
    }

    public static String getString(Clob clob) throws SQLException, IOException {
        try (Reader reader = clob.getCharacterStream();){
            StringWriter writer = new StringWriter();
            int c = reader.read();
            while (c != -1) {
                writer.write((char)c);
                c = reader.read();
            }
            reader.close();
            String data = writer.toString();
            writer.close();
            String string = data;
            return string;
        }
    }

    @Override
    public CharSequence getCharSequence() {
        return new CharSequence(){
            private char[] buffer = new char[4096];
            private int bufLength;
            private Reader reader;
            private int beginPosition;

            @Override
            public int length() {
                long result;
                try {
                    result = BaseClobType.this.length();
                }
                catch (SQLException err) {
                    throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10051, (Throwable)err);
                }
                if ((long)((int)result) != result) {
                    throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10052, CorePlugin.Util.gs(CorePlugin.Event.TEIID10052, new Object[0]));
                }
                return (int)result;
            }

            @Override
            public char charAt(int index) {
                try {
                    if ((this.reader == null || index < this.beginPosition) && this.reader != null) {
                        this.reader.close();
                        this.reader = null;
                    }
                    if (this.buffer == null || index < this.beginPosition || index >= this.beginPosition + this.bufLength) {
                        if (BaseClobType.this.reference instanceof ClobImpl) {
                            if (this.reader == null) {
                                this.reader = BaseClobType.this.getCharacterStream();
                            }
                            this.bufLength = this.reader.read(this.buffer, 0, this.buffer.length);
                        } else {
                            String stringBuffer = BaseClobType.this.getSubString(index + 1, 4096);
                            this.bufLength = stringBuffer.length();
                            this.buffer = stringBuffer.toCharArray();
                        }
                        this.beginPosition = index;
                    }
                    return this.buffer[index - this.beginPosition];
                }
                catch (IOException | SQLException err) {
                    throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10053, (Throwable)err);
                }
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                try {
                    return BaseClobType.this.getSubString(start + 1, end - start);
                }
                catch (SQLException err) {
                    throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10054, (Throwable)err);
                }
            }
        };
    }

    @Override
    public void free() throws SQLException {
        ((Clob)this.reference).free();
    }

    @Override
    public Reader getCharacterStream(long pos, long len) throws SQLException {
        return ((Clob)this.reference).getCharacterStream(pos, len);
    }

    @Override
    protected void readReference(ObjectInput in) throws IOException {
        char[] chars = new char[(int)this.length];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = in.readChar();
        }
        this.reference = ClobImpl.createClob(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeReference(final DataOutput out) throws IOException {
        Reader r;
        Writer w = new Writer(this){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                for (int i = off; i < len; ++i) {
                    out.writeChar(cbuf[i]);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
        try {
            r = this.getCharacterStream();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        try {
            int chars = ObjectConverterUtil.write(w, r, (int)this.length, false);
            if (this.length != (long)chars) {
                throw new IOException("Expected length " + this.length + " but was " + chars + " for " + String.valueOf(this.reference));
            }
        }
        finally {
            r.close();
        }
    }

    @Override
    public int compareTo(BaseClobType o) {
        try {
            Reader cs1 = this.getCharacterStream();
            Reader cs2 = o.getCharacterStream();
            long len1 = this.length();
            long len2 = o.length();
            long n = Math.min(len1, len2);
            for (long i = 0L; i < n; ++i) {
                int c2;
                int c1 = cs1.read();
                if (c1 == (c2 = cs2.read())) continue;
                return c1 - c2;
            }
            return Long.signum(len1 - len2);
        }
        catch (SQLException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10056, (Throwable)e);
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10057, (Throwable)e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BaseClobType)) {
            return false;
        }
        BaseClobType other = (BaseClobType)obj;
        if (EquivalenceUtil.areEqual(this.reference, other.reference)) {
            return true;
        }
        try {
            if (this.length() != other.length()) {
                return false;
            }
            return this.compareTo(other) == 0;
        }
        catch (TeiidRuntimeException | SQLException e) {
            return false;
        }
    }

    public int hashCode() {
        try {
            if (this.hash == 0) {
                this.hash = HashCodeUtil.expHashCode(this.getCharSequence());
            }
            return this.hash;
        }
        catch (TeiidRuntimeException e) {
            return 0;
        }
    }
}

