/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types.basic;

import com.kubling.teiid.core.types.DataTypeManager;
import com.kubling.teiid.core.types.Transform;
import com.kubling.teiid.core.types.TransformationException;

public class AnyToStringTransform
extends Transform {
    private final Class<?> sourceType;

    public AnyToStringTransform(Class<?> sourceType) {
        this.sourceType = sourceType;
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public Class<?> getTargetType() {
        return String.class;
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        String result = value.toString();
        if (result != null && result.length() > DataTypeManager.MAX_STRING_LENGTH) {
            return result.substring(0, DataTypeManager.MAX_STRING_LENGTH);
        }
        return result;
    }
}

