/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.util;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class FilesystemHelper {
    public static final long TRANSFER_SIZE = 8192L;
    private static FileSystemManager manager;

    public static synchronized FileSystemManager getManager() throws FileSystemException {
        if (Objects.nonNull(manager)) {
            return manager;
        }
        StandardFileSystemManager localManager = new StandardFileSystemManager();
        localManager.setConfiguration(Thread.currentThread().getContextClassLoader().getResource("com/kubling/teiid/core/providers.xml"));
        localManager.init();
        manager = localManager;
        return manager;
    }

    public static FileChannel newFileChannel(URI uri, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (Objects.isNull(manager)) {
            manager = FilesystemHelper.getManager();
        }
        FileObject fileObject = manager.resolveFile(uri);
        if (options.contains(StandardOpenOption.CREATE_NEW) && fileObject.exists()) {
            throw new FileAlreadyExistsException(uri.toString());
        }
        if (!fileObject.exists() && (options.contains(StandardOpenOption.CREATE_NEW) || options.contains(StandardOpenOption.CREATE))) {
            fileObject.createFile();
        }
        FileContent content = fileObject.getContent();
        final RandomAccessContent rac = content.getRandomAccessContent(FilesystemHelper.toRandomAccessMode(options));
        return new FileChannel(){

            @Override
            public int read(ByteBuffer dst) throws IOException {
                byte[] arr = new byte[dst.remaining()];
                int r = rac.getInputStream().read(arr, 0, arr.length);
                if (r > 0) {
                    dst.put(arr, 0, r);
                }
                return r;
            }

            @Override
            public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
                long t = 0L;
                for (ByteBuffer dst : dsts) {
                    byte[] arr = new byte[dst.remaining()];
                    int r = rac.getInputStream().read(arr, offset, length);
                    if (r > 0) {
                        dst.put(arr, 0, r);
                    }
                    t += (long)r;
                }
                return t;
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                byte[] arr = new byte[src.remaining()];
                src.get(arr);
                rac.write(arr);
                return arr.length;
            }

            @Override
            public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
                long t = 0L;
                for (ByteBuffer src : srcs) {
                    byte[] arr = new byte[src.remaining()];
                    src.get(arr);
                    rac.write(arr, offset, length);
                    t += (long)arr.length;
                }
                return t;
            }

            @Override
            public long position() throws IOException {
                return rac.getFilePointer();
            }

            @Override
            public FileChannel position(long newPosition) throws IOException {
                rac.seek(newPosition);
                return this;
            }

            @Override
            public long size() throws IOException {
                return rac.length();
            }

            @Override
            public FileChannel truncate(long size) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void force(boolean metaData) {
            }

            @Override
            public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
                int c = (int)Math.min(count, 8192L);
                ByteBuffer bb = ByteBuffer.allocate(c);
                long tw = 0L;
                long pos = position;
                try {
                    while (tw < count) {
                        bb.limit((int)Math.min(count - tw, 8192L));
                        int nr = this.read(bb, pos);
                        if (nr <= 0) break;
                        bb.flip();
                        int nw = target.write(bb);
                        tw += (long)nw;
                        if (nw != nr) break;
                        pos += (long)nw;
                        bb.clear();
                    }
                    return tw;
                }
                catch (IOException x) {
                    if (tw > 0L) {
                        return tw;
                    }
                    throw x;
                }
            }

            @Override
            public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
                int c = (int)Math.min(count, 8192L);
                ByteBuffer bb = ByteBuffer.allocate(c);
                long tw = 0L;
                long pos = position;
                try {
                    while (tw < count) {
                        bb.limit((int)Math.min(count - tw, 8192L));
                        int nr = src.read(bb);
                        if (nr <= 0) break;
                        bb.flip();
                        int nw = this.write(bb, pos);
                        tw += (long)nw;
                        if (nw != nr) break;
                        pos += (long)nw;
                        bb.clear();
                    }
                    return tw;
                }
                catch (IOException x) {
                    if (tw > 0L) {
                        return tw;
                    }
                    throw x;
                }
            }

            @Override
            public int read(ByteBuffer dst, long position) throws IOException {
                this.position(position);
                return this.read(dst);
            }

            @Override
            public int write(ByteBuffer src, long position) throws IOException {
                this.position(position);
                return this.write(src);
            }

            @Override
            public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) {
                throw new UnsupportedOperationException();
            }

            @Override
            public FileLock lock(long position, long size, boolean shared) {
                throw new UnsupportedOperationException();
            }

            @Override
            public FileLock tryLock(long position, long size, boolean shared) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void implCloseChannel() throws IOException {
                rac.close();
            }
        };
    }

    public static RandomAccessMode toRandomAccessMode(Set<? extends OpenOption> options) {
        if (options.contains(StandardOpenOption.WRITE) || options.contains(StandardOpenOption.CREATE) || options.contains(StandardOpenOption.CREATE_NEW)) {
            return RandomAccessMode.READWRITE;
        }
        return RandomAccessMode.READ;
    }

    public static byte[] readFileContentFromZip(String pathToFile, FileObject zipFile) throws IOException {
        pathToFile = StringUtils.removeStart((String)pathToFile, (String)"/");
        String[] children = pathToFile.split("/");
        FileObject pathFo = zipFile;
        FileObject contentFo = null;
        int i = 0;
        for (String c : children) {
            if (Objects.isNull(pathFo)) {
                throw new IOException(String.format("File <<%s>> does not exist in <<%s>>.", pathToFile, zipFile.getName().getFriendlyURI()));
            }
            if (++i == children.length) {
                contentFo = pathFo.getChild(c);
                if (!Objects.isNull(contentFo) && contentFo.exists()) continue;
                throw new IOException(String.format("File <<%s>> does not exist in <<%s>>.", c, zipFile.getName().getFriendlyURI()));
            }
            pathFo = pathFo.getChild(c);
        }
        return contentFo.getContent().getByteArray();
    }

    public static List<String> listFileNameOfDirFromZip(String pathToDir, FileObject zipFile) throws IOException {
        pathToDir = StringUtils.removeStart((String)pathToDir, (String)"/");
        String[] children = pathToDir.split("/");
        FileObject pathFo = zipFile;
        int i = 0;
        for (String c : children) {
            if (Objects.isNull(pathFo)) {
                throw new IOException(String.format("Directory <<%s>> does not exist in <<%s>>.", pathToDir, zipFile.getName().getFriendlyURI()));
            }
            if (++i == children.length) {
                if (!Objects.isNull(pathFo = pathFo.getChild(c)) && pathFo.exists()) continue;
                throw new IOException(String.format("Directory <<%s>> does not exist in <<%s>>.", c, zipFile.getName().getFriendlyURI()));
            }
            pathFo = pathFo.getChild(c);
        }
        return Arrays.stream(pathFo.getChildren()).map(fo -> fo.getName().getBaseName()).collect(Collectors.toList());
    }
}

