/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

@Deprecated
public final class StringUtil {
    public static String join(Collection<String> strings, String delimiter) {
        if (strings == null || delimiter == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        Iterator<String> iter = strings.iterator();
        while (iter.hasNext()) {
            str.append(iter.next());
            if (!iter.hasNext()) continue;
            str.append(delimiter);
        }
        return str.toString();
    }

    public static String toString(Object[] array, String delim) {
        return StringUtil.toString(array, delim, true);
    }

    public static String toString(Object[] array, String delim, boolean includeBrackets) {
        if (array == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (includeBrackets) {
            sb.append('[');
        }
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delim);
            }
            sb.append(array[i]);
        }
        if (includeBrackets) {
            sb.append(']');
        }
        return sb.toString();
    }

    public static String toString(Object[] array) {
        return StringUtil.toString(array, ",", true);
    }

    public static List<String> split(String str, String splitter) {
        StringTokenizer tokens = new StringTokenizer(str, splitter);
        ArrayList<String> l = new ArrayList<String>(tokens.countTokens());
        while (tokens.hasMoreTokens()) {
            l.add(tokens.nextToken());
        }
        return l;
    }

    public static String replace(String source, String search, String replace) {
        int start;
        if (source != null && search != null && search.length() > 0 && replace != null && (start = source.indexOf(search)) > -1) {
            return new StringBuffer(source).replace(start, start + search.length(), replace).toString();
        }
        return source;
    }

    public static String replaceAll(String source, String search, String replace) {
        if (source == null || search == null || search.length() == 0 || replace == null) {
            return source;
        }
        int start = source.indexOf(search);
        if (start > -1) {
            StringBuffer newString = new StringBuffer(source);
            while (start > -1) {
                int end = start + search.length();
                newString.replace(start, end, replace);
                start = newString.indexOf(search, start + replace.length());
            }
            return newString.toString();
        }
        return source;
    }

    public static List<String> getTokens(String str, String delimiter) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(str, delimiter);
        while (tokens.hasMoreTokens()) {
            l.add(tokens.nextToken());
        }
        return l;
    }

    public static String getLastToken(String str, String delimiter) {
        if (str == null) {
            return "";
        }
        int beginIndex = 0;
        if (str.lastIndexOf(delimiter) > 0) {
            beginIndex = str.lastIndexOf(delimiter) + 1;
        }
        return str.substring(beginIndex, str.length());
    }

    public static String getFirstToken(String str, String delimiter) {
        if (str == null) {
            return "";
        }
        int endIndex = str.indexOf(delimiter);
        if (endIndex < 0) {
            endIndex = str.length();
        }
        return str.substring(0, endIndex);
    }

    public static String getStackTrace(Throwable t) {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bas);
        t.printStackTrace(pw);
        pw.close();
        return bas.toString();
    }

    public static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static int indexOfIgnoreCase(String text, String str) {
        if (StringUtil.isEmpty(text)) {
            return -1;
        }
        if (StringUtil.isEmpty(str)) {
            return -1;
        }
        int len = text.length() - str.length();
        for (int i = 0; i <= len; ++i) {
            if (!text.regionMatches(true, i, str, 0, str.length())) continue;
            return i;
        }
        return -1;
    }

    public static boolean startsWithIgnoreCase(String text, String prefix) {
        if (text == null || prefix == null) {
            return false;
        }
        return text.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(String text, String suffix) {
        if (text == null || suffix == null) {
            return false;
        }
        return text.regionMatches(true, text.length() - suffix.length(), suffix, 0, suffix.length());
    }

    private StringUtil() {
    }

    public static boolean isLetter(char c) {
        return StringUtil.isBasicLatinLetter(c) || Character.isLetter(c);
    }

    public static boolean isDigit(char c) {
        return StringUtil.isBasicLatinDigit(c) || Character.isDigit(c);
    }

    public static boolean isLetterOrDigit(char c) {
        return StringUtil.isBasicLatinLetter(c) || StringUtil.isBasicLatinDigit(c) || Character.isLetterOrDigit(c);
    }

    private static boolean isBasicLatinLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isBasicLatinDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static <T> T valueOf(String value, Class type) {
        if (value == null) {
            return null;
        }
        if (type == String.class) {
            return (T)value;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.decode(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.decode(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.decode(value);
        }
        if (type.isAssignableFrom(List.class)) {
            return (T)new ArrayList<String>(Arrays.asList(value.split(",")));
        }
        if (type.isAssignableFrom(Set.class)) {
            return (T)new HashSet<String>(Arrays.asList(value.split(",")));
        }
        if (type.isArray()) {
            String[] values = value.split(",");
            Object array = Array.newInstance(type.getComponentType(), values.length);
            for (int i = 0; i < values.length; ++i) {
                Array.set(array, i, StringUtil.valueOf(values[i], type.getComponentType()));
            }
            return (T)array;
        }
        if (type == Void.class) {
            return null;
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, value);
        }
        if (type == URL.class) {
            try {
                return (T)new URL(value);
            }
            catch (MalformedURLException values) {
            }
        } else if (type.isAssignableFrom(Map.class)) {
            List<String> l = Arrays.asList(value.split(","));
            HashMap<String, String> m = new HashMap<String, String>();
            for (String key : l) {
                int index = key.indexOf(61);
                if (index == -1) continue;
                m.put(key.substring(0, index), key.substring(index + 1));
            }
            return (T)m;
        }
        throw new IllegalArgumentException("Conversion from String to " + type.getName() + " is not supported");
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 != null) {
            return s1.equalsIgnoreCase(s2);
        }
        return s2 == null;
    }

    public static <T extends Enum<T>> T caseInsensitiveValueOf(Class<T> enumType, String name) {
        try {
            return Enum.valueOf(enumType, name);
        }
        catch (IllegalArgumentException e) {
            Enum[] vals;
            for (Enum t : vals = (Enum[])enumType.getEnumConstants()) {
                if (!name.equalsIgnoreCase(t.name())) continue;
                return (T)t;
            }
            throw e;
        }
    }

    public static List<String> tokenize(String str, char delim) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == delim) {
                if (escaped) {
                    current.append(c);
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (escaped && current.length() > 0) {
                result.add(current.toString());
                current.setLength(0);
                escaped = false;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            result.add(current.toString());
        }
        return result;
    }

    public static String unescape(CharSequence string, int quoteChar, boolean useAsciiEscapes, StringBuilder sb) {
        boolean escaped = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (escaped) {
                switch (c) {
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'u': {
                        i = StringUtil.parseNumericValue(string, sb, i, 0, 4, 4);
                        break;
                    }
                    default: {
                        if (c == quoteChar) {
                            sb.append(quoteChar);
                            break;
                        }
                        if (!useAsciiEscapes) break;
                        int value = Character.digit(c, 8);
                        if (value == -1) {
                            sb.append(c);
                            break;
                        }
                        int possibleDigits = value < 3 ? 2 : 1;
                        int radixExp = 3;
                        i = StringUtil.parseNumericValue(string, sb, i, value, possibleDigits, radixExp);
                    }
                }
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == quoteChar) break;
            sb.append(c);
        }
        return sb.toString();
    }

    private static int parseNumericValue(CharSequence string, StringBuilder sb, int i, int value, int possibleDigits, int radixExp) {
        char digit;
        int val;
        for (int j = 0; j < possibleDigits && i + 1 != string.length() && (val = Character.digit(digit = string.charAt(i + 1), 1 << radixExp)) != -1; ++j) {
            ++i;
            value = (value << radixExp) + val;
        }
        sb.append((char)value);
        return i;
    }

    public static interface Constants {
        public static final String EMPTY_STRING = "";
        public static final String SPACE = " ";
    }
}

