/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.json.flattener;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.github.wnameless.json.base.JacksonJsonCore;
import com.github.wnameless.json.base.JacksonJsonValue;
import com.github.wnameless.json.base.JsonCore;
import com.github.wnameless.json.base.JsonValueBase;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import com.kubling.teiid.core.json.flattener.CharSequenceTranslatorFactory;
import com.kubling.teiid.core.json.flattener.FlattenMode;
import com.kubling.teiid.core.json.flattener.JsonFlattener;
import com.kubling.teiid.core.json.flattener.KeyTransformer;
import com.kubling.teiid.core.json.flattener.PrintMode;
import com.kubling.teiid.core.json.flattener.StringEscapePolicy;
import com.kubling.teiid.core.json.unflattener.JsonUnflattener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JsonFlattenerTest {
    ObjectMapper mapper = new ObjectMapper();

    @Test
    public void testConstructorException() {
        Assertions.assertThrows(RuntimeException.class, () -> new JsonFlattener("abc[123]}"));
    }

    @Test
    public void testFlatten() throws IOException {
        URL url = Resources.getResource((String)"test2.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        Assertions.assertEquals((Object)"{\"a.b\":1,\"a.c\":null,\"a.d[0]\":false,\"a.d[1]\":true,\"e\":\"f\",\"g\":2.3}", (Object)JsonFlattener.flatten((String)json));
        Assertions.assertEquals((Object)"{\"[0].a\":1,\"[1]\":2,\"[2].c[0]\":3,\"[2].c[1]\":4}", (Object)JsonFlattener.flatten((String)"[{\"a\":1},2,{\"c\":[3,4]}]"));
    }

    @Test
    public void testFlattenWithExactFloat() {
        Assertions.assertEquals((Object)"{\"[0].a\":1,\"[1]\":2.0,\"[2].c[0]\":3,\"[2].c[1]\":4}", (Object)JsonFlattener.flatten((String)"[{\"a\":1},2.00,{\"c\":[3,4]}]"));
        JsonNodeFactory f = new JsonNodeFactory(true);
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        mapper.setNodeFactory(f);
        JsonFlattener jsonFlattener = new JsonFlattener((JsonCore)new JacksonJsonCore(mapper), "[{\"a\":1},2.00,{\"c\":[3,4]}]");
        Assertions.assertEquals((Object)"{\"[0].a\":1,\"[1]\":2.00,\"[2].c[0]\":3,\"[2].c[1]\":4}", (Object)jsonFlattener.flatten());
    }

    @Test
    public void testFlattenAsMap() throws IOException {
        URL url = Resources.getResource((String)"test2.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        Assertions.assertEquals((Object)"{\"a.b\":1,\"a.c\":null,\"a.d[0]\":false,\"a.d[1]\":true,\"e\":\"f\",\"g\":2.3}", (Object)JsonFlattener.flattenAsMap((String)json).toString());
    }

    @Test
    public void testFlattenAsMapWithExactFloat() throws IOException {
        URL url = Resources.getResource((String)"test2.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        JsonNodeFactory f = new JsonNodeFactory(true);
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        mapper.setNodeFactory(f);
        JsonFlattener jsonFlattener = new JsonFlattener((JsonCore)new JacksonJsonCore(mapper), json);
        Assertions.assertEquals((Object)"{\"a.b\":1,\"a.c\":null,\"a.d[0]\":false,\"a.d[1]\":true,\"e\":\"f\",\"g\":2.30}", (Object)jsonFlattener.flattenAsMap().toString());
    }

    @Test
    public void testFlattenWithJsonValueBase() throws IOException {
        URL url = Resources.getResource((String)"test2.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        JsonNode jsonVal = new ObjectMapper().readTree(json);
        Assertions.assertEquals((Object)"{\"a.b\":1,\"a.c\":null,\"a.d[0]\":false,\"a.d[1]\":true,\"e\":\"f\",\"g\":2.3}", (Object)JsonFlattener.flatten((JsonValueBase)new JacksonJsonValue(jsonVal)));
        Assertions.assertEquals((Object)"{\"[0].a\":1,\"[1]\":2,\"[2].c[0]\":3,\"[2].c[1]\":4}", (Object)JsonFlattener.flatten((String)"[{\"a\":1},2,{\"c\":[3,4]}]"));
    }

    @Test
    public void testFlattenAsMapWithJsonValueBase() throws IOException {
        URL url = Resources.getResource((String)"test2.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        JsonNode jsonVal = new ObjectMapper().readTree(json);
        Assertions.assertEquals((Object)"{\"a.b\":1,\"a.c\":null,\"a.d[0]\":false,\"a.d[1]\":true,\"e\":\"f\",\"g\":2.3}", (Object)JsonFlattener.flattenAsMap((JsonValueBase)new JacksonJsonValue(jsonVal)).toString());
        Assertions.assertEquals((Object)"{\"[0].a\":1,\"[1]\":2,\"[2].c[0]\":3,\"[2].c[1]\":4}", (Object)JsonFlattener.flattenAsMap((String)"[{\"a\":1},2,{\"c\":[3,4]}]").toString());
    }

    @Test
    public void testFlattenWithKeyContainsDotAndSquareBracket() {
        Assertions.assertEquals((Object)"{\"[0][\\\"a.a.[\\\"]\":1,\"[1]\":2,\"[2].c[0]\":3,\"[2].c[1]\":4}", (Object)JsonFlattener.flatten((String)"[{\"a.a.[\":1},2,{\"c\":[3,4]}]"));
    }

    @Test
    public void testHashCode() throws IOException {
        URL url1 = Resources.getResource((String)"test.json");
        String json1 = Resources.toString((URL)url1, (Charset)Charsets.UTF_8);
        URL url2 = Resources.getResource((String)"test2.json");
        String json2 = Resources.toString((URL)url2, (Charset)Charsets.UTF_8);
        JsonFlattener flattener = new JsonFlattener(json1);
        Assertions.assertEquals((int)flattener.hashCode(), (int)flattener.hashCode());
        Assertions.assertEquals((int)flattener.hashCode(), (int)new JsonFlattener(json1).hashCode());
        Assertions.assertNotEquals((int)flattener.hashCode(), (int)new JsonFlattener(json2).hashCode());
    }

    @Test
    public void testEquals() throws IOException {
        URL url1 = Resources.getResource((String)"test.json");
        String json1 = Resources.toString((URL)url1, (Charset)Charsets.UTF_8);
        URL url2 = Resources.getResource((String)"test2.json");
        String json2 = Resources.toString((URL)url2, (Charset)Charsets.UTF_8);
        JsonFlattener flattener = new JsonFlattener(json1);
        Assertions.assertEquals((Object)flattener, (Object)flattener);
        Assertions.assertEquals((Object)flattener, (Object)new JsonFlattener(json1));
        Assertions.assertNotEquals((Object)flattener, (Object)new JsonFlattener(json2));
        Assertions.assertNotEquals((Object)123L, (Object)flattener);
    }

    @Test
    public void testToString() throws IOException {
        URL url = Resources.getResource((String)"test2.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        Assertions.assertEquals((Object)"JsonFlattener{source={\"a\":{\"b\":1,\"c\":null,\"d\":[false,true]},\"e\":\"f\",\"g\":2.3}}", (Object)new JsonFlattener(json).toString());
    }

    @Test
    public void testWithNoPrecisionDouble() {
        String json = "{\"39473331\":{\"mega\":6.0,\"goals\":1.0}}";
        Assertions.assertEquals((Object)"{\"39473331.mega\":6.0,\"39473331.goals\":1.0}", (Object)new JsonFlattener(json).flatten());
    }

    @Test
    public void testWithEmptyJsonObject() {
        String json = "{}";
        Assertions.assertEquals((Object)"{}", (Object)new JsonFlattener(json).flatten());
        Assertions.assertEquals((Object)json, (Object)JsonUnflattener.unflatten((String)new JsonFlattener(json).flatten()));
        Assertions.assertEquals((Object)Maps.newHashMap(), (Object)new JsonFlattener(json).flattenAsMap());
    }

    @Test
    public void testWithEmptyJsonArray() {
        String json = "[]";
        Assertions.assertEquals((Object)"[]", (Object)new JsonFlattener(json).flatten());
        Assertions.assertEquals((Object)ImmutableMap.of((Object)"root", (Object)Lists.newArrayList()), (Object)new JsonFlattener(json).flattenAsMap());
        Assertions.assertEquals((Object)json, (Object)JsonUnflattener.unflatten((String)new JsonFlattener(json).flatten()));
        Assertions.assertEquals((Object)"[]", (Object)new JsonFlattener(json).withFlattenMode(FlattenMode.KEEP_ARRAYS).flatten());
        Assertions.assertEquals((Object)ImmutableMap.of((Object)"root", (Object)Lists.newArrayList()), (Object)new JsonFlattener(json).withFlattenMode(FlattenMode.KEEP_ARRAYS).flattenAsMap());
        Assertions.assertEquals((Object)json, (Object)JsonUnflattener.unflatten((String)new JsonFlattener(json).withFlattenMode(FlattenMode.KEEP_ARRAYS).flatten()));
    }

    @Test
    public void testWithEmptyArray() {
        String json = "{\"no\":\"1\",\"name\":\"riya\",\"marks\":[]}";
        Assertions.assertEquals((Object)"{\"no\":\"1\",\"name\":\"riya\",\"marks\":[]}", (Object)new JsonFlattener(json).flatten());
        Assertions.assertEquals((Object)json, (Object)JsonUnflattener.unflatten((String)new JsonFlattener(json).flatten()));
    }

    @Test
    public void testWithEmptyObject() {
        String json = "{\"no\":\"1\",\"name\":\"riya\",\"marks\":[{}]}";
        Assertions.assertEquals((Object)"{\"no\":\"1\",\"name\":\"riya\",\"marks[0]\":{}}", (Object)new JsonFlattener(json).flatten());
        Assertions.assertEquals((Object)json, (Object)JsonUnflattener.unflatten((String)new JsonFlattener(json).flatten()));
    }

    @Test
    public void testWithArray() {
        String json = "[{\"abc\":123},456,[null]]";
        Assertions.assertEquals((Object)"{\"[0].abc\":123,\"[1]\":456,\"[2][0]\":null}", (Object)new JsonFlattener(json).flatten());
        Assertions.assertEquals((Object)json, (Object)JsonUnflattener.unflatten((String)new JsonFlattener(json).flatten()));
    }

    @Test
    public void testWithSpecialCharacters() {
        String json = "[{\"abc\\t\":\" \\\" \\r \\t S4 \"}]";
        Assertions.assertEquals((Object)"{\"[0].abc\\t\":\" \\\" \\r \\t S4 \"}", (Object)new JsonFlattener(json).flatten());
        json = "{\" \":[123,\"abc\"]}";
        Assertions.assertEquals((Object)"{\" [0]\":123,\" [1]\":\"abc\"}", (Object)new JsonFlattener(json).flatten());
    }

    @Test
    public void testWithUnicodeCharacters() {
        String json = "[{\"\u59d3\u540d\":123}]";
        Assertions.assertEquals((Object)"{\"[0].\u59d3\u540d\":123}", (Object)new JsonFlattener(json).flatten());
    }

    @Test
    public void testWithFlattenMode() throws IOException {
        URL url = Resources.getResource((String)"test4.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        Assertions.assertEquals((Object)"{\"a.b\":1,\"a.c\":null,\"a.d\":[false,{\"i.j\":[false,true,\"xy\"]}],\"e\":\"f\",\"g\":2.3,\"z\":[]}", (Object)new JsonFlattener(json).withFlattenMode(FlattenMode.KEEP_ARRAYS).flatten());
    }

    @Test
    public void testWithStringEscapePolicyALL_UNICODES() {
        String json = "{\"abc\":{\"def\":\"\u592a\u6975\"}}";
        Assertions.assertEquals((Object)"{\"abc.def\":\"\\u592A\\u6975\"}", (Object)new JsonFlattener(json).withStringEscapePolicy((CharSequenceTranslatorFactory)StringEscapePolicy.ALL_UNICODES).flatten());
    }

    @Test
    public void testWithStringEscapePolicyALL() {
        String json = "{\"abc\":{\"def\":\"\u592a\u6975/\u5169\u5100\"}}";
        Assertions.assertEquals((Object)"{\"abc.def\":\"\\u592A\\u6975\\/\\u5169\\u5100\"}", (Object)new JsonFlattener(json).withStringEscapePolicy((CharSequenceTranslatorFactory)StringEscapePolicy.ALL).flatten());
    }

    @Test
    public void testWithStringEscapePolicyALL_BUT_SLASH() {
        String json = "{\"abc\":{\"def\":\"\u592a\u6975/\u5169\u5100\"}}";
        Assertions.assertEquals((Object)"{\"abc.def\":\"\\u592A\\u6975/\\u5169\\u5100\"}", (Object)new JsonFlattener(json).withStringEscapePolicy((CharSequenceTranslatorFactory)StringEscapePolicy.ALL_BUT_SLASH).flatten());
    }

    @Test
    public void testWithStringEscapePolicyALL_BUT_UNICODE() {
        String json = "{\"abc\":{\"def\":\"\u592a\u6975/\u5169\u5100\"}}";
        Assertions.assertEquals((Object)"{\"abc.def\":\"\u592a\u6975\\/\u5169\u5100\"}", (Object)new JsonFlattener(json).withStringEscapePolicy((CharSequenceTranslatorFactory)StringEscapePolicy.ALL_BUT_UNICODE).flatten());
    }

    @Test
    public void testWithStringEscapePolicyALL_BUT_SLASH_AND_UNICODE() {
        String json = "{\"abc\":{\"def\":\"\u592a\u6975/\u5169\u5100\"}}";
        Assertions.assertEquals((Object)"{\"abc.def\":\"\u592a\u6975/\u5169\u5100\"}", (Object)new JsonFlattener(json).withStringEscapePolicy((CharSequenceTranslatorFactory)StringEscapePolicy.ALL_BUT_SLASH_AND_UNICODE).flatten());
    }

    @Test
    public void testWithSeparator() {
        String json = "{\"abc\":{\"def\":123}}";
        Assertions.assertEquals((Object)"{\"abc*def\":123}", (Object)new JsonFlattener(json).withSeparator((CharSequence)"*").flatten());
    }

    @Test
    public void testWithSeparatorException() {
        String json = "{\"abc\":{\"def\":123}}";
        try {
            new JsonFlattener(json).withSeparator((CharSequence)"\"");
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Separator contains illegal character(\")", (Object)e.getMessage());
        }
        try {
            new JsonFlattener(json).withSeparator((CharSequence)" ");
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Separator contains illegal character( )", (Object)e.getMessage());
        }
        try {
            new JsonFlattener(json).withSeparator((CharSequence)"[");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Separator([) is already used in brackets", (Object)e.getMessage());
        }
        try {
            new JsonFlattener(json).withSeparator((CharSequence)"]");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Separator(]) is already used in brackets", (Object)e.getMessage());
        }
    }

    @Test
    public void testWithLeftAndRightBracket() {
        String json = "{\"abc\":{\"A.\":[123,\"def\"]}}";
        Assertions.assertEquals((Object)"{\"abc{\\\"A.\\\"}{0}\":123,\"abc{\\\"A.\\\"}{1}\":\"def\"}", (Object)new JsonFlattener(json).withLeftAndRightBrackets('{', '}').flatten());
    }

    @Test
    public void testWithLeftAndRightBracketsException() {
        String json = "{\"abc\":{\"def\":123}}";
        try {
            new JsonFlattener(json).withLeftAndRightBrackets('#', '#');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Both brackets cannot be the same", (Object)e.getMessage());
        }
        try {
            new JsonFlattener(json).withLeftAndRightBrackets('\"', ']');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Left bracket contains illegal character(\")", (Object)e.getMessage());
        }
        try {
            new JsonFlattener(json).withLeftAndRightBrackets(' ', ']');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Left bracket contains illegal character( )", (Object)e.getMessage());
        }
        try {
            new JsonFlattener(json).withLeftAndRightBrackets('.', ']');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Left bracket contains illegal character(.)", (Object)e.getMessage());
        }
        try {
            new JsonFlattener(json).withLeftAndRightBrackets('[', '\"');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Right bracket contains illegal character(\")", (Object)e.getMessage());
        }
        try {
            new JsonFlattener(json).withLeftAndRightBrackets('[', ' ');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Right bracket contains illegal character( )", (Object)e.getMessage());
        }
        try {
            new JsonFlattener(json).withLeftAndRightBrackets('[', '.');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Right bracket contains illegal character(.)", (Object)e.getMessage());
        }
    }

    @Test
    public void testRootInMap() {
        Assertions.assertEquals((Object)"null", (Object)JsonFlattener.flatten((String)"null"));
        Assertions.assertNull(JsonFlattener.flattenAsMap((String)"null").get("root"));
        Assertions.assertEquals((Object)"123", (Object)JsonFlattener.flatten((String)"123"));
        Assertions.assertEquals((Object)123, JsonFlattener.flattenAsMap((String)"123").get("root"));
        Assertions.assertEquals((Object)"\"abc\"", (Object)JsonFlattener.flatten((String)"\"abc\""));
        Assertions.assertEquals((Object)"abc", JsonFlattener.flattenAsMap((String)"\"abc\"").get("root"));
        Assertions.assertEquals((Object)"true", (Object)JsonFlattener.flatten((String)"true"));
        Assertions.assertEquals((Object)true, JsonFlattener.flattenAsMap((String)"true").get("root"));
        Assertions.assertEquals((Object)"[]", (Object)JsonFlattener.flatten((String)"[]"));
        Assertions.assertEquals(Collections.emptyList(), JsonFlattener.flattenAsMap((String)"[]").get("root"));
        Assertions.assertEquals((Object)"[[{\"abc.def\":123}]]", (Object)new JsonFlattener("[[{\"abc\":{\"def\":123}}]]").withFlattenMode(FlattenMode.KEEP_ARRAYS).flatten());
        List root = (List)new JsonFlattener("[[{\"abc\":{\"def\":123}}]]").withFlattenMode(FlattenMode.KEEP_ARRAYS).flattenAsMap().get("root");
        Assertions.assertEquals((Object)ImmutableMap.of((Object)"abc.def", (Object)123), ((List)root.get(0)).get(0));
    }

    @Test
    public void testPrintMode() throws IOException {
        URL url = Resources.getResource((String)"test.json");
        String src = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        String json = new JsonFlattener(src).withPrintMode(PrintMode.MINIMAL).flatten();
        Assertions.assertEquals((Object)this.mapper.readTree(json).toString(), (Object)json);
        json = new JsonFlattener(src).withPrintMode(PrintMode.PRETTY).flatten();
        Assertions.assertEquals((Object)this.mapper.readTree(json).toPrettyString(), (Object)json);
        src = "[[123]]";
        json = new JsonFlattener(src).withFlattenMode(FlattenMode.KEEP_ARRAYS).withPrintMode(PrintMode.MINIMAL).flatten();
        Assertions.assertEquals((Object)this.mapper.readTree(json).toString(), (Object)json);
        json = new JsonFlattener(src).withFlattenMode(FlattenMode.KEEP_ARRAYS).withPrintMode(PrintMode.PRETTY).flatten();
        Assertions.assertEquals((Object)this.mapper.readTree(json).toPrettyString(), (Object)json);
    }

    @Test
    public void testPrintModeWithEscapedDoubleQoutesAndBackslash() throws IOException {
        URL url = Resources.getResource((String)"test_print_mode_unflatten_minimal.json");
        String input = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        JsonFlattener jf = new JsonFlattener(input);
        jf.withPrintMode(PrintMode.MINIMAL);
        String flattendJsonWithDotKey = jf.flatten();
        url = Resources.getResource((String)"test_print_mode_flatten_minimal.json");
        String output = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        Assertions.assertEquals((Object)output, (Object)flattendJsonWithDotKey);
        jf.withPrintMode(PrintMode.PRETTY);
        flattendJsonWithDotKey = jf.flatten();
        url = Resources.getResource((String)"test_print_mode_flatten_pretty.json");
        output = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        Assertions.assertEquals((Object)output, (Object)flattendJsonWithDotKey);
        JsonUnflattener ju = new JsonUnflattener(flattendJsonWithDotKey);
        ju.withPrintMode(PrintMode.MINIMAL);
        String nestedJsonWithDotKey = ju.unflatten();
        Assertions.assertEquals((Object)input, (Object)nestedJsonWithDotKey);
        ju.withPrintMode(PrintMode.PRETTY);
        nestedJsonWithDotKey = ju.unflatten();
        url = Resources.getResource((String)"test_print_mode_unflatten_pretty.json");
        output = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        Assertions.assertEquals((Object)output, (Object)nestedJsonWithDotKey);
    }

    @Test
    public void testNoCache() {
        JsonFlattener jf = new JsonFlattener("{\"abc\":{\"def\":123}}");
        Assertions.assertSame((Object)jf.flattenAsMap(), (Object)jf.flattenAsMap());
        Assertions.assertNotSame((Object)jf.flatten(), (Object)jf.flatten());
        Assertions.assertEquals((Object)"{\"abc*def\":123}", (Object)jf.withSeparator((CharSequence)"*").flatten());
        Assertions.assertEquals((Object)jf.flatten(), (Object)jf.withPrintMode(PrintMode.MINIMAL).flatten());
    }

    @Test
    public void testNullPointerException() {
        try {
            new JsonFlattener("{\"abc\":{\"def\":123}}").withFlattenMode(null);
            Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new JsonFlattener("{\"abc\":{\"def\":123}}").withStringEscapePolicy(null);
            Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new JsonFlattener("{\"abc\":{\"def\":123}}").withPrintMode(null);
            Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testFlattenWithNestedEmptyJsonObjectAndKeepArraysMode() throws IOException {
        URL url = Resources.getResource((String)"test5.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        Assertions.assertEquals((Object)"{\"a.b\":1,\"a.c\":null,\"a.d\":[false,{\"i.j\":[false,true]}],\"e\":\"f\",\"g\":2.3,\"z\":{}}", (Object)new JsonFlattener(json).withFlattenMode(FlattenMode.KEEP_ARRAYS).flatten());
    }

    @Test
    public void testWithSeparatorAndNestedObject() throws IOException {
        URL url = Resources.getResource((String)"test5.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        Assertions.assertEquals((Object)"{\"a_b\":1,\"a_c\":null,\"a_d\":[false,{\"i_j\":[false,true]}],\"e\":\"f\",\"g\":2.3,\"z\":{}}", (Object)new JsonFlattener(json).withFlattenMode(FlattenMode.KEEP_ARRAYS).withSeparator((CharSequence)"_").flatten());
    }

    @Test
    public void testWithRootKeyInSourceObject() {
        String json = "{\"root\":null, \"ss\":[123]}";
        Assertions.assertEquals((Object)"{\"root\":null,\"ss[0]\":123}", (Object)JsonFlattener.flatten((String)json));
    }

    @Test
    public void testInitByReader() throws IOException {
        URL url = Resources.getResource((String)"test.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        JsonFlattener jf = new JsonFlattener((Reader)new InputStreamReader(url.openStream()));
        Assertions.assertEquals((Object)jf, (Object)new JsonFlattener(json));
    }

    @Test
    public void testFlattenModeMongodb() throws IOException {
        URL url = Resources.getResource((String)"test_mongo.json");
        String src = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        URL urlMongo = Resources.getResource((String)"test_mongo_flattened.json");
        String expectedJson = Resources.toString((URL)urlMongo, (Charset)Charsets.UTF_8);
        String flattened = new JsonFlattener(src).withFlattenMode(FlattenMode.MONGODB).withPrintMode(PrintMode.PRETTY).flatten();
        Assertions.assertEquals((Object)expectedJson, (Object)flattened);
    }

    @Test
    public void testFlattenModeMongodbException() {
        String json = "{\"abc\":{\"de.f\":123}}";
        JsonFlattener jf = new JsonFlattener(json).withFlattenMode(FlattenMode.MONGODB);
        try {
            jf.flatten();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Key cannot contain separator(.) in FlattenMode.MONGODB", (Object)e.getMessage());
        }
    }

    @Test
    public void testWithKeyTransformer() {
        String json = "{\"abc\":{\"de.f\":123}}";
        JsonFlattener jf = new JsonFlattener(json).withFlattenMode(FlattenMode.MONGODB).withKeyTransformer(new KeyTransformer(this){

            public String transform(String key) {
                return key.replace('.', '_');
            }
        });
        Assertions.assertEquals((Object)"{\"abc.de_f\":123}", (Object)jf.flatten());
    }

    @Test
    public void testWithFlattenModeKeepBottomArrays() throws IOException {
        URL url = Resources.getResource((String)"test_keep_primitive_arrays.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        URL urlKBA = Resources.getResource((String)"test_keep_primitive_arrays_flattened.json");
        String expectedJson = Resources.toString((URL)urlKBA, (Charset)Charsets.UTF_8);
        JsonFlattener jf = new JsonFlattener(json).withFlattenMode(FlattenMode.KEEP_PRIMITIVE_ARRAYS).withPrintMode(PrintMode.PRETTY);
        String flattened = jf.flatten();
        Assertions.assertEquals((Object)expectedJson, (Object)flattened);
    }

    @Test
    public void testWithJsonCore() throws IOException {
        URL url = Resources.getResource((String)"test_long_decimal.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        ObjectMapper mapper = new ObjectMapper(){
            private static final long serialVersionUID = 1L;
            {
                this.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
                this.configure(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS, true);
            }
        };
        JsonFlattener jf = new JsonFlattener((JsonCore)new JacksonJsonCore(mapper), json);
        jf.withPrintMode(PrintMode.PRETTY);
        Assertions.assertEquals((Object)mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)mapper.readTree(json)), (Object)jf.flatten());
        jf = new JsonFlattener((JsonCore)new JacksonJsonCore(mapper), (Reader)new StringReader(json));
        jf.withPrintMode(PrintMode.PRETTY);
        Assertions.assertEquals((Object)mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)mapper.readTree(json)), (Object)jf.flatten());
        jf = new JsonFlattener((JsonCore)new JacksonJsonCore(mapper), (JsonValueBase)new JacksonJsonCore(mapper).parse(json));
        jf.withPrintMode(PrintMode.PRETTY);
        Assertions.assertEquals((Object)mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)mapper.readTree(json)), (Object)jf.flatten());
    }

    @Test
    public void testWithIgnoreReservedCharacters() {
        String json = "{\"matrix\":{\"agent.smith\":\"1999\"}}";
        Assertions.assertEquals((Object)"{\"matrix[\\\"agent.smith\\\"]\":\"1999\"}", (Object)JsonFlattener.flatten((String)json));
        Assertions.assertEquals((Object)"{\"matrix.agent.smith\":\"1999\"}", (Object)new JsonFlattener(json).ignoreReservedCharacters().flatten());
        Assertions.assertThrows(IllegalArgumentException.class, () -> new JsonFlattener(json).withFlattenMode(FlattenMode.MONGODB).flatten());
        Assertions.assertEquals((Object)"{\"matrix.agent.smith\":\"1999\"}", (Object)new JsonFlattener(json).withFlattenMode(FlattenMode.MONGODB).ignoreReservedCharacters().flatten());
        String jsonArray = "[{\"matrix\":\"reloaded\",\"agent\":{\"smith_no\":\"1\"}},{\"matrix\":\"reloaded\",\"agent\":{\"smith_no\":\"2\"}}]";
        Assertions.assertEquals((Object)"{\"_0_matrix\":\"reloaded\",\"_0_agent_smith_no\":\"1\",\"_1_matrix\":\"reloaded\",\"_1_agent_smith_no\":\"2\"}", (Object)new JsonFlattener(jsonArray).withFlattenMode(FlattenMode.MONGODB).withSeparator((CharSequence)"_").ignoreReservedCharacters().flatten());
        Assertions.assertEquals((Object)"[{\"matrix\":\"reloaded\",\"agent_smith_no\":\"1\"},{\"matrix\":\"reloaded\",\"agent_smith_no\":\"2\"}]", (Object)new JsonFlattener(jsonArray).withFlattenMode(FlattenMode.KEEP_ARRAYS).withSeparator((CharSequence)"_").ignoreReservedCharacters().flatten());
    }
}

