/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.json.unflattener;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.wnameless.json.base.JacksonJsonCore;
import com.github.wnameless.json.base.JsonCore;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.kubling.teiid.core.json.flattener.FlattenMode;
import com.kubling.teiid.core.json.flattener.JsonFlattener;
import com.kubling.teiid.core.json.flattener.PrintMode;
import com.kubling.teiid.core.json.unflattener.JsonUnflattener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JsonUnflattenerTest {
    ObjectMapper mapper = new ObjectMapper();

    private Map<String, ?> toMap(String json) throws JsonProcessingException {
        return (Map)this.mapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(this){});
    }

    private Map<String, ?> toRootMap(String json) throws JsonProcessingException {
        return (Map)this.mapper.readValue("{\"root\":" + json + "}", (TypeReference)new TypeReference<Map<String, Object>>(this){});
    }

    @Test
    public void testConstructorException() {
        Assertions.assertThrows(RuntimeException.class, () -> new JsonUnflattener("abc[123]}"));
    }

    @Test
    public void testUnflatten() throws JsonProcessingException {
        Assertions.assertEquals((Object)"{\"a\":{\"b\":1,\"c\":null,\"d\":[false,true,{\"sss\":777,\"vvv\":888}]},\"e\":\"f\",\"g\":2.3}", (Object)JsonUnflattener.unflatten((String)"{\"a.b\":1,\"a.c\":null,\"a.d[1]\":true,\"a.d[0]\":false,\"a.d[2].sss\":777,\"a.d[2].vvv\":888,\"e\":\"f\",\"g\":2.3}"));
        Assertions.assertEquals((Object)"[1,[2,3],4,{\"abc\":5}]", (Object)JsonUnflattener.unflatten((String)"{\"[1][0]\":2,\"[0]\":1,\"[1][1]\":3,\"[2]\":4,\"[3].abc\":5}"));
        Assertions.assertEquals((Object)"{\" \\\"abc\":{\"def \":123}}", (Object)JsonUnflattener.unflatten((String)JsonFlattener.flatten((String)"{\" \\\"abc\":{\"def \":123}}")));
        Assertions.assertEquals((Object)"{\" ].$f\":{\"abc\":{\"def\":[123]}}}", (Object)JsonUnflattener.unflatten((String)"{\"[\\\" ].$f\\\"].abc.def[0]\":123}"));
        Assertions.assertEquals((Object)"[{\"abc\\t\":\" \\\" \\r \\t S4 \"}]", (Object)JsonUnflattener.unflatten((String)JsonFlattener.flatten((String)"[{\"abc\\t\":\" \\\" \\r \\t S4 \"}]")));
        Assertions.assertEquals((Object)"{\"a\":{\"b\":1,\"c\":null,\"d\":[false,true,{\"sss\":777,\"vvv\":888}]},\"e\":\"f\",\"g\":2.3}", (Object)JsonUnflattener.unflatten(this.toMap("{\"a.b\":1,\"a.c\":null,\"a.d[1]\":true,\"a.d[0]\":false,\"a.d[2].sss\":777,\"a.d[2].vvv\":888,\"e\":\"f\",\"g\":2.3}")));
        Assertions.assertEquals((Object)"[1,[2,3],4,{\"abc\":5}]", (Object)JsonUnflattener.unflatten(this.toMap("{\"[1][0]\":2,\"[0]\":1,\"[1][1]\":3,\"[2]\":4,\"[3].abc\":5}")));
        Assertions.assertEquals((Object)"{\" \\\"abc\":{\"def \":123}}", (Object)JsonUnflattener.unflatten(this.toMap(JsonFlattener.flatten((String)"{\" \\\"abc\":{\"def \":123}}"))));
        Assertions.assertEquals((Object)"{\" ].$f\":{\"abc\":{\"def\":[123]}}}", (Object)JsonUnflattener.unflatten(this.toMap("{\"[\\\" ].$f\\\"].abc.def[0]\":123}")));
        Assertions.assertEquals((Object)"[{\"abc\\t\":\" \\\" \\r \\t S4 \"}]", (Object)JsonUnflattener.unflatten(this.toMap(JsonFlattener.flatten((String)"[{\"abc\\t\":\" \\\" \\r \\t S4 \"}]"))));
    }

    @Test
    public void testUnflattenAsMap() throws JsonProcessingException {
        Assertions.assertEquals(this.toMap("{\"a\":{\"b\":1,\"c\":null,\"d\":[false,true,{\"sss\":777,\"vvv\":888}]},\"e\":\"f\",\"g\":2.3}"), (Object)JsonUnflattener.unflattenAsMap((String)"{\"a.b\":1,\"a.c\":null,\"a.d[1]\":true,\"a.d[0]\":false,\"a.d[2].sss\":777,\"a.d[2].vvv\":888,\"e\":\"f\",\"g\":2.3}"));
        Assertions.assertEquals(this.toRootMap("[1,[2,3],4,{\"abc\":5}]"), (Object)JsonUnflattener.unflattenAsMap((String)"{\"[1][0]\":2,\"[0]\":1,\"[1][1]\":3,\"[2]\":4,\"[3].abc\":5}"));
        Assertions.assertEquals(this.toMap("{\" \\\"abc\":{\"def \":123}}"), (Object)JsonUnflattener.unflattenAsMap((String)JsonFlattener.flatten((String)"{\" \\\"abc\":{\"def \":123}}")));
        Assertions.assertEquals(this.toMap("{\" ].$f\":{\"abc\":{\"def\":[123]}}}"), (Object)JsonUnflattener.unflattenAsMap((String)"{\"[\\\" ].$f\\\"].abc.def[0]\":123}"));
        Assertions.assertEquals(this.toRootMap("[{\"abc\\t\":\" \\\" \\r \\t S4 \"}]"), (Object)JsonUnflattener.unflattenAsMap((String)JsonFlattener.flatten((String)"[{\"abc\\t\":\" \\\" \\r \\t S4 \"}]")));
        Assertions.assertEquals(this.toMap("{\"a\":{\"b\":1,\"c\":null,\"d\":[false,true,{\"sss\":777,\"vvv\":888}]},\"e\":\"f\",\"g\":2.3}"), (Object)JsonUnflattener.unflattenAsMap(this.toMap("{\"a.b\":1,\"a.c\":null,\"a.d[1]\":true,\"a.d[0]\":false,\"a.d[2].sss\":777,\"a.d[2].vvv\":888,\"e\":\"f\",\"g\":2.3}")));
        Assertions.assertEquals(this.toRootMap("[1,[2,3],4,{\"abc\":5}]"), (Object)JsonUnflattener.unflattenAsMap(this.toMap("{\"[1][0]\":2,\"[0]\":1,\"[1][1]\":3,\"[2]\":4,\"[3].abc\":5}")));
        Assertions.assertEquals(this.toMap("{\" \\\"abc\":{\"def \":123}}"), (Object)JsonUnflattener.unflattenAsMap(this.toMap(JsonFlattener.flatten((String)"{\" \\\"abc\":{\"def \":123}}"))));
        Assertions.assertEquals(this.toMap("{\" ].$f\":{\"abc\":{\"def\":[123]}}}"), (Object)JsonUnflattener.unflattenAsMap(this.toMap("{\"[\\\" ].$f\\\"].abc.def[0]\":123}")));
        Assertions.assertEquals(this.toRootMap("[{\"abc\\t\":\" \\\" \\r \\t S4 \"}]"), (Object)JsonUnflattener.unflattenAsMap(this.toMap(JsonFlattener.flatten((String)"[{\"abc\\t\":\" \\\" \\r \\t S4 \"}]"))));
        Assertions.assertEquals(this.toRootMap("123"), (Object)JsonUnflattener.unflattenAsMap((String)"123"));
    }

    @Test
    public void testUnflattenWithArrayOfNestedObjectsInValByKeepArraysMode() throws IOException {
        URL url = Resources.getResource((String)"test6.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        String flattendJson = new JsonFlattener(json).withFlattenMode(FlattenMode.KEEP_ARRAYS).flatten();
        Assertions.assertEquals((Object)"{\"a\":[1,2,3],\"b\":[{\"c.d\":[1,2]}]}", (Object)flattendJson);
        Assertions.assertEquals((Object)"{\"a\":[1,2,3],\"b\":[{\"c\":{\"d\":[1,2]}}]}", (Object)JsonUnflattener.unflatten((String)flattendJson));
        Map flattendMap = new JsonFlattener(json).withFlattenMode(FlattenMode.KEEP_ARRAYS).flattenAsMap();
        Assertions.assertEquals((Object)"{\"a\":[1,2,3],\"b\":[{\"c.d\":[1,2]}]}", (Object)flattendMap.toString());
        Assertions.assertEquals((Object)"{\"a\":[1,2,3],\"b\":[{\"c\":{\"d\":[1,2]}}]}", (Object)JsonUnflattener.unflatten((Map)flattendMap));
    }

    @Test
    public void testUnflattenWithKeyContainsDotAndSquareBracket() throws JsonProcessingException {
        Assertions.assertEquals((Object)"[1,[2,3],4,{\"ab.c.[\":5}]", (Object)JsonUnflattener.unflatten((String)"{\"[1][0]\":2,\"[ 0 ]\":1,\"[1][1]\":3,\"[2]\":4,\"[3][ \\\"ab.c.[\\\" ]\":5}"));
        Assertions.assertEquals((Object)"[1,[2,3],4,{\"ab.c.[\":5}]", (Object)JsonUnflattener.unflatten(this.toMap("{\"[1][0]\":2,\"[ 0 ]\":1,\"[1][1]\":3,\"[2]\":4,\"[3][ \\\"ab.c.[\\\" ]\":5}")));
    }

    @Test
    public void testUnflattenWithReversedIndexesWithinObjects() throws IOException {
        URL url = Resources.getResource((String)"test3.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        Assertions.assertEquals((Object)"{\"List\":[{\"type\":\"A\"},null,{\"type\":\"B\"}]}", (Object)JsonUnflattener.unflatten((String)json));
        Assertions.assertEquals((Object)"{\"List\":[{\"type\":\"A\"},null,{\"type\":\"B\"}]}", (Object)JsonUnflattener.unflatten(this.toMap(json)));
    }

    @Test
    public void testUnflattenWithReversedIndexes() throws JsonMappingException, JsonProcessingException {
        String json = "{\"[1][1]\":\"B\",\"[0][0]\":\"A\"}";
        Assertions.assertEquals((Object)"[[\"A\"],[null,\"B\"]]", (Object)JsonUnflattener.unflatten((String)json));
        Assertions.assertEquals((Object)"[[\"A\"],[null,\"B\"]]", (Object)JsonUnflattener.unflatten(this.toMap(json)));
    }

    @Test
    public void testUnflattenWithInitComplexKey() throws JsonMappingException, JsonProcessingException {
        String json = "{\"[\\\"b.b\\\"].aaa\":123}";
        Assertions.assertEquals((Object)"{\"b.b\":{\"aaa\":123}}", (Object)JsonUnflattener.unflatten((String)json));
        Assertions.assertEquals((Object)"{\"b.b\":{\"aaa\":123}}", (Object)JsonUnflattener.unflatten(this.toMap(json)));
    }

    @Test
    public void testHashCode() throws IOException {
        String json1 = "[[123]]";
        String json2 = "[[[123]]]";
        JsonUnflattener unflattener = new JsonUnflattener(json1);
        Assertions.assertEquals((int)unflattener.hashCode(), (int)unflattener.hashCode());
        Assertions.assertEquals((int)unflattener.hashCode(), (int)new JsonUnflattener(json1).hashCode());
        Assertions.assertNotEquals((int)unflattener.hashCode(), (int)new JsonUnflattener(json2).hashCode());
    }

    @Test
    public void testEquals() throws IOException {
        String json1 = "[[123]]";
        String json2 = "[[[123]]]";
        JsonUnflattener unflattener = new JsonUnflattener(json1);
        Assertions.assertEquals((Object)unflattener, (Object)unflattener);
        Assertions.assertEquals((Object)unflattener, (Object)new JsonUnflattener(json1));
        Assertions.assertNotEquals((Object)unflattener, (Object)new JsonUnflattener(json2));
        Assertions.assertNotEquals((Object)123L, (Object)unflattener);
    }

    @Test
    public void testToString() {
        String json = "[[123]]";
        Assertions.assertEquals((Object)"JsonUnflattener{root=[[123]]}", (Object)new JsonUnflattener(json).toString());
    }

    @Test
    public void testWithKeepArrays() throws IOException {
        URL url = Resources.getResource((String)"test4.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        Assertions.assertEquals((Object)json, (Object)JsonUnflattener.unflatten((String)new JsonFlattener(json).withFlattenMode(FlattenMode.KEEP_ARRAYS).flatten()));
        Assertions.assertEquals((Object)json, (Object)JsonUnflattener.unflatten(this.toMap(new JsonFlattener(json).withFlattenMode(FlattenMode.KEEP_ARRAYS).flatten())));
    }

    @Test
    public void testWithSeparater() throws JsonProcessingException {
        String json = "{\"abc\":{\"def\":123}}";
        Assertions.assertEquals((Object)json, (Object)new JsonUnflattener(new JsonFlattener(json).withSeparator((CharSequence)"*").flatten()).withSeparator('*').unflatten());
        Assertions.assertEquals((Object)json, (Object)new JsonUnflattener(this.toMap(new JsonFlattener(json).withSeparator((CharSequence)"*").flatten())).withSeparator('*').unflatten());
    }

    @Test
    public void testWithSeparaterException() throws JsonProcessingException {
        String json = "{\"abc\":{\"def\":123}}";
        try {
            new JsonUnflattener(json).withSeparator('\"');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Separator contains illegal character(\")", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(json).withSeparator(' ');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Separator contains illegal character( )", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(json).withSeparator('[');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Separator([) is already used in brackets", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(json).withSeparator(']');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Separator(]) is already used in brackets", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(this.toMap(json)).withSeparator('\"');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Separator contains illegal character(\")", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(this.toMap(json)).withSeparator(' ');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Separator contains illegal character( )", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(this.toMap(json)).withSeparator('[');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Separator([) is already used in brackets", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(this.toMap(json)).withSeparator(']');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Separator(]) is already used in brackets", (Object)e.getMessage());
        }
    }

    @Test
    public void testWithLeftAndRightBrackets() throws JsonProcessingException {
        String json = "{\"abc[\\\"A.\\\"][0]\":123}";
        Assertions.assertEquals((Object)"{\"abc\":{\"A.\":[123]}}", (Object)new JsonUnflattener(json).withLeftAndRightBrackets('[', ']').unflatten());
        json = "{\"abc{\\\"A.\\\"}{0}\":123}";
        Assertions.assertEquals((Object)"{\"abc\":{\"A.\":[123]}}", (Object)new JsonUnflattener(json).withLeftAndRightBrackets('{', '}').unflatten());
        json = "{\"abc[\\\"A.\\\"][0]\":123}";
        Assertions.assertEquals((Object)"{\"abc\":{\"A.\":[123]}}", (Object)new JsonUnflattener(this.toMap(json)).withLeftAndRightBrackets('[', ']').unflatten());
        json = "{\"abc{\\\"A.\\\"}{0}\":123}";
        Assertions.assertEquals((Object)"{\"abc\":{\"A.\":[123]}}", (Object)new JsonUnflattener(this.toMap(json)).withLeftAndRightBrackets('{', '}').unflatten());
    }

    @Test
    public void testWithLeftAndRightBracketsException() throws JsonProcessingException {
        String json = "{\"abc\":{\"def\":123}}";
        try {
            new JsonUnflattener(json).withLeftAndRightBrackets('#', '#');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Both brackets cannot be the same", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(json).withLeftAndRightBrackets('\"', ']');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Left bracket contains illegal character(\")", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(json).withLeftAndRightBrackets(' ', ']');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Left bracket contains illegal character( )", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(json).withLeftAndRightBrackets('.', ']');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Left bracket contains illegal character(.)", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(json).withLeftAndRightBrackets('[', '\"');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Right bracket contains illegal character(\")", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(json).withLeftAndRightBrackets('[', ' ');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Right bracket contains illegal character( )", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(json).withLeftAndRightBrackets('[', '.');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Right bracket contains illegal character(.)", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(this.toMap(json)).withLeftAndRightBrackets('#', '#');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Both brackets cannot be the same", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(this.toMap(json)).withLeftAndRightBrackets('\"', ']');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Left bracket contains illegal character(\")", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(this.toMap(json)).withLeftAndRightBrackets(' ', ']');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Left bracket contains illegal character( )", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(this.toMap(json)).withLeftAndRightBrackets('.', ']');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Left bracket contains illegal character(.)", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(this.toMap(json)).withLeftAndRightBrackets('[', '\"');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Right bracket contains illegal character(\")", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(this.toMap(json)).withLeftAndRightBrackets('[', ' ');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Right bracket contains illegal character( )", (Object)e.getMessage());
        }
        try {
            new JsonUnflattener(this.toMap(json)).withLeftAndRightBrackets('[', '.');
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Right bracket contains illegal character(.)", (Object)e.getMessage());
        }
    }

    @Test
    public void testWithNonObject() {
        Assertions.assertEquals((Object)"123", (Object)JsonUnflattener.unflatten((String)"123"));
        Assertions.assertEquals((Object)"\"abc\"", (Object)JsonUnflattener.unflatten((String)"\"abc\""));
        Assertions.assertEquals((Object)"true", (Object)JsonUnflattener.unflatten((String)"true"));
        Assertions.assertEquals((Object)"[1,2,3]", (Object)JsonUnflattener.unflatten((String)"[1,2,3]"));
    }

    @Test
    public void testWithNestedArrays() {
        Assertions.assertEquals((Object)"[[{\"abc\":{\"def\":123}}]]", (Object)JsonUnflattener.unflatten((String)"[[{\"abc.def\":123}]]"));
    }

    @Test
    public void testPrintMode() throws IOException {
        String src = "{\"abc.def\":123}";
        String json = new JsonUnflattener(src).withPrintMode(PrintMode.MINIMAL).unflatten();
        Assertions.assertEquals((Object)this.mapper.readTree(json).toString(), (Object)json);
        json = new JsonUnflattener(src).withPrintMode(PrintMode.PRETTY).unflatten();
        Assertions.assertEquals((Object)this.mapper.readTree(json).toPrettyString(), (Object)json);
    }

    @Test
    public void testNoCache() throws JsonProcessingException {
        JsonUnflattener ju = new JsonUnflattener("{\"abc.def\":123}");
        Assertions.assertNotSame((Object)ju.unflatten(), (Object)ju.unflatten());
        Assertions.assertEquals((Object)"{\"abc\":{\"def\":123}}", (Object)ju.withPrintMode(PrintMode.MINIMAL).unflatten());
        ju = new JsonUnflattener(this.toMap("{\"abc.def\":123}"));
        Assertions.assertNotSame((Object)ju.unflatten(), (Object)ju.unflatten());
        Assertions.assertEquals((Object)"{\"abc\":{\"def\":123}}", (Object)ju.withPrintMode(PrintMode.MINIMAL).unflatten());
    }

    @Test
    public void testNullPointerException() {
        Assertions.assertThrows(NullPointerException.class, () -> new JsonUnflattener("{\"abc.def\":123}").withPrintMode(null));
    }

    @Test
    public void testInitByReader() throws IOException {
        StringReader sr = new StringReader("{\"abc.def\":123}");
        Assertions.assertEquals((Object)new JsonUnflattener("{\"abc.def\":123}"), (Object)new JsonUnflattener((Reader)sr));
    }

    @Test
    public void testInitByMap() throws JsonProcessingException {
        Assertions.assertEquals((Object)new JsonUnflattener("{\"abc.def\":123}"), (Object)new JsonUnflattener(this.toMap("{\"abc.def\":123}")));
    }

    @Test
    public void testFlattenModeMongodb() throws IOException {
        URL url = Resources.getResource((String)"test_mongo.json");
        String expectedJson = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        URL urlMongo = Resources.getResource((String)"test_mongo_flattened.json");
        String json = Resources.toString((URL)urlMongo, (Charset)Charsets.UTF_8);
        JsonUnflattener ju = new JsonUnflattener(json).withFlattenMode(FlattenMode.MONGODB);
        Assertions.assertEquals((Object)this.mapper.readTree(expectedJson).toString(), (Object)ju.unflatten());
        ju = new JsonUnflattener(this.toMap(json)).withFlattenMode(FlattenMode.MONGODB);
        Assertions.assertEquals((Object)this.mapper.readTree(expectedJson).toString(), (Object)ju.unflatten());
    }

    @Test
    public void testWithKeyTransformer() throws JsonProcessingException {
        String json = "{\"abc.de_f\":123}";
        JsonUnflattener ju = new JsonUnflattener(json).withFlattenMode(FlattenMode.MONGODB).withKeyTransformer(key -> key.replace('_', '.'));
        Assertions.assertEquals((Object)"{\"abc\":{\"de.f\":123}}", (Object)ju.unflatten());
        ju = new JsonUnflattener(this.toMap(json)).withFlattenMode(FlattenMode.MONGODB).withKeyTransformer(key -> key.replace('_', '.'));
        Assertions.assertEquals((Object)"{\"abc\":{\"de.f\":123}}", (Object)ju.unflatten());
    }

    @Test
    public void testWithFlattenModeKeepBottomArrays() throws IOException {
        URL url = Resources.getResource((String)"test_keep_primitive_arrays.json");
        String expectedJson = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        URL urlKBA = Resources.getResource((String)"test_keep_primitive_arrays_flattened.json");
        String json = Resources.toString((URL)urlKBA, (Charset)Charsets.UTF_8);
        JsonUnflattener ju = new JsonUnflattener(json).withFlattenMode(FlattenMode.KEEP_PRIMITIVE_ARRAYS);
        Assertions.assertEquals((Object)this.mapper.readTree(expectedJson).toString(), (Object)ju.unflatten());
        ju = new JsonUnflattener(this.toMap(json)).withFlattenMode(FlattenMode.KEEP_PRIMITIVE_ARRAYS);
        Assertions.assertEquals((Object)this.mapper.readTree(expectedJson).toString(), (Object)ju.unflatten());
    }

    @Test
    public void testWithJsonCore() throws IOException {
        URL url = Resources.getResource((String)"test_long_decimal.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        ObjectMapper mapper = new ObjectMapper(){
            private static final long serialVersionUID = 1L;
            {
                this.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
                this.configure(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS, true);
            }
        };
        JsonUnflattener ju = new JsonUnflattener((JsonCore)new JacksonJsonCore(mapper), json);
        ju.withPrintMode(PrintMode.PRETTY);
        Assertions.assertEquals((Object)mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)mapper.readTree(json)), (Object)ju.unflatten());
        ju = new JsonUnflattener((JsonCore)new JacksonJsonCore(mapper), (Reader)new StringReader(json));
        ju.withPrintMode(PrintMode.PRETTY);
        Assertions.assertEquals((Object)mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)mapper.readTree(json)), (Object)ju.unflatten());
        ju = new JsonUnflattener((JsonCore)new JacksonJsonCore(mapper), (Map)mapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(this){}));
        ju.withPrintMode(PrintMode.PRETTY);
        Assertions.assertEquals((Object)mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)mapper.readTree(json)), (Object)ju.unflatten());
    }
}

