/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types.basic;

import com.kubling.teiid.core.types.TransformationException;
import com.kubling.teiid.core.types.XMLType;
import com.kubling.teiid.core.types.basic.StringToSQLXMLTransform;
import java.sql.SQLXML;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStringToXmlTransform {
    @Test
    public void testGoodXML() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><customer>\n<name>ABC</name><age>32</age></customer>";
        StringToSQLXMLTransform transform = new StringToSQLXMLTransform();
        SQLXML xmlValue = (SQLXML)transform.transformDirect((Object)xml);
        Assertions.assertEquals((Object)xml.replaceAll("[\r]", ""), (Object)xmlValue.getString().replaceAll("[\r]", ""));
    }

    @Test
    public void testGoodElement() throws Exception {
        String xml = "<customer>\n<name>ABC</name><age>32</age></customer>";
        StringToSQLXMLTransform transform = new StringToSQLXMLTransform();
        XMLType xmlValue = (XMLType)transform.transformDirect((Object)xml);
        Assertions.assertEquals((Object)xml.replaceAll("[\r]", ""), (Object)xmlValue.getString().replaceAll("[\r]", ""));
        Assertions.assertEquals((Object)XMLType.Type.ELEMENT, (Object)xmlValue.getType());
    }

    @Test
    public void testBadXML() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><customer>\n<name>ABC</name><age>32</age><customer>";
        StringToSQLXMLTransform transform = new StringToSQLXMLTransform();
        Assertions.assertThrows(TransformationException.class, () -> transform.transformDirect((Object)xml));
    }
}

