/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.util;

import com.kubling.teiid.core.util.EquivalenceUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEquivalenceUtil {
    @Test
    public void testAreEqual() {
        Assertions.assertTrue((boolean)EquivalenceUtil.areEqual(null, null));
        Integer obj1 = 1000;
        Assertions.assertFalse((boolean)EquivalenceUtil.areEqual((Object)obj1, null));
        Assertions.assertFalse((boolean)EquivalenceUtil.areEqual(null, (Object)obj1));
        Assertions.assertTrue((boolean)EquivalenceUtil.areEqual((Object)obj1, (Object)obj1));
        Object obj2 = 1000;
        Assertions.assertTrue((boolean)EquivalenceUtil.areEqual((Object)obj1, (Object)obj2));
        Assertions.assertTrue((boolean)EquivalenceUtil.areEqual((Object)obj2, (Object)obj1));
        obj2 = "1000";
        Assertions.assertFalse((boolean)EquivalenceUtil.areEqual((Object)obj1, (Object)obj2));
        Assertions.assertFalse((boolean)EquivalenceUtil.areEqual((Object)obj2, (Object)obj1));
        obj2 = 1000;
        Integer obj3 = 1000;
        Assertions.assertTrue((boolean)EquivalenceUtil.areEqual((Object)obj1, (Object)obj2));
        Assertions.assertTrue((boolean)EquivalenceUtil.areEqual((Object)obj2, (Object)obj3));
        Assertions.assertTrue((boolean)EquivalenceUtil.areEqual((Object)obj1, (Object)obj3));
    }

    @Test
    public void testAreEquivalent() {
        Assertions.assertTrue((boolean)EquivalenceUtil.areEquivalent(null, null));
        Object[] array1 = new Object[]{};
        Assertions.assertFalse((boolean)EquivalenceUtil.areEquivalent((Object[])array1, null));
        Assertions.assertFalse((boolean)EquivalenceUtil.areEquivalent(null, (Object[])array1));
        Assertions.assertTrue((boolean)EquivalenceUtil.areEquivalent((Object[])array1, (Object[])array1));
        Object[] array2 = new Integer[]{};
        Assertions.assertTrue((boolean)EquivalenceUtil.areEquivalent((Object[])array1, (Object[])array2));
        array1 = new Integer[]{1, 2, 3};
        array2 = new Object[]{1, 2, 3};
        Assertions.assertTrue((boolean)EquivalenceUtil.areEquivalent((Object[])array1, (Object[])array2));
        array2 = new Object[]{1, 2, 3, null};
        Assertions.assertFalse((boolean)EquivalenceUtil.areEquivalent((Object[])array1, (Object[])array2));
    }

    @Test
    public void testAreStrictlyEquivalentObjectObject() {
        Assertions.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent(null, null));
        Integer obj1 = 1000;
        Assertions.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent((Object)obj1, (Object)obj1));
        Assertions.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent((Object)obj1, null));
        Assertions.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent(null, (Object)obj1));
        Integer obj2 = 1000;
        Assertions.assertTrue((boolean)EquivalenceUtil.areStrictlyEquivalent((Object)obj1, (Object)obj2));
        Assertions.assertTrue((boolean)EquivalenceUtil.areStrictlyEquivalent((Object)obj2, (Object)obj1));
    }

    @Test
    public void testAreStrictlyEquivalentObjectArrayObjectArray() {
        Assertions.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent(null, null));
        Object[] array1 = new Object[]{};
        Assertions.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array1, (Object[])array1));
        Assertions.assertTrue((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array1, null));
        Assertions.assertTrue((boolean)EquivalenceUtil.areStrictlyEquivalent(null, (Object[])array1));
        Object[] array2 = new String[2];
        Assertions.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array2, null));
        Assertions.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent(null, (Object[])array2));
        array2 = new Integer[]{};
        Assertions.assertTrue((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array1, (Object[])array2));
        Assertions.assertTrue((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array2, (Object[])array1));
        array1 = new Integer[]{1, 2, 3};
        array2 = new Object[]{1, 2, 3, null};
        Assertions.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array1, (Object[])array2));
        Assertions.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array2, (Object[])array1));
        array2 = new Object[array1.length];
        System.arraycopy(array1, 0, array2, 0, array1.length);
        Assertions.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array1, (Object[])array2));
        Assertions.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array2, (Object[])array1));
        array2 = new Integer[]{1, 2, 3};
    }
}

