/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.util;

import com.kubling.teiid.core.util.StringUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStringUtil {
    public void helpTestJoin(List input, String delimiter, String expectedResult) {
        String result = StringUtil.join((Collection)input, (String)delimiter);
        Assertions.assertEquals((Object)expectedResult, (Object)result);
    }

    public void helpTestReplace(String source, String search, String replace, String expectedResult) {
        String result = StringUtil.replace((String)source, (String)search, (String)replace);
        Assertions.assertEquals((Object)expectedResult, (Object)result);
    }

    public void helpTestReplaceAll(String source, String search, String replace, String expectedResult) {
        String result = StringUtil.replaceAll((String)source, (String)search, (String)replace);
        Assertions.assertEquals((Object)expectedResult, (Object)result, (String)"Unexpected ReplaceAll result");
    }

    @Test
    public void testJoin1() {
        ArrayList<String> input = new ArrayList<String>();
        input.add("One");
        input.add("Two");
        this.helpTestJoin(input, null, null);
    }

    @Test
    public void testJoin2() {
        this.helpTestJoin(null, "/", null);
    }

    @Test
    public void testJoin3() {
        ArrayList<String> input = new ArrayList<String>();
        input.add("One");
        input.add("Two");
        this.helpTestJoin(input, "/", "One/Two");
    }

    @Test
    public void testReplace1() {
        this.helpTestReplace("12225", null, "234", "12225");
    }

    @Test
    public void testReplace2() {
        this.helpTestReplace("12225", "222", null, "12225");
    }

    @Test
    public void testReplace3() {
        this.helpTestReplace("12225", "222", "234", "12345");
    }

    @Test
    public void testReplaceAll() {
        this.helpTestReplaceAll("1121121112", "2", "1", "1111111111");
    }

    @Test
    public void testGetStackTrace() {
        String expectedStackTrace = "java.lang.RuntimeException: Test";
        RuntimeException t = new RuntimeException("Test");
        String trace = StringUtil.getStackTrace((Throwable)t);
        if (!trace.startsWith("java.lang.RuntimeException: Test")) {
            Assertions.fail((String)("Stack trace: \n" + trace + "\n did not match expected stack trace: \njava.lang.RuntimeException: Test"));
        }
    }

    @Test
    public void testToString() {
        Object[] input = new String[]{"string1", "string2", "string3"};
        String output = StringUtil.toString((Object[])input);
        Assertions.assertEquals((Object)"[string1,string2,string3]", (Object)output);
    }

    @Test
    public void testGetTokens() {
        String input = "string with; tokens ; delimited by ; ; semicolons; there;; are 7 tokens.";
        List tokens = StringUtil.getTokens((String)"string with; tokens ; delimited by ; ; semicolons; there;; are 7 tokens.", (String)";");
        Assertions.assertEquals((int)7, (int)tokens.size());
        Assertions.assertEquals((Object)"string with", tokens.get(0));
        Assertions.assertEquals((Object)" tokens ", tokens.get(1));
        Assertions.assertEquals((Object)" delimited by ", tokens.get(2));
        Assertions.assertEquals((Object)" ", tokens.get(3));
        Assertions.assertEquals((Object)" semicolons", tokens.get(4));
        Assertions.assertEquals((Object)" there", tokens.get(5));
        Assertions.assertEquals((Object)" are 7 tokens.", tokens.get(6));
    }

    @Test
    public void testIndexOfIgnoreCase() {
        String text = "test";
        Assertions.assertEquals((int)-1, (int)StringUtil.indexOfIgnoreCase(null, (String)text));
        Assertions.assertEquals((int)-1, (int)StringUtil.indexOfIgnoreCase((String)"", (String)text));
        Assertions.assertEquals((int)-1, (int)StringUtil.indexOfIgnoreCase((String)text, null));
        Assertions.assertEquals((int)-1, (int)StringUtil.indexOfIgnoreCase((String)text, (String)""));
        Assertions.assertEquals((int)-1, (int)StringUtil.indexOfIgnoreCase((String)text, (String)"testing"));
        Assertions.assertEquals((int)1, (int)StringUtil.indexOfIgnoreCase((String)text, (String)"es"));
        Assertions.assertEquals((int)1, (int)StringUtil.indexOfIgnoreCase((String)text, (String)"Es"));
        Assertions.assertEquals((int)1, (int)StringUtil.indexOfIgnoreCase((String)text, (String)"eS"));
        Assertions.assertEquals((int)2, (int)StringUtil.indexOfIgnoreCase((String)text, (String)"ST"));
    }

    @Test
    public void testStartsWithIgnoreCase() {
        String text = "test";
        Assertions.assertFalse((boolean)StringUtil.startsWithIgnoreCase(null, (String)text));
        Assertions.assertFalse((boolean)StringUtil.startsWithIgnoreCase((String)"", (String)text));
        Assertions.assertFalse((boolean)StringUtil.startsWithIgnoreCase((String)text, null));
        Assertions.assertTrue((boolean)StringUtil.startsWithIgnoreCase((String)text, (String)""));
        Assertions.assertFalse((boolean)StringUtil.startsWithIgnoreCase((String)text, (String)"testing"));
        Assertions.assertFalse((boolean)StringUtil.startsWithIgnoreCase((String)text, (String)"es"));
        Assertions.assertTrue((boolean)StringUtil.startsWithIgnoreCase((String)text, (String)"te"));
        Assertions.assertTrue((boolean)StringUtil.startsWithIgnoreCase((String)text, (String)"Te"));
        Assertions.assertTrue((boolean)StringUtil.startsWithIgnoreCase((String)text, (String)"tE"));
        Assertions.assertTrue((boolean)StringUtil.startsWithIgnoreCase((String)text, (String)"TE"));
    }

    @Test
    public void testEndsWithIgnoreCase() {
        String text = "test";
        Assertions.assertFalse((boolean)StringUtil.endsWithIgnoreCase(null, (String)text));
        Assertions.assertFalse((boolean)StringUtil.endsWithIgnoreCase((String)"", (String)text));
        Assertions.assertFalse((boolean)StringUtil.endsWithIgnoreCase((String)text, null));
        Assertions.assertTrue((boolean)StringUtil.endsWithIgnoreCase((String)text, (String)""));
        Assertions.assertFalse((boolean)StringUtil.endsWithIgnoreCase((String)text, (String)"testing"));
        Assertions.assertFalse((boolean)StringUtil.endsWithIgnoreCase((String)text, (String)"es"));
        Assertions.assertTrue((boolean)StringUtil.endsWithIgnoreCase((String)text, (String)"st"));
        Assertions.assertTrue((boolean)StringUtil.endsWithIgnoreCase((String)text, (String)"St"));
        Assertions.assertTrue((boolean)StringUtil.endsWithIgnoreCase((String)text, (String)"sT"));
        Assertions.assertTrue((boolean)StringUtil.endsWithIgnoreCase((String)text, (String)"ST"));
    }

    @Test
    public void testIsLetter() {
        Assertions.assertTrue((boolean)StringUtil.isLetter((char)'a'));
        Assertions.assertTrue((boolean)StringUtil.isLetter((char)'A'));
        Assertions.assertFalse((boolean)StringUtil.isLetter((char)'5'));
        Assertions.assertFalse((boolean)StringUtil.isLetter((char)'_'));
        Assertions.assertTrue((boolean)StringUtil.isLetter((char)'\u00cf'));
        Assertions.assertFalse((boolean)StringUtil.isLetter((char)'\u0967'));
        Assertions.assertTrue((boolean)StringUtil.isLetter((char)'\u0905'));
    }

    @Test
    public void testIsDigit() {
        Assertions.assertFalse((boolean)StringUtil.isDigit((char)'a'));
        Assertions.assertFalse((boolean)StringUtil.isDigit((char)'A'));
        Assertions.assertTrue((boolean)StringUtil.isDigit((char)'5'));
        Assertions.assertFalse((boolean)StringUtil.isDigit((char)'_'));
        Assertions.assertFalse((boolean)StringUtil.isDigit((char)'\u00cf'));
        Assertions.assertTrue((boolean)StringUtil.isDigit((char)'\u0967'));
        Assertions.assertFalse((boolean)StringUtil.isDigit((char)'\u0905'));
    }

    @Test
    public void testIsLetterOrDigit() {
        Assertions.assertTrue((boolean)StringUtil.isLetterOrDigit((char)'a'));
        Assertions.assertTrue((boolean)StringUtil.isLetterOrDigit((char)'A'));
        Assertions.assertTrue((boolean)StringUtil.isLetterOrDigit((char)'5'));
        Assertions.assertFalse((boolean)StringUtil.isLetterOrDigit((char)'_'));
        Assertions.assertTrue((boolean)StringUtil.isLetterOrDigit((char)'\u00cf'));
        Assertions.assertTrue((boolean)StringUtil.isLetterOrDigit((char)'\u0967'));
        Assertions.assertTrue((boolean)StringUtil.isLetterOrDigit((char)'\u0905'));
    }

    @Test
    public void testGetFirstToken() {
        Assertions.assertEquals((Object)"/foo/bar", (Object)StringUtil.getFirstToken((String)"/foo/bar.vdb", (String)"."));
        Assertions.assertEquals((Object)"", (Object)StringUtil.getFirstToken((String)"/foo/bar.vdb", (String)"/"));
        Assertions.assertEquals((Object)"/foo", (Object)StringUtil.getFirstToken((String)"/foo./bar.vdb", (String)"."));
        Assertions.assertEquals((Object)"bar", (Object)StringUtil.getFirstToken((String)StringUtil.getLastToken((String)"/foo/bar.vdb", (String)"/"), (String)"."));
        Assertions.assertEquals((Object)"vdb", (Object)StringUtil.getLastToken((String)"/foo/bar.vdb", (String)"."));
    }

    @Test
    public void testValueOf() throws Exception {
        Assertions.assertEquals((Integer)21, (Integer)((Integer)StringUtil.valueOf((String)"21", Integer.class)));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)StringUtil.valueOf((String)"true", Boolean.class));
        Assertions.assertEquals((Object)"Foo", (Object)StringUtil.valueOf((String)"Foo", String.class));
        Assertions.assertEquals((Float)Float.valueOf(10.12f), (Float)((Float)StringUtil.valueOf((String)"10.12", Float.class)));
        Assertions.assertEquals((Double)121.123, (Double)((Double)StringUtil.valueOf((String)"121.123", Double.class)));
        Assertions.assertEquals((Long)12334567L, (Long)((Long)StringUtil.valueOf((String)"12334567", Long.class)));
        Assertions.assertEquals((Short)21, (Short)((Short)StringUtil.valueOf((String)"21", Short.class)));
        List list = (List)StringUtil.valueOf((String)"foo,bar,x,y,z", List.class);
        Assertions.assertEquals((int)5, (int)list.size());
        Assertions.assertTrue((boolean)list.contains("foo"));
        Assertions.assertTrue((boolean)list.contains("x"));
        int[] values = (int[])StringUtil.valueOf((String)"1,2,3,4,5", int[].class);
        Assertions.assertEquals((int)5, (int)values.length);
        Assertions.assertEquals((int)5, (int)values[4]);
        Map m = (Map)StringUtil.valueOf((String)"foo=bar,x=,y=z", Map.class);
        Assertions.assertEquals((int)3, (int)m.size());
        Assertions.assertEquals(m.get("foo"), (Object)"bar");
        Assertions.assertEquals(m.get("x"), (Object)"");
        Assertions.assertEquals((Object)((Object)EnumTest.HELLO), (Object)StringUtil.valueOf((String)"HELLO", EnumTest.class));
        Assertions.assertEquals((Object)new URL("http://teiid.org"), (Object)StringUtil.valueOf((String)"http://teiid.org", URL.class));
    }

    public static enum EnumTest {
        HELLO,
        WORLD;

    }
}

