/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core;

import com.kubling.teiid.core.util.ArgCheck;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class BundleUtil {
    private final String bundleName;
    private final ResourceBundle bundle;
    protected final String pluginId;

    public static BundleUtil getBundleUtil(Class<?> clazz) {
        String packageName = clazz.getPackage().getName();
        while (true) {
            String bundleName = packageName + ".i18n";
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), clazz.getClassLoader());
                return new BundleUtil(packageName, bundleName, bundle);
            }
            catch (MissingResourceException e) {
                int index = packageName.lastIndexOf(46);
                if (index < 0) {
                    throw e;
                }
                packageName = packageName.substring(0, index);
                continue;
            }
            break;
        }
    }

    public BundleUtil(String pluginId, String bundleName, ResourceBundle bundle) {
        this.pluginId = pluginId;
        this.bundleName = bundleName;
        this.bundle = bundle;
    }

    public String getString(String key) {
        try {
            return this.bundle.getString(key);
        }
        catch (Exception err) {
            Object msg = err instanceof NullPointerException ? "<No message available>" : (err instanceof MissingResourceException ? "<Missing message for key \"" + key + "\" in: " + this.bundleName + ">" : err.getLocalizedMessage());
            return msg;
        }
    }

    public boolean keyExists(String key) {
        try {
            return this.bundle.getString(key) != null;
        }
        catch (Exception err) {
            return false;
        }
    }

    public String getString(String key, List parameters) {
        if (parameters == null) {
            return this.getString(key);
        }
        return this.getString(key, parameters.toArray());
    }

    public String getString(String key, Object ... parameters) {
        String text = this.getString(key);
        if (text == null) {
            return "<" + key + ">";
        }
        if (parameters == null || parameters.length == 0) {
            return text;
        }
        return MessageFormat.format(text, parameters);
    }

    public String gs(String key, Object ... parameters) {
        return this.getString(key, parameters);
    }

    public String gs(Event key, Object ... parameters) {
        return String.valueOf(key) + " " + this.getString(key.toString(), parameters);
    }

    public String getStringOrKey(String key) {
        ArgCheck.isNotNull(key);
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException err) {
            return key;
        }
    }

    public static interface Event {
    }
}

