/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types.basic;

import com.kubling.teiid.core.types.Transform;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseDatetimeTransform
extends Transform {
    protected static final List<DateTimeFormatter> formatters = new ArrayList<DateTimeFormatter>();
    protected static final Pattern literalsRegexPattern = Pattern.compile("\\{(d|t|ts) '([^']*)'\\}");
    private static final Pattern nanoPrecisionPattern = Pattern.compile("(?<prefix>.*?\\d{2}:\\d{2}:\\d{2})\\.(?<fraction>\\d{4,9})");

    protected static Timestamp normalizeToTimestamp(String dt) {
        Matcher nanoMatch;
        Matcher matcher = literalsRegexPattern.matcher(dt);
        if (matcher.matches() && matcher.group(1).equals("ts")) {
            dt = matcher.group(2);
        }
        if ((nanoMatch = nanoPrecisionPattern.matcher(dt)).matches()) {
            try {
                String base = nanoMatch.group("prefix");
                StringBuilder fraction = new StringBuilder(nanoMatch.group("fraction"));
                if (fraction.length() > 9) {
                    fraction = new StringBuilder(fraction.substring(0, 9));
                }
                while (fraction.length() < 9) {
                    fraction.append("0");
                }
                LocalDateTime ldt = LocalDateTime.parse(base, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                ldt = ldt.withNano(Integer.parseInt(fraction.toString()));
                return Timestamp.valueOf(ldt);
            }
            catch (Exception base) {
                // empty catch block
            }
        }
        for (DateTimeFormatter formatter : formatters) {
            try {
                TemporalAccessor accessor = formatter.parse(dt);
                if (accessor.isSupported(ChronoField.HOUR_OF_DAY)) {
                    LocalDateTime ldt = LocalDateTime.from(accessor);
                    return Timestamp.valueOf(ldt);
                }
                LocalDate ld = LocalDate.from(accessor);
                return Timestamp.valueOf(ld.atStartOfDay());
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        try {
            return Timestamp.from(Instant.ofEpochSecond(Long.parseLong(dt)));
        }
        catch (NumberFormatException base) {
            try {
                return Timestamp.from(Instant.parse(dt));
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException("Invalid timestamp format: " + dt);
            }
        }
    }

    protected static Date normalizeToDate(String dt) {
        Matcher matcher = literalsRegexPattern.matcher(dt);
        if (matcher.matches() && matcher.group(1).equals("d")) {
            dt = matcher.group(2);
        }
        for (DateTimeFormatter formatter : formatters) {
            try {
                return Date.valueOf(LocalDate.parse(dt, formatter));
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        try {
            return new Date(Long.parseLong(dt) * 1000L);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new Date(Instant.parse(dt).toEpochMilli());
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException("Invalid date format: " + dt);
            }
        }
    }

    protected static Time normalizeToTime(String dt) {
        Matcher nanoMatch;
        Matcher matcher = literalsRegexPattern.matcher(dt);
        if (matcher.find() && matcher.group(1).equals("t")) {
            dt = matcher.group(2);
        }
        if ((nanoMatch = nanoPrecisionPattern.matcher(dt)).matches()) {
            try {
                String base = nanoMatch.group("prefix");
                StringBuilder fraction = new StringBuilder(nanoMatch.group("fraction"));
                while (fraction.length() < 9) {
                    fraction.append("0");
                }
                LocalTime lt = LocalTime.parse(base, DateTimeFormatter.ofPattern("HH:mm:ss")).withNano(Integer.parseInt(fraction.toString()));
                return Time.valueOf(lt);
            }
            catch (Exception base) {
                // empty catch block
            }
        }
        for (DateTimeFormatter formatter : formatters) {
            try {
                return Time.valueOf(LocalTime.parse(dt, formatter));
            }
            catch (DateTimeParseException lt) {
            }
        }
        try {
            long epoch = Long.parseLong(dt);
            Instant instant = Instant.ofEpochSecond(epoch);
            LocalTime time = instant.atZone(ZoneOffset.UTC).toLocalTime();
            return Time.valueOf(time);
        }
        catch (NumberFormatException | DateTimeException epoch) {
            try {
                Instant instant = Instant.parse(dt);
                LocalTime time = instant.atZone(ZoneOffset.UTC).toLocalTime();
                return Time.valueOf(time);
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException("Invalid time format: " + dt);
            }
        }
    }

    static {
        formatters.add(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        formatters.add(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        formatters.add(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S"));
        formatters.add(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SS"));
        formatters.add(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
        formatters.add(DateTimeFormatter.ofPattern("MM/dd/yyyy"));
        formatters.add(DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss"));
        formatters.add(DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss.S"));
        formatters.add(DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss.SS"));
        formatters.add(DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss.SSS"));
        formatters.add(DateTimeFormatter.ofPattern("dd-MM-yyyy"));
        formatters.add(DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss"));
        formatters.add(DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss.S"));
        formatters.add(DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss.SS"));
        formatters.add(DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss.SSS"));
        formatters.add(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
        formatters.add(DateTimeFormatter.ofPattern("HH:mm:ss"));
        formatters.add(DateTimeFormatter.ofPattern("HH:mm:ss.SSS"));
    }
}

