/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types.basic;

import com.kubling.teiid.core.types.DataTypeManager;
import com.kubling.teiid.core.types.TransformationException;
import com.kubling.teiid.core.types.basic.NumberToNumberTransform;

public class NumberToIntegerTransform
extends NumberToNumberTransform {
    private final boolean isNarrowing;

    public NumberToIntegerTransform(Class<?> sourceType, boolean isNarrowing) {
        super(Integer.MIN_VALUE, Integer.MAX_VALUE, sourceType);
        this.isNarrowing = isNarrowing;
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        if (this.isNarrowing) {
            this.checkValueRange(value);
        }
        return ((Number)value).intValue();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.INTEGER;
    }

    @Override
    public boolean isExplicit() {
        return this.isNarrowing;
    }
}

