/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types.basic;

import com.kubling.teiid.core.types.DataTypeManager;
import com.kubling.teiid.core.types.TransformationException;
import com.kubling.teiid.core.types.basic.NumberToNumberTransform;

public class NumberToLongTransform
extends NumberToNumberTransform {
    private final boolean isNarrowing;
    private final boolean isLossy;

    public NumberToLongTransform(Class<?> sourceType, boolean isNarrowing, boolean isLossy) {
        super(Long.MIN_VALUE, Long.MAX_VALUE, sourceType);
        this.isNarrowing = isNarrowing;
        this.isLossy = isLossy;
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        if (this.isNarrowing) {
            this.checkValueRange(value);
        }
        return ((Number)value).longValue();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.LONG;
    }

    @Override
    public boolean isExplicit() {
        return this.isNarrowing || this.isLossy;
    }
}

