/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types.basic;

import com.kubling.teiid.core.BundleUtil;
import com.kubling.teiid.core.CorePlugin;
import com.kubling.teiid.core.types.ArrayImpl;
import com.kubling.teiid.core.types.DataTypeManager;
import com.kubling.teiid.core.types.Transform;
import com.kubling.teiid.core.types.TransformationException;
import java.lang.reflect.Array;
import java.sql.SQLException;

public class ObjectToAnyTransform
extends Transform {
    public static final ObjectToAnyTransform INSTANCE = new ObjectToAnyTransform(Object.class);
    private final Class targetClass;

    public ObjectToAnyTransform(Class targetClass) {
        this.targetClass = targetClass;
    }

    public Class getSourceType() {
        return DataTypeManager.DefaultDataClasses.OBJECT;
    }

    public Class getTargetType() {
        return this.targetClass;
    }

    @Override
    public Object transform(Object value, Class<?> targetType) throws TransformationException {
        if (value == null) {
            return null;
        }
        if (targetType.isAssignableFrom(value.getClass())) {
            return value;
        }
        Transform transform = DataTypeManager.getTransform(value.getClass(), targetType);
        boolean valid = true;
        if (transform instanceof ObjectToAnyTransform) {
            Object v1 = DataTypeManager.convertToRuntimeType(value, true);
            if (v1 != value) {
                try {
                    return this.transform(v1, targetType);
                }
                catch (TransformationException e) {
                    throw new TransformationException(CorePlugin.Event.TEIID10076, e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10076, this.getSourceType(), this.targetClass, value));
                }
            }
            if (targetType.isArray()) {
                if (value instanceof java.sql.Array) {
                    try {
                        Object array = ((java.sql.Array)value).getArray();
                        if (targetType.isAssignableFrom(array.getClass())) {
                            if (!(value instanceof ArrayImpl)) {
                                return new ArrayImpl((Object[])array);
                            }
                            return value;
                        }
                        value = array;
                    }
                    catch (SQLException e) {
                        throw new TransformationException(e);
                    }
                }
                if (value.getClass().isArray()) {
                    if (value.getClass().getComponentType().isPrimitive() && targetType.getComponentType().isAssignableFrom(ObjectToAnyTransform.convertPrimitiveToObject(value.getClass().getComponentType()))) {
                        Object[] result = (Object[])Array.newInstance(targetType.getComponentType(), Array.getLength(value));
                        for (int i = 0; i < result.length; ++i) {
                            result[i] = Array.get(value, i);
                        }
                        return new ArrayImpl(result);
                    }
                    Class<?> targetComponentType = targetType.getComponentType();
                    Object[] result = (Object[])Array.newInstance(targetComponentType, Array.getLength(value));
                    for (int i = 0; i < result.length; ++i) {
                        Object v = Array.get(value, i);
                        if (v.getClass() == targetComponentType || DataTypeManager.DefaultDataClasses.OBJECT == targetComponentType) {
                            result[i] = v;
                            continue;
                        }
                        Transform subTransform = DataTypeManager.getTransform(v.getClass(), targetComponentType);
                        if (subTransform == null) {
                            valid = false;
                            break;
                        }
                        result[i] = subTransform.transform(v, targetComponentType);
                    }
                    if (valid) {
                        return new ArrayImpl(result);
                    }
                }
            }
            valid = false;
        }
        if (transform == null || !valid) {
            Object[] params = new Object[]{this.getSourceType(), targetType, value};
            throw new TransformationException((BundleUtil.Event)CorePlugin.Event.TEIID10076, CorePlugin.Util.gs(CorePlugin.Event.TEIID10076, params));
        }
        try {
            return transform.transform(value, targetType);
        }
        catch (TransformationException e) {
            Object[] params = new Object[]{this.getSourceType(), targetType, value};
            throw new TransformationException(CorePlugin.Event.TEIID10076, e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10076, params));
        }
    }

    @Override
    protected Object transformDirect(Object value) throws TransformationException {
        return value;
    }

    @Override
    public boolean isExplicit() {
        return true;
    }

    public static Class<?> convertPrimitiveToObject(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Boolean.TYPE) {
            clazz = Boolean.class;
        } else if (clazz == Character.TYPE) {
            clazz = Character.class;
        } else if (clazz == Byte.TYPE) {
            clazz = Byte.class;
        } else if (clazz == Short.TYPE) {
            clazz = Short.class;
        } else if (clazz == Integer.TYPE) {
            clazz = Integer.class;
        } else if (clazz == Long.TYPE) {
            clazz = Long.class;
        } else if (clazz == Float.TYPE) {
            clazz = Float.class;
        } else if (clazz == Double.TYPE) {
            clazz = Double.class;
        }
        return clazz;
    }
}

