/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.util;

import com.kubling.teiid.core.CorePlugin;
import java.util.Collection;
import java.util.Map;

public class ArgCheck {
    private ArgCheck() {
    }

    public static void isTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isNonNegative(int value) {
        ArgCheck.isNonNegative(value, null);
    }

    public static void isNonNegative(int value, String message) {
        if (value < 0) {
            String msg = message != null ? message : CorePlugin.Util.getString("ArgCheck.isNonNegativeInt");
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isNonPositive(int value) {
        ArgCheck.isNonPositive(value, null);
    }

    public static void isNonPositive(int value, String message) {
        if (value > 0) {
            String msg = message != null ? message : CorePlugin.Util.getString("ArgCheck.isNonPositiveInt");
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isNegative(int value) {
        ArgCheck.isNegative(value, null);
    }

    public static void isNegative(int value, String message) {
        if (value >= 0) {
            String msg = message != null ? message : CorePlugin.Util.getString("ArgCheck.isNegativeInt");
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isPositive(int value) {
        ArgCheck.isPositive(value, null);
    }

    public static void isPositive(int value, String message) {
        if (value <= 0) {
            String msg = message != null ? message : CorePlugin.Util.getString("ArgCheck.isPositiveInt");
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isNonNegative(long value) {
        ArgCheck.isNonNegative(value, null);
    }

    public static void isNonNegative(long value, String message) {
        if (value < 0L) {
            String msg = message != null ? message : CorePlugin.Util.getString("ArgCheck.isNonNegativeInt");
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isNonPositive(long value) {
        ArgCheck.isNonPositive(value, null);
    }

    public static void isNonPositive(long value, String message) {
        if (value > 0L) {
            String msg = message != null ? message : CorePlugin.Util.getString("ArgCheck.isNonPositiveInt");
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isNegative(long value) {
        ArgCheck.isNegative(value, null);
    }

    public static void isNegative(long value, String message) {
        if (value >= 0L) {
            String msg = message != null ? message : CorePlugin.Util.getString("ArgCheck.isNegativeInt");
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isPositive(long value) {
        ArgCheck.isPositive(value, null);
    }

    public static void isPositive(long value, String message) {
        if (value <= 0L) {
            String msg = message != null ? message : CorePlugin.Util.getString("ArgCheck.isPositiveInt");
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isNotZeroLength(String value) {
        ArgCheck.isNotZeroLength(value, null);
    }

    public static void isNotZeroLength(String value, String message) {
        ArgCheck.isNotNull(value);
        if (value.isEmpty()) {
            String msg = message != null ? message : CorePlugin.Util.getString("ArgCheck.isStringNonZeroLength");
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isNotNull(Object value) {
        ArgCheck.isNotNull(value, null);
    }

    public static void isNotNull(Object value, String message) {
        if (value == null) {
            String msg = message != null ? message : CorePlugin.Util.getString("ArgCheck.isNonNull");
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isNull(Object value) {
        ArgCheck.isNull(value, null);
    }

    public static void isNull(Object value, String message) {
        if (value != null) {
            String msg = message != null ? message : CorePlugin.Util.getString("ArgCheck.isNull");
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isInstanceOf(Class theClass, Object value) {
        ArgCheck.isInstanceOf(theClass, value, null);
    }

    public static void isInstanceOf(Class theClass, Object value, String message) {
        ArgCheck.isNotNull(value);
        if (!theClass.isInstance(value)) {
            String msg = message != null ? message : CorePlugin.Util.getString("ArgCheck.isInstanceOf", theClass.getName(), value.getClass().getName());
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isNotEmpty(Collection collection) {
        ArgCheck.isNotEmpty(collection, null);
    }

    public static void isNotEmpty(Collection collection, String message) {
        ArgCheck.isNotNull(collection);
        if (collection.isEmpty()) {
            String msg = message != null ? message : CorePlugin.Util.getString("ArgCheck.isCollectionNotEmpty");
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isNotEmpty(Map map) {
        ArgCheck.isNotEmpty(map, null);
    }

    public static void isNotEmpty(Map map, String message) {
        ArgCheck.isNotNull(map);
        if (map.isEmpty()) {
            String msg = message != null ? message : CorePlugin.Util.getString("ArgCheck.isMapNotEmpty");
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isNotEmpty(Object[] array) {
        ArgCheck.isNotEmpty(array, null);
    }

    public static void isNotEmpty(Object[] array, String message) {
        ArgCheck.isNotNull(array);
        if (array.length == 0) {
            String msg = message != null ? message : CorePlugin.Util.getString("ArgCheck.isArrayNotEmpty");
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isNotEmpty(String string) {
        ArgCheck.isNotZeroLength(string, null);
    }

    public static void isNotEmpty(String string, String message) {
        ArgCheck.isNotZeroLength(string, message);
    }

    public static void isNotSame(Object firstObject, String firstName, Object secondObject, String secondName) {
        if (firstObject == secondObject) {
            if (firstName == null && firstObject != null) {
                firstName = firstObject.toString();
            }
            if (secondName == null && secondObject != null) {
                secondName = secondObject.toString();
            }
            throw new IllegalArgumentException(CorePlugin.Util.getString("ArgCheck.isNotSame", firstName, secondName));
        }
    }

    public static void contains(Collection collection, Object value) {
        ArgCheck.contains(collection, value, null);
    }

    public static void contains(Collection collection, Object value, String message) {
        ArgCheck.isNotNull(collection);
        if (!collection.contains(value)) {
            String msg = message != null ? message : CorePlugin.Util.getString("ArgCheck.contains");
            throw new IllegalArgumentException(msg);
        }
    }

    public static void containsKey(Map map, Object key) {
        ArgCheck.containsKey(map, key, null);
    }

    public static void containsKey(Map map, Object key, String message) {
        ArgCheck.isNotNull(map);
        if (!map.containsKey(key)) {
            String msg = message != null ? message : CorePlugin.Util.getString("ArgCheck.containsKey");
            throw new IllegalArgumentException(msg);
        }
    }
}

