/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.util;

import com.kubling.teiid.core.types.AbstractGeospatialType;
import com.kubling.teiid.core.types.ArrayImpl;
import com.kubling.teiid.core.types.BaseClobType;
import com.kubling.teiid.core.types.BaseLob;
import com.kubling.teiid.core.types.BinaryType;
import com.kubling.teiid.core.types.BlobImpl;
import com.kubling.teiid.core.types.BlobType;
import com.kubling.teiid.core.types.ClobImpl;
import com.kubling.teiid.core.types.ClobType;
import com.kubling.teiid.core.types.DataTypeManager;
import com.kubling.teiid.core.types.GeographyType;
import com.kubling.teiid.core.types.GeometryType;
import com.kubling.teiid.core.types.NullType;
import com.kubling.teiid.core.types.SQLXMLImpl;
import com.kubling.teiid.core.types.Streamable;
import com.kubling.teiid.core.types.XMLType;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public final class ObjectInputStreamWithClassloader
extends ObjectInputStream {
    private final ClassLoader cl;
    private static final Set<String> safeClasses = new HashSet<String>();

    public ObjectInputStreamWithClassloader(InputStream in, ClassLoader cl) throws IOException {
        super(in);
        this.cl = cl;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            ObjectInputStreamWithClassloader.checkClass(desc.getName());
            return Class.forName(desc.getName(), false, this.cl);
        }
        catch (ClassNotFoundException e) {
            return super.resolveClass(desc);
        }
    }

    public static void checkClass(String name) throws ClassNotFoundException {
        if (name.startsWith("[")) {
            if ("BCDFIJSZ".indexOf(name.charAt(1)) >= 0) {
                return;
            }
            String elementType = name;
            while (elementType.startsWith("[")) {
                elementType = elementType.substring(1);
            }
            if (elementType.startsWith("L") && elementType.endsWith(";")) {
                elementType = elementType.substring(1, elementType.length() - 1);
            }
            ObjectInputStreamWithClassloader.checkClass(elementType);
            return;
        }
        if (ObjectInputStreamWithClassloader.isJavaUtilCollection(name)) {
            return;
        }
        if (!safeClasses.contains(name)) {
            throw new ClassNotFoundException("Blocked class: " + name);
        }
    }

    private static boolean isJavaUtilCollection(String name) {
        return name.equals("java.util.ArrayList") || name.equals("java.util.LinkedList") || name.equals("java.util.HashSet") || name.equals("java.util.LinkedHashSet") || name.equals("java.util.TreeSet") || name.equals("java.util.HashMap") || name.equals("java.util.LinkedHashMap") || name.equals("java.util.TreeMap");
    }

    static {
        safeClasses.add("java.lang.Number");
        safeClasses.add("java.util.Properties");
        safeClasses.add("java.util.Hashtable");
        safeClasses.add("java.util.Arrays$ArrayList");
        safeClasses.add("sun.util.calendar.ZoneInfo");
        safeClasses.add("java.util.TimeZone");
        safeClasses.add("com.kubling.teiid.net.socket.Handshake");
        safeClasses.add("com.kubling.teiid.net.socket.Message");
        safeClasses.add("com.kubling.teiid.net.socket.ServiceInvocationStruct");
        safeClasses.add("com.kubling.teiid.client.security.ILogon");
        safeClasses.add("com.kubling.teiid.client.security.LogonResult");
        safeClasses.add("com.kubling.teiid.client.security.SessionToken");
        safeClasses.add("com.kubling.teiid.client.DQP");
        safeClasses.add("com.kubling.teiid.client.RequestMessage");
        safeClasses.add("com.kubling.teiid.client.ResultsMessage");
        safeClasses.addAll(DataTypeManager.getAllDataTypeClasses().stream().map(Class::getName).collect(Collectors.toSet()));
        safeClasses.add(ClobType.class.getName());
        safeClasses.add(BaseClobType.class.getName());
        safeClasses.add(ClobImpl.class.getName());
        safeClasses.add(BlobType.class.getName());
        safeClasses.add(BlobImpl.class.getName());
        safeClasses.add(BaseLob.class.getName());
        safeClasses.add(XMLType.class.getName());
        safeClasses.add(SQLXMLImpl.class.getName());
        safeClasses.add(Streamable.class.getName());
        safeClasses.add(ArrayImpl.class.getName());
        safeClasses.add(BinaryType.class.getName());
        safeClasses.add(NullType.class.getName());
        safeClasses.add(GeometryType.class.getName());
        safeClasses.add(GeographyType.class.getName());
        safeClasses.add(AbstractGeospatialType.class.getName());
    }
}

