/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.util;

import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class StringUtil {
    public static String join(Collection<String> strings, String delimiter) {
        if (Objects.isNull(delimiter)) {
            return null;
        }
        return StringUtils.join(strings, (String)delimiter);
    }

    public static String toString(Object[] array, String delim) {
        return StringUtil.toString(array, delim, true);
    }

    public static String toString(Object[] array, String delim, boolean includeBrackets) {
        if (array == null) {
            return "";
        }
        String joined = StringUtils.join((Object[])array, (String)delim);
        return includeBrackets ? "[" + joined + "]" : joined;
    }

    public static String toString(Object[] array) {
        return StringUtil.toString(array, ",", true);
    }

    public static List<String> split(String str, String splitter) {
        StringTokenizer tokens = new StringTokenizer(str, splitter);
        ArrayList<String> l = new ArrayList<String>(tokens.countTokens());
        while (tokens.hasMoreTokens()) {
            l.add(tokens.nextToken());
        }
        return l;
    }

    public static String replace(String source, String search, String replace) {
        return StringUtils.replace((String)source, (String)search, (String)replace);
    }

    public static String replaceAll(String source, String search, String replace) {
        return RegExUtils.replaceAll((String)source, (String)search, (String)replace);
    }

    public static List<String> getTokens(String str, String delimiter) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(str, delimiter);
        while (tokens.hasMoreTokens()) {
            l.add(tokens.nextToken());
        }
        return l;
    }

    public static String getLastToken(String str, String delimiter) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        String[] parts = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)str, (String)delimiter);
        return parts.length > 0 ? parts[parts.length - 1] : "";
    }

    public static String getFirstToken(String str, String delimiter) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        String[] parts = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)str, (String)delimiter);
        return parts.length > 0 ? parts[0] : "";
    }

    public static String getStackTrace(Throwable t) {
        return ExceptionUtils.getStackTrace((Throwable)t);
    }

    public static boolean isEmpty(String text) {
        return StringUtils.isEmpty((CharSequence)text);
    }

    public static int indexOfIgnoreCase(String text, String str) {
        if (StringUtil.isEmpty(text)) {
            return -1;
        }
        if (StringUtil.isEmpty(str)) {
            return -1;
        }
        int len = text.length() - str.length();
        for (int i = 0; i <= len; ++i) {
            if (!text.regionMatches(true, i, str, 0, str.length())) continue;
            return i;
        }
        return -1;
    }

    public static boolean startsWithIgnoreCase(String text, String prefix) {
        if (text == null || prefix == null) {
            return false;
        }
        return StringUtils.startsWithIgnoreCase((CharSequence)text, (CharSequence)prefix);
    }

    public static boolean endsWithIgnoreCase(String text, String suffix) {
        if (text == null || suffix == null) {
            return false;
        }
        return StringUtils.endsWithIgnoreCase((CharSequence)text, (CharSequence)suffix);
    }

    private StringUtil() {
    }

    public static boolean isLetter(char c) {
        return StringUtil.isBasicLatinLetter(c) || Character.isLetter(c);
    }

    public static boolean isDigit(char c) {
        return StringUtil.isBasicLatinDigit(c) || Character.isDigit(c);
    }

    public static boolean isLetterOrDigit(char c) {
        return StringUtil.isBasicLatinLetter(c) || StringUtil.isBasicLatinDigit(c) || Character.isLetterOrDigit(c);
    }

    private static boolean isBasicLatinLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isBasicLatinDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static <T> T valueOf(String value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (type == String.class) {
            return (T)value;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.valueOf(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.valueOf(value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return (T)Byte.valueOf(value);
        }
        if (type.isEnum()) {
            return (T)Enum.valueOf(type.asSubclass(Enum.class), value);
        }
        if (type == URL.class) {
            try {
                return (T)new URL(value);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid URL: " + value, e);
            }
        }
        if (List.class.isAssignableFrom(type)) {
            return (T)Arrays.asList(value.split(","));
        }
        if (Set.class.isAssignableFrom(type)) {
            return (T)new HashSet<String>(Arrays.asList(value.split(",")));
        }
        if (Map.class.isAssignableFrom(type)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String pair : value.split(",")) {
                int idx = pair.indexOf(61);
                if (idx <= 0) continue;
                map.put(pair.substring(0, idx), pair.substring(idx + 1));
            }
            return (T)map;
        }
        if (type.isArray()) {
            String[] values = value.split(",");
            Class<?> componentType = type.getComponentType();
            Object array = Array.newInstance(componentType, values.length);
            for (int i = 0; i < values.length; ++i) {
                Array.set(array, i, StringUtil.valueOf(values[i].trim(), componentType));
            }
            return (T)array;
        }
        if (type == Void.class || type == Void.TYPE) {
            return null;
        }
        throw new IllegalArgumentException("Unsupported conversion from String to " + type.getName());
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        return StringUtils.equalsIgnoreCase((CharSequence)s1, (CharSequence)s2);
    }

    public static <T extends Enum<T>> T caseInsensitiveValueOf(Class<T> enumType, String name) {
        try {
            return Enum.valueOf(enumType, name);
        }
        catch (IllegalArgumentException e) {
            Enum[] vals;
            for (Enum t : vals = (Enum[])enumType.getEnumConstants()) {
                if (!name.equalsIgnoreCase(t.name())) continue;
                return (T)t;
            }
            throw e;
        }
    }

    public static List<String> tokenize(String str, char delim) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == delim) {
                if (escaped) {
                    current.append(c);
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (escaped && !current.isEmpty()) {
                result.add(current.toString());
                current.setLength(0);
                escaped = false;
            }
            current.append(c);
        }
        if (!current.isEmpty()) {
            result.add(current.toString());
        }
        return result;
    }

    public static String unescape(CharSequence input, int quoteChar, boolean useAsciiEscapes, StringBuilder sb) {
        boolean escaped = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (escaped) {
                switch (c) {
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'u': {
                        int startIndex = i + 1;
                        int endIndex = startIndex + 4;
                        if (endIndex <= input.length()) {
                            String hex = input.subSequence(startIndex, endIndex).toString();
                            try {
                                int unicode = Integer.parseInt(hex, 16);
                                sb.append((char)unicode);
                            }
                            catch (NumberFormatException e) {
                                throw new IllegalArgumentException("Invalid Unicode escape: \\u" + hex);
                            }
                            i += 4;
                            break;
                        }
                        throw new IllegalArgumentException("Incomplete Unicode escape sequence at position " + i);
                    }
                    default: {
                        if (c == quoteChar) {
                            sb.append((char)quoteChar);
                            break;
                        }
                        if (useAsciiEscapes && Character.digit(c, 8) != -1) {
                            char nextChar;
                            int digit;
                            int j;
                            int octalValue = Character.digit(c, 8);
                            for (j = 1; j < 3 && i + j < input.length() && (digit = Character.digit(nextChar = input.charAt(i + j), 8)) != -1; ++j) {
                                octalValue = (octalValue << 3) + digit;
                            }
                            sb.append((char)octalValue);
                            i += j - 1;
                            break;
                        }
                        sb.append(c);
                    }
                }
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == quoteChar) break;
            sb.append(c);
        }
        if (escaped) {
            throw new IllegalArgumentException("Incomplete escape sequence at end of input");
        }
        return sb.toString();
    }

    private static int parseNumericValue(CharSequence string, StringBuilder sb, int i, int value, int possibleDigits, int radixExp) {
        char digit;
        int val;
        for (int j = 0; j < possibleDigits && i + 1 != string.length() && (val = Character.digit(digit = string.charAt(i + 1), 1 << radixExp)) != -1; ++j) {
            ++i;
            value = (value << radixExp) + val;
        }
        sb.append((char)value);
        return i;
    }

    public static interface Constants {
        public static final String EMPTY_STRING = "";
        public static final String SPACE = " ";
    }
}

