/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.json.flattener;

import com.kubling.teiid.core.json.flattener.IndexedPeekIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IndexedPeekIteratorTest {
    IndexedPeekIterator<Integer> pIterater;
    IndexedPeekIterator<Integer> emptyIterater;

    @BeforeEach
    public void setUp() {
        this.pIterater = new IndexedPeekIterator(new ArrayList<Integer>(Arrays.asList(1, 2, 3, 4)).iterator());
        this.emptyIterater = new IndexedPeekIterator(Collections.emptyIterator());
    }

    @Test
    public void testConstructorException() {
        Assertions.assertThrows(NullPointerException.class, () -> new IndexedPeekIterator(null));
    }

    @Test
    public void testIterface() {
        Assertions.assertInstanceOf(Iterator.class, this.pIterater);
    }

    @Test
    public void testRemove() {
        ArrayList<Integer> list = new ArrayList<Integer>(Arrays.asList(1, 2, 3, 4));
        this.pIterater = new IndexedPeekIterator(list.iterator());
        this.pIterater.next();
        this.pIterater.remove();
        Assertions.assertEquals(new ArrayList<Integer>(Arrays.asList(2, 3, 4)), list);
    }

    @Test
    public void testHasNext() {
        Assertions.assertTrue((boolean)this.pIterater.hasNext());
        Assertions.assertFalse((boolean)this.emptyIterater.hasNext());
    }

    @Test
    public void testNext() {
        Assertions.assertEquals((Integer)1, (Integer)((Integer)this.pIterater.next()));
        this.pIterater.next();
        this.pIterater.next();
        Assertions.assertEquals((Integer)4, (Integer)((Integer)this.pIterater.next()));
    }

    @Test
    public void testNextException() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.emptyIterater.next());
    }

    @Test
    public void testPeek() {
        Assertions.assertEquals((Integer)1, (Integer)((Integer)this.pIterater.peek()));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)this.pIterater.peek()));
        this.pIterater.next();
        Assertions.assertEquals((Integer)2, (Integer)((Integer)this.pIterater.peek()));
    }

    @Test
    public void testPeekException() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.emptyIterater.peek());
    }

    @Test
    public void testRemoveException() {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            this.pIterater.peek();
            this.pIterater.remove();
        });
    }

    @Test
    public void testGetIndex() {
        Assertions.assertEquals((int)-1, (int)this.pIterater.getIndex());
        this.pIterater.peek();
        Assertions.assertEquals((int)-1, (int)this.pIterater.getIndex());
        this.pIterater.next();
        Assertions.assertEquals((int)0, (int)this.pIterater.getIndex());
        this.pIterater.peek();
        Assertions.assertEquals((int)0, (int)this.pIterater.getIndex());
        this.pIterater.next();
        Assertions.assertEquals((int)1, (int)this.pIterater.getIndex());
        this.pIterater.peek();
        Assertions.assertEquals((int)1, (int)this.pIterater.getIndex());
        this.pIterater.next();
        Assertions.assertEquals((int)2, (int)this.pIterater.getIndex());
        this.pIterater.peek();
        Assertions.assertEquals((int)2, (int)this.pIterater.getIndex());
        this.pIterater.next();
        Assertions.assertEquals((int)3, (int)this.pIterater.getIndex());
    }

    @Test
    public void testGetCurrent() {
        Assertions.assertNull((Object)this.pIterater.getCurrent());
        this.pIterater.peek();
        Assertions.assertNull((Object)this.pIterater.getCurrent());
        this.pIterater.next();
        Assertions.assertEquals((Integer)1, (Integer)((Integer)this.pIterater.getCurrent()));
        this.pIterater.peek();
        Assertions.assertEquals((Integer)1, (Integer)((Integer)this.pIterater.getCurrent()));
        this.pIterater.next();
        Assertions.assertEquals((Integer)2, (Integer)((Integer)this.pIterater.getCurrent()));
        this.pIterater.peek();
        Assertions.assertEquals((Integer)2, (Integer)((Integer)this.pIterater.getCurrent()));
        this.pIterater.next();
        Assertions.assertEquals((Integer)3, (Integer)((Integer)this.pIterater.getCurrent()));
        this.pIterater.peek();
        Assertions.assertEquals((Integer)3, (Integer)((Integer)this.pIterater.getCurrent()));
        this.pIterater.next();
        Assertions.assertEquals((Integer)4, (Integer)((Integer)this.pIterater.getCurrent()));
    }
}

