/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.json.flattener;

import com.github.wnameless.json.base.GsonJsonCore;
import com.github.wnameless.json.base.JacksonJsonCore;
import com.github.wnameless.json.base.JsonCore;
import com.github.wnameless.json.base.JsonPrinter;
import com.github.wnameless.json.base.JsonValueBase;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.kubling.teiid.core.json.flattener.JsonFlattener;
import com.kubling.teiid.core.json.flattener.JsonFlattenerFactory;
import com.kubling.teiid.core.json.flattener.PrintMode;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JsonFlattenerFactoryTest {
    Consumer<JsonFlattener> configurer;
    JsonCore<?> jsonCore;
    JsonFlattenerFactory jsonFlattenerFactory;

    @BeforeEach
    public void setUp() {
        this.configurer = jf -> jf.withPrintMode(PrintMode.PRETTY);
        this.jsonCore = new GsonJsonCore();
        this.jsonFlattenerFactory = new JsonFlattenerFactory(this.configurer, this.jsonCore);
    }

    @Test
    public void testBuildWithJSONString() throws IOException {
        URL url = Resources.getResource((String)"test2.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        JsonFlattener jf = this.jsonFlattenerFactory.build(json);
        Assertions.assertEquals((Object)JsonPrinter.prettyPrint((String)"{\"a.b\":1,\"a.c\":null,\"a.d[0]\":false,\"a.d[1]\":true,\"e\":\"f\",\"g\":2.30}"), (Object)jf.flatten());
        this.jsonFlattenerFactory = new JsonFlattenerFactory(this.configurer);
        jf = this.jsonFlattenerFactory.build(json);
        Assertions.assertEquals((Object)JsonPrinter.prettyPrint((String)"{\"a.b\":1,\"a.c\":null,\"a.d[0]\":false,\"a.d[1]\":true,\"e\":\"f\",\"g\":2.3}"), (Object)jf.flatten());
    }

    @Test
    public void testBuildWithJsonValueBase() throws IOException {
        URL url = Resources.getResource((String)"test2.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        JsonFlattener jf = this.jsonFlattenerFactory.build((JsonValueBase)this.jsonCore.parse(json));
        Assertions.assertEquals((Object)JsonPrinter.prettyPrint((String)"{\"a.b\":1,\"a.c\":null,\"a.d[0]\":false,\"a.d[1]\":true,\"e\":\"f\",\"g\":2.30}"), (Object)jf.flatten());
        this.jsonFlattenerFactory = new JsonFlattenerFactory(this.configurer);
        jf = this.jsonFlattenerFactory.build((JsonValueBase)this.jsonCore.parse(json));
        Assertions.assertEquals((Object)JsonPrinter.prettyPrint((String)"{\"a.b\":1,\"a.c\":null,\"a.d[0]\":false,\"a.d[1]\":true,\"e\":\"f\",\"g\":2.30}"), (Object)jf.flatten());
    }

    @Test
    public void testBuildWithJsonReader() throws IOException {
        URL url = Resources.getResource((String)"test2.json");
        String json = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        JsonFlattener jf = this.jsonFlattenerFactory.build((Reader)new StringReader(json));
        Assertions.assertEquals((Object)JsonPrinter.prettyPrint((String)"{\"a.b\":1,\"a.c\":null,\"a.d[0]\":false,\"a.d[1]\":true,\"e\":\"f\",\"g\":2.30}"), (Object)jf.flatten());
        this.jsonFlattenerFactory = new JsonFlattenerFactory(this.configurer);
        jf = this.jsonFlattenerFactory.build((Reader)new StringReader(json));
        Assertions.assertEquals((Object)JsonPrinter.prettyPrint((String)"{\"a.b\":1,\"a.c\":null,\"a.d[0]\":false,\"a.d[1]\":true,\"e\":\"f\",\"g\":2.3}"), (Object)jf.flatten());
    }

    @Test
    public void testHashCode() {
        int result = 27;
        result = 31 * result + this.configurer.hashCode();
        result = 31 * result + this.jsonCore.hashCode();
        Assertions.assertEquals((int)result, (int)this.jsonFlattenerFactory.hashCode());
        this.configurer = jf -> jf.withPrintMode(PrintMode.PRETTY);
        this.jsonCore = new JacksonJsonCore();
        this.jsonFlattenerFactory = new JsonFlattenerFactory(this.configurer, this.jsonCore);
        Assertions.assertNotEquals((int)result, (int)this.jsonFlattenerFactory.hashCode());
    }

    @Test
    public void testEquals() {
        Assertions.assertEquals((Object)this.jsonFlattenerFactory, (Object)this.jsonFlattenerFactory);
        JsonFlattenerFactory otherJsonFlattenerFactory = new JsonFlattenerFactory(this.configurer, this.jsonCore);
        Assertions.assertEquals((Object)this.jsonFlattenerFactory, (Object)otherJsonFlattenerFactory);
        otherJsonFlattenerFactory = new JsonFlattenerFactory(this.configurer);
        Assertions.assertNotEquals((Object)this.jsonFlattenerFactory, (Object)otherJsonFlattenerFactory);
        this.jsonCore = new JacksonJsonCore();
        otherJsonFlattenerFactory = new JsonFlattenerFactory(this.configurer, this.jsonCore);
        Assertions.assertNotEquals((Object)this.jsonFlattenerFactory, (Object)otherJsonFlattenerFactory);
        this.configurer = jf -> jf.withPrintMode(PrintMode.MINIMAL);
        otherJsonFlattenerFactory = new JsonFlattenerFactory(this.configurer, this.jsonCore);
        Assertions.assertNotEquals((Object)this.jsonFlattenerFactory, (Object)otherJsonFlattenerFactory);
        Assertions.assertNotEquals((Object)this.jsonFlattenerFactory, null);
    }

    @Test
    public void testToString() {
        this.jsonFlattenerFactory = new JsonFlattenerFactory(this.configurer);
        Assertions.assertEquals((Object)("JsonFlattenerFactory{configurer=" + this.configurer.toString() + ", jsonCore=" + String.valueOf(Optional.empty()) + "}"), (Object)this.jsonFlattenerFactory.toString());
        this.jsonCore = new GsonJsonCore();
        this.jsonFlattenerFactory = new JsonFlattenerFactory(this.configurer, this.jsonCore);
        Assertions.assertEquals((Object)("JsonFlattenerFactory{configurer=" + this.configurer.toString() + ", jsonCore=" + String.valueOf(Optional.of(this.jsonCore)) + "}"), (Object)this.jsonFlattenerFactory.toString());
    }
}

