/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types;

import com.kubling.teiid.core.TeiidRuntimeException;
import com.kubling.teiid.core.types.BaseClobType;
import com.kubling.teiid.core.types.ClobImpl;
import com.kubling.teiid.core.types.ClobType;
import com.kubling.teiid.core.types.JsonType;
import com.kubling.teiid.core.util.UnitTestUtil;
import java.sql.Clob;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJsonType {
    @Test
    public void testJsonEquals() {
        String json1 = "{ \"a\": 1, \"b\": 2 }";
        String json2 = "{ \"b\": 2, \"a\": 1 }";
        JsonType jt1 = new JsonType((Clob)new ClobImpl(json1));
        JsonType jt2 = new JsonType((Clob)new ClobImpl(json2));
        Assertions.assertEquals((Object)jt1, (Object)jt2);
    }

    @Test
    public void testJsonCompare() throws Exception {
        String json1 = "{ \"a\": 1, \"b\": 2 }";
        String json2 = "{ \"b\": 2, \"a\": 1 }";
        JsonType jt1 = new JsonType((Clob)new ClobImpl(json1));
        JsonType jt2 = new JsonType((Clob)new ClobImpl(json2));
        Assertions.assertEquals((int)0, (int)jt1.compareTo((BaseClobType)jt2));
    }

    @Test
    public void testJsonHashCode() throws Exception {
        String json1 = "{ \"a\": 1, \"b\": 2 }";
        String json2 = "{ \"b\": 2, \"a\": 1 }";
        JsonType jt1 = new JsonType((Clob)new ClobImpl(json1));
        JsonType jt2 = new JsonType((Clob)new ClobImpl(json2));
        Assertions.assertEquals((int)jt1.hashCode(), (int)jt2.hashCode());
    }

    @Test
    public void testJsonTypeSerialization() throws Exception {
        String json = "{\"z\":9,\"a\":1}";
        JsonType jt = new JsonType((Clob)new ClobImpl(json));
        jt.setReferenceStreamId(null);
        JsonType read = UnitTestUtil.helpSerialize(jt);
        Assertions.assertEquals((long)json.length(), (long)read.length());
        Assertions.assertEquals((Object)json, (Object)read.getSubString(1L, json.length()));
        Assertions.assertEquals((Object)jt, (Object)read);
        Assertions.assertEquals((int)0, (int)jt.compareTo((BaseClobType)read));
        Assertions.assertEquals((int)jt.hashCode(), (int)read.hashCode());
    }

    @Test
    public void testInvalidJson() {
        JsonType jt = new JsonType((Clob)new ClobImpl("{ invalid json }"));
        Assertions.assertThrows(TeiidRuntimeException.class, () -> ((JsonType)jt).hashCode());
    }

    @Test
    public void testEqualsDifferentType() {
        JsonType jt = new JsonType((Clob)new ClobImpl("{\"a\": 1}"));
        Assertions.assertNotEquals((Object)new Object(), (Object)jt);
    }

    @Test
    public void testCompareWithNonJsonType() throws Exception {
        JsonType jt = new JsonType((Clob)new ClobImpl("{\"a\": 1}"));
        ClobType ct = new ClobType((Clob)new ClobImpl("other text"));
        Assertions.assertNotEquals((int)0, (int)jt.compareTo((BaseClobType)ct));
    }
}

