/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types.basic;

import com.kubling.teiid.core.BundleUtil;
import com.kubling.teiid.core.CorePlugin;
import com.kubling.teiid.core.types.ArrayImpl;
import com.kubling.teiid.core.types.ClobImpl;
import com.kubling.teiid.core.types.ClobType;
import com.kubling.teiid.core.types.DataTypeManager;
import com.kubling.teiid.core.types.SQLXMLImpl;
import com.kubling.teiid.core.types.TestDataTypeManager;
import com.kubling.teiid.core.types.Transform;
import com.kubling.teiid.core.types.TransformationException;
import com.kubling.teiid.core.types.XMLType;
import com.kubling.teiid.core.types.basic.StringToSQLXMLTransform;
import com.kubling.teiid.core.util.TimestampWithTimezone;
import com.kubling.teiid.query.unittest.TimestampUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTransforms {
    private static final Logger logger = Logger.getLogger(TestTransforms.class.getName());
    static Object[][] testData = new Object[][]{{"1", "0", "123"}, {Character.valueOf('1'), Character.valueOf('0'), Character.valueOf('1')}, {Boolean.TRUE, Boolean.FALSE, Boolean.FALSE}, {(byte)1, (byte)0, (byte)123}, {(short)1, (short)0, (short)123}, {1, 0, 123}, {1L, 0L, 123L}, {new BigInteger("1"), new BigInteger("0"), new BigInteger("123")}, {Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(123.0f)}, {1.0, 0.0, 123.0}, {new BigDecimal("1"), new BigDecimal("0"), new BigDecimal("123")}, {new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())}, {new Time(System.currentTimeMillis()), new Time(System.currentTimeMillis()), new Time(System.currentTimeMillis())}, {new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis())}, {null, null, null}, {null, null, null}, {new ClobType(ClobImpl.createClob((char[])"ClobData".toCharArray())), new ClobType(ClobImpl.createClob((char[])"0".toCharArray())), new ClobType(ClobImpl.createClob((char[])"123".toCharArray()))}, {new XMLType((SQLXML)new SQLXMLImpl("<foo>bar</foo>")), new XMLType((SQLXML)new SQLXMLImpl("<foo>bar</foo>")), new XMLType((SQLXML)new SQLXMLImpl("<foo>bar</foo>"))}};
    private final String[] dataTypes = TestDataTypeManager.dataTypes;
    private final char[][] conversions = TestDataTypeManager.conversions;

    private static void helpTestTransform(Object value, Object expectedValue) throws TransformationException {
        Transform transform = DataTypeManager.getTransform(value.getClass(), expectedValue.getClass());
        Object result = transform.transform(value, expectedValue.getClass());
        Assertions.assertEquals((Object)expectedValue, (Object)result);
    }

    private static void validateTransform(String src, Object value, String target, Object expectedValue) throws TransformationException {
        block2: {
            try {
                Transform transform = DataTypeManager.getTransform((Class)DataTypeManager.getDataTypeClass((String)src), expectedValue.getClass());
                Object result = transform.transform(value, expectedValue.getClass());
                logger.fine(String.format("Value: %s | Source: %s | Target: %s", result, DataTypeManager.getDataTypeName(value.getClass()), target));
                Assertions.assertTrue((boolean)expectedValue.getClass().isAssignableFrom(result.getClass()));
                Assertions.assertFalse((boolean)TestTransforms.isException(DataTypeManager.getDataTypeName(value.getClass()), target, value));
            }
            catch (TransformationException e) {
                if (TestTransforms.isException(DataTypeManager.getDataTypeName(value.getClass()), target, value)) break block2;
                throw e;
            }
        }
    }

    private static void helpTransformException(Object value, Class<?> target, String msg) {
        block2: {
            try {
                Transform transform = DataTypeManager.getTransform(value.getClass(), target);
                transform.transform(value, target);
                Assertions.fail((String)"Expected to get an exception during the transformation");
            }
            catch (TransformationException e) {
                if (msg == null) break block2;
                Assertions.assertEquals((Object)msg, (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testBigDecimalToBigInteger_Defect16875() throws TransformationException {
        TestTransforms.helpTestTransform(new BigDecimal("0.5867"), new BigInteger("0"));
    }

    @Test
    public void testString2Boolean() throws TransformationException {
        TestTransforms.helpTestTransform(new String("1"), Boolean.TRUE);
        TestTransforms.helpTestTransform(new String("0"), Boolean.FALSE);
        TestTransforms.helpTestTransform(new String("true"), Boolean.TRUE);
        TestTransforms.helpTestTransform(new String("false"), Boolean.FALSE);
        TestTransforms.helpTestTransform(new String("foo"), Boolean.TRUE);
    }

    @Test
    public void testByte2Boolean() throws TransformationException {
        TestTransforms.helpTestTransform((byte)1, Boolean.TRUE);
        TestTransforms.helpTestTransform((byte)0, Boolean.FALSE);
        TestTransforms.helpTestTransform((byte)12, Boolean.TRUE);
    }

    @Test
    public void testShort2Boolean() throws TransformationException {
        TestTransforms.helpTestTransform((short)1, Boolean.TRUE);
        TestTransforms.helpTestTransform((short)0, Boolean.FALSE);
        TestTransforms.helpTestTransform((short)12, Boolean.TRUE);
    }

    @Test
    public void testInteger2Boolean() throws TransformationException {
        TestTransforms.helpTestTransform(1, Boolean.TRUE);
        TestTransforms.helpTestTransform(0, Boolean.FALSE);
        TestTransforms.helpTestTransform(12, Boolean.TRUE);
    }

    @Test
    public void testLong2Boolean() throws TransformationException {
        TestTransforms.helpTestTransform(1L, Boolean.TRUE);
        TestTransforms.helpTestTransform(0L, Boolean.FALSE);
        TestTransforms.helpTestTransform(12L, Boolean.TRUE);
    }

    @Test
    public void testBigInteger2Boolean() throws TransformationException {
        TestTransforms.helpTestTransform(new BigInteger("1"), Boolean.TRUE);
        TestTransforms.helpTestTransform(new BigInteger("0"), Boolean.FALSE);
        TestTransforms.helpTestTransform(new BigInteger("12"), Boolean.TRUE);
    }

    @Test
    public void testBigDecimal2Boolean() throws TransformationException {
        TestTransforms.helpTestTransform(new BigDecimal("1"), Boolean.TRUE);
        TestTransforms.helpTestTransform(new BigDecimal("0"), Boolean.FALSE);
        TestTransforms.helpTestTransform(new BigDecimal("0.00"), Boolean.FALSE);
    }

    private static boolean isException(String src, String tgt, Object source) {
        return src.equals("string") && tgt.equals("xml") || src.equals("clob") && tgt.equals("xml");
    }

    @Test
    public void testAllConversions() throws TransformationException {
        for (int src = 0; src < this.dataTypes.length; ++src) {
            for (int tgt = 0; tgt < this.dataTypes.length; ++tgt) {
                char c = this.conversions[src][tgt];
                if (c != 'I' && c != 'C') continue;
                Object[] srcdata = testData[src];
                Object[] tgtdata = testData[tgt];
                for (int i = 0; i < tgtdata.length; ++i) {
                    if (tgtdata[i] == null || srcdata[i] == null) continue;
                    TestTransforms.validateTransform(this.dataTypes[src], srcdata[i], this.dataTypes[tgt], tgtdata[i]);
                }
            }
        }
    }

    @Test
    public void testAllConversionsAsObject() throws TransformationException {
        for (int src = 0; src < this.dataTypes.length; ++src) {
            for (int tgt = 0; tgt < this.dataTypes.length; ++tgt) {
                char c = this.conversions[src][tgt];
                if (c != 'I' && c != 'C') continue;
                Object[] srcdata = testData[src];
                Object[] tgtdata = testData[tgt];
                for (int i = 0; i < tgtdata.length; ++i) {
                    if (tgtdata[i] == null || srcdata[i] == null) continue;
                    TestTransforms.validateTransform("object", srcdata[i], this.dataTypes[tgt], tgtdata[i]);
                }
            }
        }
    }

    @Test
    public void testInvalidTimeInputFails() {
        Transform transform = DataTypeManager.getTransform((Class)DataTypeManager.DefaultDataClasses.OBJECT, (Class)DataTypeManager.DefaultDataClasses.TIME);
        Assertions.assertThrows(TransformationException.class, () -> transform.transform((Object)"not-a-time", DataTypeManager.DefaultDataClasses.TIME));
    }

    @Test
    public void testSQLXMLToStringTransform() throws Exception {
        StringBuilder xml = new StringBuilder();
        int iters = DataTypeManager.MAX_STRING_LENGTH / 10;
        for (int i = 0; i < iters; ++i) {
            if (i < iters / 2) {
                xml.append("<opentag>1");
                continue;
            }
            xml.append("</opentag>");
        }
        Object expected = "";
        expected = (String)expected + xml.substring(0, DataTypeManager.MAX_STRING_LENGTH);
        TestTransforms.helpTestTransform(new StringToSQLXMLTransform().transformDirect((Object)xml.toString()), expected);
    }

    @Test
    public void testStringToTimestampOutOfRange() {
        TestTransforms.helpTransformException("2005-13-01 11:13:01", DataTypeManager.DefaultDataClasses.TIMESTAMP, null);
    }

    @Test
    public void testStringToTimeTimestampWithWS() throws Exception {
        TestTransforms.helpTestTransform(" 2005-12-01 11:13:01 ", TimestampUtil.createTimestamp(105, 11, 1, 11, 13, 1, 0));
    }

    @Test
    public void testStringToTimestampFails() {
        TestTransforms.helpTransformException("2005-12-01 11:88:60", Timestamp.class, "TEIID10060 The string representation '2005-12-01 11:88:60' of a Timestamp value is not valid.");
    }

    @Test
    public void testStringToTimestampDSTTransition() throws Exception {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("America/New_York"));
        try {
            TestTransforms.helpTestTransform("2016-03-13 02:00:00", TimestampUtil.createTimestamp(116, 2, 13, 3, 0, 0, 0));
        }
        finally {
            TimestampWithTimezone.resetCalendar(null);
        }
    }

    @Test
    public void testStringToLongWithWS() throws Exception {
        TestTransforms.helpTestTransform(" 1 ", 1L);
    }

    @Test
    public void testEngineeringNotationFloatToBigInteger() throws Exception {
        TestTransforms.helpTestTransform(Float.valueOf(Float.MIN_VALUE), new BigDecimal(1.4E-45f).toBigInteger());
    }

    @Test
    public void testRangeCheck() {
        TestTransforms.helpTransformException(300, DataTypeManager.DefaultDataClasses.BYTE, "TEIID10058 The Integer value '300' is outside the of range for Byte");
    }

    @Test
    public void testRangeCheck1() {
        Double value = Double.valueOf("1E11");
        TestTransforms.helpTransformException(value, DataTypeManager.DefaultDataClasses.INTEGER, CorePlugin.Util.gs((BundleUtil.Event)CorePlugin.Event.TEIID10058, new Object[]{value, Double.class.getSimpleName(), Integer.class.getSimpleName()}));
    }

    @Test
    public void testPrimitiveArrayConversion() throws Exception {
        Object val = DataTypeManager.transformValue((Object)new long[]{1L}, (Class)DataTypeManager.DefaultDataClasses.OBJECT, Long[].class);
        Assertions.assertEquals((Object)new ArrayImpl((Object[])new Long[]{1L}), (Object)val);
    }
}

