/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.util;

import com.kubling.teiid.core.CorePlugin;
import com.kubling.teiid.core.util.Assertion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAssertion {
    private static final String TEST_MESSAGE = "This is a test assertion message";

    @Test
    public void testAssertTrueboolean() {
        Assertion.assertTrue((boolean)true);
        try {
            Assertion.assertTrue((boolean)false);
            Assertions.fail();
        }
        catch (AssertionError e) {
            String msg = CorePlugin.Util.getString("Assertion.Assertion_failed");
            Assertions.assertEquals((Object)msg, (Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    public void testAssertTruebooleanString() {
        Assertion.assertTrue((boolean)true, (String)TEST_MESSAGE);
        try {
            Assertion.assertTrue((boolean)false, (String)TEST_MESSAGE);
            Assertions.fail();
        }
        catch (AssertionError e) {
            Assertions.assertEquals((Object)TEST_MESSAGE, (Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    public void testFailed() {
        try {
            Assertion.failed(null);
            Assertions.fail();
        }
        catch (AssertionError e) {
            Assertions.assertEquals((Object)"null", (Object)((Throwable)((Object)e)).getMessage());
        }
        try {
            Assertion.failed((String)TEST_MESSAGE);
            Assertions.fail();
        }
        catch (AssertionError e) {
            Assertions.assertEquals((Object)TEST_MESSAGE, (Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    public void testIsNullObject() {
        Assertion.isNull(null);
        try {
            Assertion.isNull((Object)"");
            Assertions.fail();
        }
        catch (AssertionError e) {
            String msg = CorePlugin.Util.getString("Assertion.isNull");
            Assertions.assertEquals((Object)msg, (Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    public void testIsNullObjectString() {
        Assertion.isNull(null, (String)TEST_MESSAGE);
        try {
            Assertion.isNull((Object)"", (String)TEST_MESSAGE);
            Assertions.fail();
        }
        catch (AssertionError e) {
            Assertions.assertEquals((Object)TEST_MESSAGE, (Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    public void testIsNotNullObject() {
        Assertion.isNotNull((Object)"");
        try {
            Assertion.isNotNull(null);
            Assertions.fail();
        }
        catch (AssertionError e) {
            String msg = CorePlugin.Util.getString("Assertion.isNotNull");
            Assertions.assertEquals((Object)msg, (Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    public void testIsNotNullObjectString() {
        Assertion.isNotNull((Object)"", (String)TEST_MESSAGE);
        try {
            Assertion.isNotNull(null, (String)TEST_MESSAGE);
            Assertions.fail();
        }
        catch (AssertionError e) {
            Assertions.assertEquals((Object)TEST_MESSAGE, (Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    public void testIsInstanceOf() {
        Assertion.isInstanceOf((Object)1, Integer.class, (String)"name");
        Assertion.isInstanceOf((Object)"asdfasdf", String.class, (String)"name2");
        try {
            Assertion.isInstanceOf((Object)1, Long.class, (String)"name3");
            Assertions.fail();
        }
        catch (ClassCastException e) {
            Object[] params = new Object[]{"name3", Long.class, Integer.class.getName()};
            String msg = CorePlugin.Util.getString("Assertion.invalidClassMessage", params);
            Assertions.assertEquals((Object)msg, (Object)e.getMessage());
        }
    }

    @Test
    public void testIsNotEmptyCollection() {
    }

    @Test
    public void testIsNotEmptyCollectionString() {
    }

    @Test
    public void testIsNotEmptyMap() {
    }

    @Test
    public void testIsNotEmptyMapString() {
    }

    @Test
    public void testContainsCollectionObject() {
    }

    @Test
    public void testContainsCollectionObjectString() {
    }

    @Test
    public void testContainsKeyMapObject() {
    }

    @Test
    public void testContainsKeyMapObjectString() {
    }
}

