/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.util;

import com.kubling.teiid.core.util.ObjectConverterUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestObjectConverterUtil {
    @Test
    public void testWriteWithLength() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});
        ObjectConverterUtil.write((OutputStream)baos, (InputStream)bais, (byte[])new byte[3], (int)4);
        Assertions.assertEquals((int)4, (int)baos.toByteArray().length);
        StringWriter sw = new StringWriter();
        StringReader sr = new StringReader("123");
        ObjectConverterUtil.write((Writer)sw, (Reader)sr, (int)2, (boolean)true);
        Assertions.assertEquals((int)2, (int)sw.toString().length());
    }

    @Test
    public void testCloseArguments() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this){

            @Override
            public void close() {
                throw new AssertionError();
            }
        };
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});
        ObjectConverterUtil.write((OutputStream)baos, (InputStream)bais, (byte[])new byte[3], (int)4, (boolean)false, (boolean)true);
        Assertions.assertEquals((int)4, (int)baos.toByteArray().length);
    }
}

