/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.json.flattener;

import com.github.wnameless.json.base.JsonPrinter;
import com.kubling.teiid.core.json.flattener.JsonifyArrayList;
import com.kubling.teiid.core.json.flattener.PrintMode;
import com.kubling.teiid.core.json.flattener.StringEscapePolicy;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.text.translate.CharSequenceTranslator;

public class JsonifyLinkedHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private CharSequenceTranslator translator = StringEscapePolicy.DEFAULT.getCharSequenceTranslator();

    public JsonifyLinkedHashMap() {
    }

    public JsonifyLinkedHashMap(Map<K, V> map) {
        super(map);
    }

    public void setTranslator(CharSequenceTranslator translator) {
        this.translator = translator;
    }

    public String toString(PrintMode printMode) {
        if (Objects.requireNonNull(printMode) == PrintMode.PRETTY) {
            return JsonPrinter.prettyPrint((String)this.toString());
        }
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry mem : this.entrySet()) {
            sb.append('\"');
            sb.append(this.translator.translate((CharSequence)((String)mem.getKey())));
            sb.append('\"');
            sb.append(':');
            if (mem.getValue() instanceof String) {
                sb.append('\"');
                sb.append(this.translator.translate((CharSequence)((String)mem.getValue())));
                sb.append('\"');
            } else if (mem.getValue() instanceof Collection) {
                sb.append(new JsonifyArrayList((Collection)mem.getValue()));
            } else if (mem.getValue() instanceof Map) {
                sb.append(new JsonifyLinkedHashMap<K, V>((Map)mem.getValue()));
            } else {
                sb.append(mem.getValue());
            }
            sb.append(',');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append('}');
        return sb.toString();
    }
}

