/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types;

import com.kubling.teiid.core.types.InputStreamFactory;
import com.kubling.teiid.core.types.Streamable;
import com.kubling.teiid.core.util.InputStreamReader;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.SQLException;

public class BaseLob
implements Externalizable,
InputStreamFactory.StreamFactoryReference {
    private static final long serialVersionUID = -1586959324208959519L;
    private InputStreamFactory streamFactory;
    private Charset charset;

    public BaseLob() {
    }

    protected BaseLob(InputStreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    @Override
    public void setStreamFactory(InputStreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    public InputStreamFactory getStreamFactory() throws SQLException {
        if (this.streamFactory == null) {
            throw new SQLException("Already freed");
        }
        return this.streamFactory;
    }

    public void setEncoding(String encoding) {
        this.charset = encoding != null ? Charset.forName(encoding) : null;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void free() {
        this.streamFactory = null;
    }

    public Reader getCharacterStream() throws SQLException {
        try {
            Reader r = this.getStreamFactory().getCharacterStream();
            if (r != null) {
                return r;
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage(), e);
        }
        Charset cs = this.getCharset();
        if (cs == null) {
            cs = Streamable.CHARSET;
        }
        return new InputStreamReader(this.getBinaryStream(), cs.newDecoder());
    }

    public InputStream getBinaryStream() throws SQLException {
        try {
            return this.getStreamFactory().getInputStream();
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.streamFactory = (InputStreamFactory)in.readObject();
        try {
            this.charset = (Charset)in.readObject();
        }
        catch (EOFException | OptionalDataException iOException) {
            // empty catch block
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.streamFactory);
        out.writeObject(this.charset);
    }

    public long length() throws SQLException {
        if (this.getStreamFactory().getLength() == -1L) {
            this.getStreamFactory().setLength(BaseLob.length(this.getBinaryStream()));
        }
        return this.getStreamFactory().getLength();
    }

    static long length(InputStream is) throws SQLException {
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        try {
            long length = 0L;
            while (is.read() != -1) {
                ++length;
            }
            long l = length;
            return l;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }
}

