/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types;

import com.kubling.teiid.core.CorePlugin;
import com.kubling.teiid.core.types.BaseLob;
import com.kubling.teiid.core.types.InputStreamFactory;
import com.kubling.teiid.core.types.LobSearchUtil;
import com.kubling.teiid.core.types.Streamable;
import com.kubling.teiid.core.util.ObjectConverterUtil;
import com.kubling.teiid.core.util.ReaderInputStream;
import com.kubling.teiid.core.util.SqlUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobImpl
extends BaseLob
implements Clob {
    private long len = -1L;

    public ClobImpl() {
    }

    public ClobImpl(InputStreamFactory streamFactory, long length) {
        super(streamFactory);
        this.len = length;
    }

    public ClobImpl(char[] chars) {
        this(new StringInputStreamFactory(new String(chars)), chars.length);
    }

    public ClobImpl(String str) {
        this(new StringInputStreamFactory(str), str.length());
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return new ReaderInputStream(this.getCharacterStream(), StandardCharsets.US_ASCII);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubString(long pos, int length) throws SQLException {
        String string;
        if (pos < 1L) {
            throw new SQLException(CorePlugin.Util.getString("MMClob_MMBlob.2", pos));
        }
        if (pos > this.length()) {
            return null;
        }
        --pos;
        if (length < 0) {
            throw new SQLException(CorePlugin.Util.getString("MMClob_MMBlob.1", length));
        }
        if (pos + (long)length > this.length()) {
            length = (int)(this.length() - pos);
        }
        Reader in = this.getCharacterStream();
        try {
            while (pos > 0L) {
                long skipped = in.skip(pos);
                pos -= skipped;
            }
            string = ObjectConverterUtil.convertToString(in, length);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        in.close();
        return string;
    }

    @Override
    public long length() throws SQLException {
        if (this.len == -1L) {
            long length = 0L;
            BufferedReader r = new BufferedReader(this.getCharacterStream());
            try {
                while (((Reader)r).read() != -1) {
                    ++length;
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            finally {
                try {
                    ((Reader)r).close();
                }
                catch (IOException iOException) {}
            }
            this.len = length;
        }
        return this.len;
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        if (searchstr == null) {
            return -1L;
        }
        return LobSearchUtil.position(new ClobStreamProvider(searchstr), searchstr.length(), new ClobStreamProvider(this), this.length(), start, 2);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        if (searchstr == null) {
            return -1L;
        }
        return this.position(new ClobImpl(searchstr), start);
    }

    @Override
    public Reader getCharacterStream(long arg0, long arg1) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public OutputStream setAsciiStream(long arg0) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Writer setCharacterStream(long arg0) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public int setString(long arg0, String arg1) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public int setString(long arg0, String arg1, int arg2, int arg3) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void truncate(long arg0) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    public static Clob createClob(char[] chars) {
        return new ClobImpl(chars);
    }

    public String toString() {
        try {
            if (this.len == 0L) {
                return null;
            }
            InputStream in = this.getAsciiStream();
            byte[] data = in.readAllBytes();
            if (data.length == 0) {
                throw new IOException("Ascii stream returned zero bytes; possibly reused, closed, or pointing to invalid storage");
            }
            return new String(data, StandardCharsets.US_ASCII);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException("Failed to read Clob content", e);
        }
    }

    private static final class StringInputStreamFactory
    extends InputStreamFactory {
        String str;

        private StringInputStreamFactory(String str) {
            this.str = str;
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.str.getBytes(Streamable.CHARSET));
        }

        @Override
        public Reader getCharacterStream() {
            return new StringReader(this.str);
        }

        @Override
        public InputStreamFactory.StorageMode getStorageMode() {
            return InputStreamFactory.StorageMode.MEMORY;
        }
    }

    static final class ClobStreamProvider
    implements LobSearchUtil.StreamProvider {
        private final Clob searchstr;

        private ClobStreamProvider(Clob searchstr) {
            this.searchstr = searchstr;
        }

        @Override
        public InputStream getBinaryStream() throws SQLException {
            final Reader reader = this.searchstr.getCharacterStream();
            return new InputStream(this){
                int currentChar = -1;

                @Override
                public int read() throws IOException {
                    if (this.currentChar == -1) {
                        this.currentChar = reader.read();
                        if (this.currentChar == -1) {
                            return -1;
                        }
                        return this.currentChar & 0xFF;
                    }
                    int result = this.currentChar & 0xFF00;
                    this.currentChar = -1;
                    return result;
                }
            };
        }
    }
}

