/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.kubling.teiid.core.BundleUtil;
import com.kubling.teiid.core.CorePlugin;
import com.kubling.teiid.core.TeiidRuntimeException;
import com.kubling.teiid.core.types.BaseClobType;
import com.kubling.teiid.core.types.ClobType;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Objects;

public final class JsonType
extends BaseClobType
implements Comparable<BaseClobType> {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    private JsonNode jsonNode;
    private static final long serialVersionUID = 2753412502127824104L;

    public JsonType() {
    }

    public JsonType(Clob clob) {
        super(clob);
    }

    @Override
    public int compareTo(BaseClobType o) {
        if (!(o instanceof JsonType)) {
            return super.compareTo(o);
        }
        return this.normalizedJsonString().compareTo(((JsonType)o).normalizedJsonString());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JsonType) {
            JsonType jsonType = (JsonType)obj;
            return Objects.equals(this.getParsedNode(), jsonType.getParsedNode());
        }
        if (obj instanceof ClobType) {
            ClobType clobType = (ClobType)obj;
            return Objects.equals(this.getParsedNode(), new JsonType(clobType).getParsedNode());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.normalizedJsonString().hashCode();
    }

    @Override
    public String toString() {
        return this.normalizedJsonString();
    }

    private JsonNode getParsedNode() {
        JsonNode jsonNode;
        block9: {
            if (this.jsonNode != null) {
                return this.jsonNode;
            }
            Reader r = this.getCharacterStream();
            try {
                jsonNode = this.jsonNode = MAPPER.readTree(r);
                if (r == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SQLException e) {
                    throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10085, (Throwable)e);
                }
            }
            r.close();
        }
        return jsonNode;
    }

    private String normalizedJsonString() {
        try {
            return MAPPER.writeValueAsString(MAPPER.treeToValue((TreeNode)this.getParsedNode(), Object.class));
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10085, (Throwable)e);
        }
    }
}

