/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types.basic;

import com.kubling.teiid.core.CorePlugin;
import com.kubling.teiid.core.types.BaseClobType;
import com.kubling.teiid.core.types.ClobImpl;
import com.kubling.teiid.core.types.DataTypeManager;
import com.kubling.teiid.core.types.JsonType;
import com.kubling.teiid.core.types.Transform;
import com.kubling.teiid.core.types.TransformationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.sql.SQLException;

public class ClobToJsonTransform
extends Transform {
    @Override
    protected Object transformDirect(Object value) throws TransformationException {
        JsonType jsonType;
        BaseClobType source = (BaseClobType)value;
        BufferedReader reader = new BufferedReader(source.getCharacterStream());
        try {
            StringBuilder contents = new StringBuilder();
            int chr = reader.read();
            while (chr != -1 && (long)contents.length() < DataTypeManager.MAX_JSON_LENGTH) {
                contents.append((char)chr);
                chr = reader.read();
            }
            jsonType = new JsonType(new ClobImpl(contents.toString()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SQLException e) {
                throw new TransformationException(CorePlugin.Event.TEIID10080, e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10080, this.getSourceType().getName(), this.getTargetType().getName()));
            }
        }
        reader.close();
        return jsonType;
    }

    @Override
    public Class<?> getSourceType() {
        return DataTypeManager.DefaultDataClasses.CLOB;
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.JSON;
    }
}

