/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types.basic;

import com.kubling.teiid.core.CorePlugin;
import com.kubling.teiid.core.types.BaseClobType;
import com.kubling.teiid.core.types.DataTypeManager;
import com.kubling.teiid.core.types.TransformationException;
import com.kubling.teiid.core.types.basic.AnyToStringTransform;
import java.io.BufferedReader;
import java.io.IOException;
import java.sql.SQLException;

public class ClobToStringTransform
extends AnyToStringTransform {
    public ClobToStringTransform() {
        super(DataTypeManager.DefaultDataClasses.CLOB);
    }

    public ClobToStringTransform(Class<? extends BaseClobType> fromType) {
        super(fromType);
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        BaseClobType source = (BaseClobType)value;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(source.getCharacterStream());
            StringBuilder contents = new StringBuilder();
            int chr = reader.read();
            while (chr != -1 && contents.length() < DataTypeManager.MAX_STRING_LENGTH) {
                contents.append((char)chr);
                chr = reader.read();
            }
            String string = contents.toString();
            return string;
        }
        catch (IOException | SQLException e) {
            throw new TransformationException(CorePlugin.Event.TEIID10080, e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10080, this.getSourceType().getName(), this.getTargetType().getName()));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

