/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types.basic;

import com.kubling.teiid.core.types.DataTypeManager;
import com.kubling.teiid.core.types.TransformationException;
import com.kubling.teiid.core.types.basic.NumberToNumberTransform;

public class NumberToFloatTransform
extends NumberToNumberTransform {
    private final boolean isNarrowing;
    private final boolean isLossy;

    public NumberToFloatTransform(Class<?> sourceType, boolean isNarrowing, boolean isLossy) {
        super(Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE), sourceType);
        this.isNarrowing = isNarrowing;
        this.isLossy = isLossy;
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        if (this.isNarrowing) {
            this.checkValueRange(value);
        }
        return Float.valueOf(((Number)value).floatValue());
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.FLOAT;
    }

    @Override
    public boolean isExplicit() {
        return this.isNarrowing || this.isLossy;
    }
}

