/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExternalizeUtil {
    private ExternalizeUtil() {
    }

    public static void writeArray(ObjectOutput out, Object[] array) throws IOException {
        if (array == null) {
            out.writeInt(0);
        } else {
            int length = array.length;
            out.writeInt(length);
            for (Object o : array) {
                out.writeObject(o);
            }
        }
    }

    public static void writeCollection(ObjectOutput out, Collection<?> coll) throws IOException {
        if (coll == null) {
            out.writeInt(0);
        } else {
            int size = coll.size();
            out.writeInt(size);
            if (size > 0) {
                for (Object object : coll) {
                    out.writeObject(object);
                }
            }
        }
    }

    public static void writeList(ObjectOutput out, List<?> coll) throws IOException {
        ExternalizeUtil.writeCollection(out, coll);
    }

    public static void writeMap(ObjectOutput out, Map<?, ?> map) throws IOException {
        if (map == null) {
            out.writeInt(0);
        } else {
            out.writeInt(map.size());
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }
    }

    public static <T> T[] readArray(ObjectInput in, Class<T> type) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        Object[] result = (Object[])Array.newInstance(type, length);
        for (int i = 0; i < length; ++i) {
            result[i] = type.cast(in.readObject());
        }
        return result;
    }

    public static String[] readStringArray(ObjectInput in) throws IOException, ClassNotFoundException {
        return ExternalizeUtil.readArray(in, String.class);
    }

    public static <T> List<T> readList(ObjectInput in, Class<T> type) throws IOException, ClassNotFoundException {
        return Arrays.asList(ExternalizeUtil.readArray(in, type));
    }

    public static List<?> readList(ObjectInput in) throws IOException, ClassNotFoundException {
        return ExternalizeUtil.readList(in, Object.class);
    }

    public static <K, V> Map<K, V> readMap(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        HashMap<Object, Object> map = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            map.put(in.readObject(), in.readObject());
        }
        return map;
    }

    public static void writeEnum(ObjectOutput out, Enum<?> value) throws IOException {
        if (value == null) {
            out.writeObject(null);
        } else {
            out.writeUTF(value.name());
        }
    }

    public static <T extends Enum<T>> T readEnum(ObjectInput in, Class<T> clazz, T defaultVal) throws IOException {
        String name = in.readUTF();
        if (name == null) {
            return null;
        }
        try {
            return Enum.valueOf(clazz, name);
        }
        catch (IllegalArgumentException e) {
            return defaultVal;
        }
    }
}

