/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.hibernate.dialect;

import com.kubling.hibernate.dialect.KublingTemporaryTableExporter;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.pagination.AbstractSimpleLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTableExporter;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.type.StandardBasicTypes;

public class KublingDialect
extends Dialect {
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        SqmFunctionRegistry functionRegistry = functionContributions.getFunctionRegistry();
        functionRegistry.register("acos", (SqmFunctionDescriptor)new StandardSQLFunction("acos", StandardBasicTypes.DOUBLE));
        functionRegistry.register("asin", (SqmFunctionDescriptor)new StandardSQLFunction("asin", StandardBasicTypes.DOUBLE));
        functionRegistry.register("atan", (SqmFunctionDescriptor)new StandardSQLFunction("atan", StandardBasicTypes.DOUBLE));
        functionRegistry.register("atan2", (SqmFunctionDescriptor)new StandardSQLFunction("atan2", StandardBasicTypes.DOUBLE));
        functionRegistry.register("ceil", (SqmFunctionDescriptor)new StandardSQLFunction("ceiling"));
        functionRegistry.register("cos", (SqmFunctionDescriptor)new StandardSQLFunction("cos", StandardBasicTypes.DOUBLE));
        functionRegistry.register("cot", (SqmFunctionDescriptor)new StandardSQLFunction("cot", StandardBasicTypes.DOUBLE));
        functionRegistry.register("degrees", (SqmFunctionDescriptor)new StandardSQLFunction("degrees", StandardBasicTypes.DOUBLE));
        functionRegistry.register("exp", (SqmFunctionDescriptor)new StandardSQLFunction("exp", StandardBasicTypes.DOUBLE));
        functionRegistry.register("floor", (SqmFunctionDescriptor)new StandardSQLFunction("floor"));
        functionRegistry.register("log", (SqmFunctionDescriptor)new StandardSQLFunction("log", StandardBasicTypes.DOUBLE));
        functionRegistry.register("mod", (SqmFunctionDescriptor)new StandardSQLFunction("mod"));
        functionRegistry.register("pi", (SqmFunctionDescriptor)new StandardSQLFunction("pi", StandardBasicTypes.DOUBLE));
        functionRegistry.register("power", (SqmFunctionDescriptor)new StandardSQLFunction("power", StandardBasicTypes.DOUBLE));
        functionRegistry.register("radians", (SqmFunctionDescriptor)new StandardSQLFunction("radians", StandardBasicTypes.DOUBLE));
        functionRegistry.register("round", (SqmFunctionDescriptor)new StandardSQLFunction("round"));
        functionRegistry.register("sign", (SqmFunctionDescriptor)new StandardSQLFunction("sign", StandardBasicTypes.INTEGER));
        functionRegistry.register("sin", (SqmFunctionDescriptor)new StandardSQLFunction("sin", StandardBasicTypes.DOUBLE));
        functionRegistry.register("tan", (SqmFunctionDescriptor)new StandardSQLFunction("tan", StandardBasicTypes.DOUBLE));
        functionRegistry.register("ascii", (SqmFunctionDescriptor)new StandardSQLFunction("ascii", StandardBasicTypes.INTEGER));
        functionRegistry.register("chr", (SqmFunctionDescriptor)new StandardSQLFunction("chr", StandardBasicTypes.CHARACTER));
        functionRegistry.register("char", (SqmFunctionDescriptor)new StandardSQLFunction("char", StandardBasicTypes.CHARACTER));
        functionRegistry.register("initcap", (SqmFunctionDescriptor)new StandardSQLFunction("initcap", StandardBasicTypes.STRING));
        functionRegistry.register("insert", (SqmFunctionDescriptor)new StandardSQLFunction("insert", StandardBasicTypes.STRING));
        functionRegistry.register("lcase", (SqmFunctionDescriptor)new StandardSQLFunction("lcase", StandardBasicTypes.STRING));
        functionRegistry.register("left", (SqmFunctionDescriptor)new StandardSQLFunction("left", StandardBasicTypes.STRING));
        functionRegistry.register("locate", (SqmFunctionDescriptor)new StandardSQLFunction("locate", StandardBasicTypes.INTEGER));
        functionRegistry.register("lpad", (SqmFunctionDescriptor)new StandardSQLFunction("lpad", StandardBasicTypes.STRING));
        functionRegistry.register("ltrim", (SqmFunctionDescriptor)new StandardSQLFunction("ltrim", StandardBasicTypes.STRING));
        functionRegistry.register("repeat", (SqmFunctionDescriptor)new StandardSQLFunction("repeat", StandardBasicTypes.STRING));
        functionRegistry.register("replace", (SqmFunctionDescriptor)new StandardSQLFunction("replace", StandardBasicTypes.STRING));
        functionRegistry.register("right", (SqmFunctionDescriptor)new StandardSQLFunction("right", StandardBasicTypes.STRING));
        functionRegistry.register("rpad", (SqmFunctionDescriptor)new StandardSQLFunction("rpad", StandardBasicTypes.STRING));
        functionRegistry.register("rtrim", (SqmFunctionDescriptor)new StandardSQLFunction("rtrim", StandardBasicTypes.STRING));
        functionRegistry.register("substring", (SqmFunctionDescriptor)new StandardSQLFunction("substring", StandardBasicTypes.STRING));
        functionRegistry.register("translate", (SqmFunctionDescriptor)new StandardSQLFunction("translate", StandardBasicTypes.STRING));
        functionRegistry.register("ucase", (SqmFunctionDescriptor)new StandardSQLFunction("ucase", StandardBasicTypes.STRING));
        functionRegistry.register("dayname", (SqmFunctionDescriptor)new StandardSQLFunction("dayname", StandardBasicTypes.STRING));
        functionRegistry.register("dayofmonth", (SqmFunctionDescriptor)new StandardSQLFunction("dayofmonth", StandardBasicTypes.INTEGER));
        functionRegistry.register("dayofweek", (SqmFunctionDescriptor)new StandardSQLFunction("dayofweek", StandardBasicTypes.INTEGER));
        functionRegistry.register("dayofyear", (SqmFunctionDescriptor)new StandardSQLFunction("dayofyear", StandardBasicTypes.INTEGER));
        functionRegistry.register("hour", (SqmFunctionDescriptor)new StandardSQLFunction("hour", StandardBasicTypes.INTEGER));
        functionRegistry.register("minute", (SqmFunctionDescriptor)new StandardSQLFunction("minute", StandardBasicTypes.INTEGER));
        functionRegistry.register("second", (SqmFunctionDescriptor)new StandardSQLFunction("second", StandardBasicTypes.INTEGER));
        functionRegistry.register("week", (SqmFunctionDescriptor)new StandardSQLFunction("week", StandardBasicTypes.INTEGER));
        functionRegistry.register("year", (SqmFunctionDescriptor)new StandardSQLFunction("year", StandardBasicTypes.INTEGER));
        functionRegistry.register("formatbigdecimal", (SqmFunctionDescriptor)new StandardSQLFunction("formatbigdecimal", StandardBasicTypes.STRING));
        functionRegistry.register("formatbiginteger", (SqmFunctionDescriptor)new StandardSQLFunction("formatbiginteger", StandardBasicTypes.STRING));
        functionRegistry.register("formatdouble", (SqmFunctionDescriptor)new StandardSQLFunction("formatdouble", StandardBasicTypes.STRING));
        functionRegistry.register("formatfloat", (SqmFunctionDescriptor)new StandardSQLFunction("formatfloat", StandardBasicTypes.STRING));
        functionRegistry.register("formatinteger", (SqmFunctionDescriptor)new StandardSQLFunction("formatinteger", StandardBasicTypes.STRING));
        functionRegistry.register("formatlong", (SqmFunctionDescriptor)new StandardSQLFunction("formatlong", StandardBasicTypes.STRING));
        functionRegistry.register("convert", (SqmFunctionDescriptor)new StandardSQLFunction("convert"));
        functionRegistry.register("uuid", (SqmFunctionDescriptor)new StandardSQLFunction("uuid", StandardBasicTypes.STRING));
        functionRegistry.register("unescape", (SqmFunctionDescriptor)new StandardSQLFunction("unescape", StandardBasicTypes.STRING));
        functionRegistry.register("modifytimezone", (SqmFunctionDescriptor)new StandardSQLFunction("modifytimezone", StandardBasicTypes.TIMESTAMP));
        functionRegistry.register("session_id", (SqmFunctionDescriptor)new StandardSQLFunction("session_id", StandardBasicTypes.STRING));
        functionRegistry.register("to_bytes", (SqmFunctionDescriptor)new StandardSQLFunction("to_bytes", StandardBasicTypes.BLOB));
        functionRegistry.register("to_chars", (SqmFunctionDescriptor)new StandardSQLFunction("to_chars", StandardBasicTypes.CLOB));
        functionRegistry.register("array_get", (SqmFunctionDescriptor)new StandardSQLFunction("array_get", StandardBasicTypes.OBJECT_TYPE));
        functionRegistry.register("array_length", (SqmFunctionDescriptor)new StandardSQLFunction("array_length", StandardBasicTypes.INTEGER));
        functionRegistry.register("jsonParse", (SqmFunctionDescriptor)new StandardSQLFunction("jsonParse", StandardBasicTypes.CLOB));
        functionRegistry.register("jsonObject", (SqmFunctionDescriptor)new StandardSQLFunction("jsonObject", StandardBasicTypes.CLOB));
        functionRegistry.register("yamlAsJSON", (SqmFunctionDescriptor)new StandardSQLFunction("yamlAsJSON", StandardBasicTypes.CLOB));
        functionRegistry.register("jsonPath", (SqmFunctionDescriptor)new StandardSQLFunction("jsonPath", StandardBasicTypes.CLOB));
        functionRegistry.register("jsonJq", (SqmFunctionDescriptor)new StandardSQLFunction("jsonJq", StandardBasicTypes.CLOB));
        functionRegistry.register("jsonPathAsString", (SqmFunctionDescriptor)new StandardSQLFunction("jsonPathAsString", StandardBasicTypes.STRING));
        functionRegistry.register("jsonJqAsString", (SqmFunctionDescriptor)new StandardSQLFunction("jsonJqAsString", StandardBasicTypes.STRING));
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -7: {
                return "boolean";
            }
            case -6: {
                return "byte";
            }
            case 5: {
                return "short";
            }
            case 4: {
                return "integer";
            }
            case 1: {
                return "char";
            }
            case -15: {
                return this.columnType(1);
            }
            case -9: {
                return this.columnType(12);
            }
            case 12: 
            case 4001: 
            case 4002: {
                return "string";
            }
            case -2: 
            case 2004: 
            case 4003: {
                return "blob";
            }
            case 2005: 
            case 2011: {
                return "clob";
            }
            case -3: {
                return "varbinary";
            }
            case -5: {
                return "long";
            }
            case 93: 
            case 3003: {
                return "timestamp";
            }
            case 92: {
                return "time";
            }
            case 91: {
                return "date";
            }
            case 2000: {
                return "object";
            }
            case 6: 
            case 7: {
                return "float";
            }
            case 8: {
                return "double";
            }
            case 2: {
                return "bigdecimal";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean hasAlterTable() {
        return false;
    }

    public boolean supportsColumnCheck() {
        return false;
    }

    public boolean supportsCascadeDelete() {
        return false;
    }

    public String getCurrentTimestampSQLFunctionName() {
        return "now";
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public boolean supportsTableCheck() {
        return false;
    }

    public boolean supportsUnique() {
        return false;
    }

    public String toBooleanValueString(boolean arg0) {
        if (arg0) {
            return "{b'true'}";
        }
        return "{b'false'}";
    }

    public LimitHandler getLimitHandler() {
        return new AbstractSimpleLimitHandler(){

            protected String limitClause(boolean hasFirstRow) {
                return hasFirstRow ? " limit ?, ?" : " limit ?";
            }
        };
    }

    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    public int registerResultSetOutParameter(CallableStatement statement, int col) {
        return col;
    }

    public String getForUpdateNowaitString() {
        return "";
    }

    public String getForUpdateNowaitString(String aliases) {
        return "";
    }

    public String getForUpdateString() {
        return "";
    }

    public String getForUpdateString(LockMode lockMode) {
        return "";
    }

    public String getForUpdateString(String aliases) {
        return "";
    }

    public String getSelectGUIDString() {
        return "select uuid()";
    }

    public SequenceSupport getSequenceSupport() {
        return new SequenceSupport(){

            public String getSelectSequenceNextValString(String sequenceName) throws MappingException {
                return sequenceName + "_nextval()";
            }

            public boolean supportsPooledSequences() {
                return true;
            }

            public String getSequenceNextValString(String sequenceName) throws MappingException {
                return "select " + this.getSelectSequenceNextValString(sequenceName);
            }
        };
    }

    public String getTemporaryTableCreateCommand() {
        TemporaryTableKind kind = this.getSupportedTemporaryTableKind();
        switch (kind) {
            case PERSISTENT: {
                return "create temporary table";
            }
            case LOCAL: {
                return "create local temporary table";
            }
            case GLOBAL: {
                return "create global temporary table";
            }
        }
        throw new UnsupportedOperationException("Unsupported kind: " + String.valueOf(kind));
    }

    public TemporaryTableExporter getTemporaryTableExporter() {
        return new KublingTemporaryTableExporter(this);
    }

    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.SCHEMA;
    }
}

