/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.analyzer.writer;

import com.google.common.annotations.VisibleForTesting;
import com.lazerycode.jmeter.analyzer.parser.AggregatedResponses;
import com.lazerycode.jmeter.analyzer.statistics.Samples;
import com.lazerycode.jmeter.analyzer.util.FileUtil;
import com.lazerycode.jmeter.analyzer.writer.WriterBase;
import freemarker.template.TemplateException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ChartWriter
extends WriterBase {
    private static final int IMAGE_WIDTH = 800;
    private static final int IMAGE_HEIGHT = 600;

    public boolean equals(Object obj) {
        return obj instanceof ChartWriter;
    }

    @Override
    public void write(Map<String, AggregatedResponses> testResults) throws IOException, TemplateException {
        for (Map.Entry<String, AggregatedResponses> entry : testResults.entrySet()) {
            String name = entry.getKey();
            AggregatedResponses aggregatedResponses = entry.getValue();
            this.writeCharts(aggregatedResponses, name);
        }
    }

    @VisibleForTesting
    protected OutputStream getOut(File file) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    private void writeCharts(AggregatedResponses aggregatedResponses, String name) throws IOException, TemplateException {
        String fileName = FileUtil.urlEncode(name) + "-durations-" + super.getFileName() + ".png";
        File requestChartFile = this.getFile(fileName);
        Samples aggregatedResult = aggregatedResponses.getDuration();
        String chartName = "Requests Duration (" + name + ")";
        this.renderChart(chartName, "Duration", "Time / ms", "Duration / ms", aggregatedResult, requestChartFile);
        fileName = FileUtil.urlEncode(name) + "-sizes-" + super.getFileName() + ".png";
        requestChartFile = this.getFile(fileName);
        aggregatedResult = aggregatedResponses.getSize();
        chartName = "Requests Size (" + name + ")";
        this.renderChart(chartName, "Size", "Time / ms", "Size / bytes", aggregatedResult, requestChartFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderChart(String chartName, String singleValueName, String domainAxisName, String rangeAxisName, Samples source, File target) throws IOException {
        XYSeries singleValue = new XYSeries((Comparable)((Object)singleValueName));
        XYSeries average = new XYSeries((Comparable)((Object)"Average"));
        long minimumTimestamp = source.getMinTimestamp();
        List<Long> samples = source.getSamples();
        List<Long> timestamps = source.getTimestamps();
        long total = 0L;
        for (int x = 0; x < samples.size(); ++x) {
            long current = samples.get(x);
            long timestamp = timestamps.get(x);
            singleValue.add((double)(timestamp - minimumTimestamp), (Number)samples.get(x));
            average.add((double)(timestamp - minimumTimestamp), (double)((int)((total += current) / (long)(x + 1))));
        }
        XYSeriesCollection singleValues = new XYSeriesCollection();
        singleValues.addSeries(singleValue);
        XYSeriesCollection averages = new XYSeriesCollection();
        averages.addSeries(average);
        XYPlot plot = new XYPlot();
        NumberAxis domainAxis = new NumberAxis(domainAxisName);
        domainAxis.setAutoRangeIncludesZero(false);
        plot.setDomainAxis((ValueAxis)domainAxis);
        NumberAxis rangeAxis = new NumberAxis(rangeAxisName);
        plot.setRangeAxis((ValueAxis)rangeAxis);
        XYBarRenderer renderer1 = new XYBarRenderer();
        renderer1.setShadowVisible(false);
        plot.setDataset(1, (XYDataset)singleValues);
        plot.setRenderer(1, (XYItemRenderer)renderer1);
        XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer();
        renderer2.setBaseShapesVisible(false);
        plot.setDataset(0, (XYDataset)averages);
        plot.setRenderer(0, (XYItemRenderer)renderer2);
        JFreeChart chart = new JFreeChart(chartName, (Plot)plot);
        OutputStream out = this.getOut(target);
        try {
            ChartUtilities.writeChartAsPNG((OutputStream)out, (JFreeChart)chart, (int)800, (int)600, null);
        }
        finally {
            out.close();
        }
    }
}

