/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.net;

import com.mchange.io.OutputStreamUtils;
import com.mchange.io.ReaderUtils;
import com.mchange.net.SmtpException;
import com.mchange.net.SocketUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Properties;

public final class SmtpUtils {
    private static final String ENC = "8859_1";
    private static final String CRLF = "\r\n";
    private static final String CHARSET = "charset";
    private static final int CHARSET_LEN = "charset".length();
    public static final int DEFAULT_SMTP_PORT = 25;

    public static void sendMail(InetAddress smtpHost, int smtpPort, String mailFrom, String[] rcptTo, Properties headers, byte[] bodyBytes) throws IOException, SmtpException {
        Socket s = null;
        DataOutputStream dout = null;
        BufferedReader br = null;
        try {
            s = new Socket(smtpHost, smtpPort);
            dout = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
            br = new BufferedReader(new InputStreamReader(s.getInputStream(), ENC));
            SmtpUtils.ensureResponse(br, 200, 300);
            dout.writeBytes("HELO " + s.getLocalAddress().getHostName() + CRLF);
            dout.flush();
            SmtpUtils.ensureResponse(br, 200, 300);
            dout.writeBytes("MAIL FROM: " + mailFrom + CRLF);
            dout.flush();
            SmtpUtils.ensureResponse(br, 200, 300);
            int i = rcptTo.length;
            while (--i >= 0) {
                dout.writeBytes("RCPT TO: " + rcptTo[i] + CRLF);
                dout.flush();
                SmtpUtils.ensureResponse(br, 200, 300);
            }
            dout.writeBytes("DATA\r\n");
            dout.flush();
            SmtpUtils.ensureResponse(br, 300, 400);
            Enumeration<Object> e = headers.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = headers.getProperty(key);
                dout.writeBytes(key + ": " + value + CRLF);
            }
            dout.writeBytes(CRLF);
            dout.write(bodyBytes);
            dout.writeBytes("\r\n.\r\n");
            dout.flush();
            SmtpUtils.ensureResponse(br, 200, 300);
            dout.writeBytes("QUIT\r\n");
            dout.flush();
        }
        catch (UnsupportedEncodingException e) {
            try {
                e.printStackTrace();
                throw new InternalError("8859_1 not supported???");
            }
            catch (Throwable throwable) {
                OutputStreamUtils.attemptClose(dout);
                ReaderUtils.attemptClose(br);
                SocketUtils.attemptClose(s);
                throw throwable;
            }
        }
        OutputStreamUtils.attemptClose(dout);
        ReaderUtils.attemptClose(br);
        SocketUtils.attemptClose(s);
    }

    private static String encodingFromContentType(String contentType) {
        int cs_index = contentType.indexOf(CHARSET);
        if (cs_index >= 0) {
            String cs = contentType.substring(cs_index + CHARSET_LEN);
            if ((cs = cs.trim()).charAt(0) != '=') {
                return SmtpUtils.encodingFromContentType(cs);
            }
            int semidex = (cs = cs.substring(1).trim()).indexOf(59);
            if (semidex >= 0) {
                cs = cs.substring(0, semidex);
            }
            return cs;
        }
        return null;
    }

    private static byte[] bytesFromBodyString(String body, String enc) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)baos, enc));
        pw.print(body);
        pw.flush();
        return baos.toByteArray();
    }

    private static void ensureResponse(BufferedReader br, int begin_inclusive, int end_exclusive) throws IOException, SmtpException {
        String smtpRespStr = br.readLine();
        try {
            int smtp_resp_num = Integer.parseInt(smtpRespStr.substring(0, 3));
            while (smtpRespStr.charAt(3) == '-') {
                smtpRespStr = br.readLine();
            }
            if (smtp_resp_num < begin_inclusive || smtp_resp_num >= end_exclusive) {
                throw new SmtpException(smtp_resp_num, smtpRespStr);
            }
        }
        catch (NumberFormatException e) {
            throw new SmtpException("Bad SMTP response while mailing document!");
        }
    }

    public static void main(String[] argv) {
        try {
            InetAddress smtpHost = InetAddress.getByName("mailhub.mchange.com");
            int smtpPort = 25;
            String mailFrom = "octavia@mchange.com";
            String[] rcptTo = new String[]{"swaldman@mchange.com", "sw-lists@mchange.com"};
            Properties props = new Properties();
            props.put("From", "goolash@mchange.com");
            props.put("To", "garbage@mchange.com");
            props.put("Subject", "Test test test AGAIN...");
            byte[] bodyBytes = "This is a test AGAIN! Imagine that!".getBytes(ENC);
            SmtpUtils.sendMail(smtpHost, smtpPort, mailFrom, rcptTo, props, bodyBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SmtpUtils() {
    }
}

