/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.git;

import com.mycila.maven.plugin.license.git.GitPathResolver;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.MaxCountRevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GitLookup {
    public static final TimeZone DEFAULT_ZONE = TimeZone.getTimeZone("GMT");
    public static final int DEFAULT_COMMITS_COUNT = 10;
    private final int checkCommitsCount;
    private final DateSource dateSource;
    private final GitPathResolver pathResolver;
    private final Repository repository;
    private final TimeZone timeZone;

    public GitLookup(File anyFile, DateSource dateSource, TimeZone timeZone, int checkCommitsCount) throws IOException {
        this.repository = ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(anyFile)).build();
        this.repository.getObjectDatabase().newReader().getShallowCommits();
        this.pathResolver = new GitPathResolver(this.repository.getWorkTree().getAbsolutePath());
        this.dateSource = dateSource;
        switch (dateSource) {
            case COMMITER: {
                this.timeZone = timeZone == null ? DEFAULT_ZONE : timeZone;
                break;
            }
            case AUTHOR: {
                if (timeZone != null) {
                    throw new IllegalArgumentException("Time zone must be null with dateSource " + DateSource.AUTHOR.name() + " because git author name already contrains time zone information.");
                }
                this.timeZone = null;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected " + DateSource.class.getName() + " " + (Object)((Object)dateSource));
            }
        }
        this.checkCommitsCount = checkCommitsCount;
    }

    public int getYearOfLastChange(File file) throws NoHeadException, GitAPIException, IOException {
        String repoRelativePath = this.pathResolver.relativize(file);
        Status status = new Git(this.repository).status().addPath(repoRelativePath).call();
        if (!status.isClean()) {
            return GitLookup.toYear(System.currentTimeMillis(), this.timeZone != null ? this.timeZone : DEFAULT_ZONE);
        }
        RevWalk walk = new RevWalk(this.repository);
        walk.markStart(walk.parseCommit((AnyObjectId)this.repository.resolve("HEAD")));
        walk.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilter.create((String)repoRelativePath), (TreeFilter)TreeFilter.ANY_DIFF));
        walk.setRevFilter(MaxCountRevFilter.create((int)this.checkCommitsCount));
        walk.setRetainBody(false);
        int commitYear = 0;
        for (RevCommit commit : walk) {
            int y;
            switch (this.dateSource) {
                case COMMITER: {
                    int epochSeconds = commit.getCommitTime();
                    y = GitLookup.toYear((long)epochSeconds * 1000L, this.timeZone);
                    break;
                }
                case AUTHOR: {
                    PersonIdent id = commit.getAuthorIdent();
                    Date date = id.getWhen();
                    y = GitLookup.toYear(date.getTime(), id.getTimeZone());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected " + DateSource.class.getName() + " " + (Object)((Object)this.dateSource));
                }
            }
            if (y <= commitYear) continue;
            commitYear = y;
        }
        walk.dispose();
        return commitYear;
    }

    private static int toYear(long epochMilliseconds, TimeZone timeZone) {
        Calendar result = Calendar.getInstance(timeZone);
        result.setTimeInMillis(epochMilliseconds);
        return result.get(1);
    }

    public static enum DateSource {
        AUTHOR,
        COMMITER;

    }
}

