/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.SpecVersionDetector;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.utils.StringChecker;

public class JsonNodeUtil {
    private static final long V6_VALUE = SpecVersion.VersionFlag.V6.getVersionFlagValue();
    private static final String TYPE = "type";
    private static final String ENUM = "enum";
    private static final String REF = "$ref";
    private static final String NULLABLE = "nullable";

    public static boolean isNodeNullable(JsonNode schema) {
        JsonNode nullable = schema.get(NULLABLE);
        return nullable != null && nullable.asBoolean();
    }

    public static boolean isNodeNullable(JsonNode schema, SchemaValidatorsConfig config) {
        if (config.isHandleNullableField()) {
            return JsonNodeUtil.isNodeNullable(schema);
        }
        return false;
    }

    public static boolean equalsToSchemaType(JsonNode node, JsonType schemaType, JsonSchema parentSchema, ValidationContext validationContext) {
        SchemaValidatorsConfig config = validationContext.getConfig();
        JsonType nodeType = TypeFactory.getValueNodeType(node, config);
        String metaSchema = validationContext.getMetaSchema().getUri();
        long version = SpecVersionDetector.detectOptionalVersion(metaSchema).orElse(SpecVersion.VersionFlag.V4).getVersionFlagValue();
        if (nodeType != schemaType) {
            if (schemaType == JsonType.ANY) {
                return true;
            }
            if (schemaType == JsonType.NUMBER && nodeType == JsonType.INTEGER) {
                return true;
            }
            if (V6_VALUE <= version && schemaType == JsonType.INTEGER && nodeType == JsonType.NUMBER && 1.0 == node.asDouble()) {
                return true;
            }
            if (JsonType.NULL.equals((Object)nodeType) && parentSchema != null && (parentSchema.getParentSchema() != null && JsonNodeUtil.isNodeNullable(parentSchema.getParentSchema().getSchemaNode(), config) || JsonNodeUtil.isNodeNullable(parentSchema.getSchemaNode()))) {
                return true;
            }
            if (JsonNodeUtil.isEnumObjectSchema(parentSchema)) {
                return true;
            }
            if (config != null && config.isTypeLoose()) {
                if (schemaType == JsonType.ARRAY) {
                    return true;
                }
                if (nodeType == JsonType.STRING && (schemaType == JsonType.INTEGER ? StringChecker.isInteger(node.textValue()) : (schemaType == JsonType.BOOLEAN ? StringChecker.isBoolean(node.textValue()) : schemaType == JsonType.NUMBER && StringChecker.isNumeric(node.textValue())))) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean isNumber(JsonNode node, SchemaValidatorsConfig config) {
        if (node.isNumber()) {
            return true;
        }
        if (config.isTypeLoose() && TypeFactory.getValueNodeType(node, config) == JsonType.STRING) {
            return StringChecker.isNumeric(node.textValue());
        }
        return false;
    }

    private static boolean isEnumObjectSchema(JsonSchema jsonSchema) {
        JsonNode typeNode = null;
        JsonNode enumNode = null;
        JsonNode refNode = null;
        if (jsonSchema != null) {
            if (jsonSchema.getSchemaNode() != null) {
                typeNode = jsonSchema.getSchemaNode().get(TYPE);
                enumNode = jsonSchema.getSchemaNode().get(ENUM);
            }
            if (jsonSchema.getParentSchema() != null && jsonSchema.getParentSchema().getSchemaNode() != null) {
                refNode = jsonSchema.getParentSchema().getSchemaNode().get(REF);
            }
        }
        if (typeNode != null && enumNode != null && refNode != null) {
            return TypeFactory.getSchemaNodeType(typeNode) == JsonType.OBJECT && enumNode.isArray();
        }
        return false;
    }
}

