/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oas.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.networknt.jsonoverlay.BooleanOverlay;
import com.networknt.jsonoverlay.IntegerOverlay;
import com.networknt.jsonoverlay.JsonOverlay;
import com.networknt.jsonoverlay.ListOverlay;
import com.networknt.jsonoverlay.MapOverlay;
import com.networknt.jsonoverlay.NumberOverlay;
import com.networknt.jsonoverlay.ObjectOverlay;
import com.networknt.jsonoverlay.Overlay;
import com.networknt.jsonoverlay.PrimitiveOverlay;
import com.networknt.jsonoverlay.PropertiesOverlay;
import com.networknt.jsonoverlay.StringOverlay;
import com.networknt.oas.validator.BaseValidationMessages;
import com.networknt.oas.validator.IPv6AwareEmailValidator;
import com.networknt.oas.validator.ListValidator;
import com.networknt.oas.validator.MapValidator;
import com.networknt.oas.validator.NumericUtils;
import com.networknt.oas.validator.ValidationContext;
import com.networknt.oas.validator.ValidationResults;
import com.networknt.oas.validator.Validator;
import com.networknt.oas.validator.msg.Messages;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;

public abstract class ValidatorBase<V>
implements Validator<V> {
    protected Overlay<V> value;
    protected ValidationResults results;
    private static String FAKE_SCHEME = "oasparser.fake.scheme";
    private static URLStreamHandler fakeHandler = new URLStreamHandler(){

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return null;
        }
    };
    protected static Map<Class<?>, List<Class<? extends JsonNode>>> allowedJsonTypes = null;

    @Override
    public final void validate(Overlay<V> value) {
        this.value = value;
        this.results = ValidationContext.getValidationResults();
        this.checkJsonType(value, this.getAllowedJsonTypes(value), this.results);
        this.runValidations();
    }

    public abstract void runValidations();

    public Overlay<Boolean> validateBooleanField(String name, boolean required) {
        return this.validateField(name, required, Boolean.class, null, new Consumer[0]);
    }

    public Overlay<String> validateStringField(String name, boolean required) {
        return this.validateStringField(name, required, null, new Consumer[0]);
    }

    public Overlay<String> validateStringField(String name, boolean required, String pattern) {
        return this.validateStringField(name, required, Pattern.compile(pattern), new Consumer[0]);
    }

    @SafeVarargs
    public final Overlay<String> validateStringField(String name, boolean required, Pattern pattern, Consumer<Overlay<String>> ... otherChecks) {
        Overlay<String> field = this.validateField(name, required, String.class, null, new Consumer[0]);
        this.checkMissing(field, required);
        if (field != null && field.isPresent()) {
            if (pattern != null) {
                this.checkPattern(field, pattern);
            }
            for (Consumer<Overlay<String>> otherCheck : otherChecks) {
                otherCheck.accept(field);
            }
        }
        return field;
    }

    void checkPattern(Overlay<String> field, Pattern pattern) {
        if (!pattern.matcher((CharSequence)field.get()).matches()) {
            this.results.addError(Messages.msg(BaseValidationMessages.PatternMatchFail, field.get(), pattern), field);
        }
    }

    public Overlay<String> validatePatternField(String name, boolean required) {
        return this.validateStringField(name, required, null, this::checkRegex);
    }

    private void checkRegex(Overlay<String> field) {
        String regex = (String)field.get();
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            this.results.addWarning(Messages.msg(BaseValidationMessages.BadPattern, regex), field);
        }
    }

    public Overlay<String> validateUrlField(String name, boolean required, boolean allowRelative, boolean allowVars) {
        return this.validateUrlField(name, required, allowRelative, allowVars, (Pattern)null);
    }

    public Overlay<String> validateUrlField(String name, boolean required, boolean allowRelative, boolean allowVars, String pattern) {
        return this.validateUrlField(name, required, allowRelative, allowVars, Pattern.compile(pattern));
    }

    public Overlay<String> validateUrlField(String name, boolean required, boolean allowRelative, boolean allowVars, Pattern pattern) {
        return this.validateStringField(name, required, pattern, field -> this.checkUrl((Overlay<String>)field, allowRelative, allowVars));
    }

    private void checkUrl(Overlay<String> overlay, boolean allowRelative, boolean allowVars) {
        String origUrl = (String)overlay.get();
        Object url = origUrl;
        boolean fake = false;
        if (allowVars && ((String)(url = ((String)url).replaceAll("\\{[^}]+\\}", "1"))).startsWith("1:")) {
            url = FAKE_SCHEME + ((String)url).substring(1);
            fake = true;
        }
        try {
            new URL(null, (String)url, fake ? fakeHandler : null);
        }
        catch (MalformedURLException e) {
            try {
                URL context = new URL(null, FAKE_SCHEME + ":/", fakeHandler);
                new URL(context, (String)url);
                if (!allowRelative) {
                    this.results.addError(Messages.msg(BaseValidationMessages.NoRelUrl, origUrl, e.toString()), overlay);
                }
            }
            catch (MalformedURLException e1) {
                this.results.addError(Messages.msg(BaseValidationMessages.BadUrl, origUrl, e.toString()), overlay);
            }
        }
    }

    public Overlay<String> validateEmailField(String name, boolean required) {
        return this.validateEmailField(name, required, null);
    }

    public Overlay<String> validateUrlField(String name, boolean required, String pattern) {
        return this.validateEmailField(name, required, Pattern.compile(pattern));
    }

    public Overlay<String> validateEmailField(String name, boolean required, Pattern pattern) {
        return this.validateStringField(name, required, pattern, this::checkEmail);
    }

    private void checkEmail(Overlay<String> overlay) {
        IPv6AwareEmailValidator validator = new IPv6AwareEmailValidator(true, true);
        String email = (String)overlay.get();
        boolean valid = validator.isValid(email);
        if (!valid) {
            this.results.addError(Messages.msg(BaseValidationMessages.BadEmail, email, "invalid email"), overlay);
        }
    }

    public Overlay<Number> validatePositiveField(String name, boolean required) {
        return this.validateNumericField(name, required, NumericUtils::isPositive, "be positive");
    }

    public Overlay<Number> validateNonNegativeField(String name, boolean required) {
        return this.validateNumericField(name, required, NumericUtils::isNonNegative, "not be positive");
    }

    public Overlay<Number> validateNumericField(String name, boolean required, Function<Number, Boolean> test, String desc) {
        Number n;
        Overlay<Number> field = this.validateField(name, required, Number.class, null, new Consumer[0]);
        this.checkMissing(field, required);
        if (field != null && field.isPresent() && test != null && !test.apply(n = (Number)field.get()).booleanValue()) {
            this.results.addError(Messages.msg(BaseValidationMessages.NumberConstraint, desc, n), field);
        }
        return field;
    }

    @SafeVarargs
    public final <F> Overlay<F> validateField(String name, boolean required, Class<F> fieldClass, Validator<F> validator, Consumer<Overlay<F>> ... otherChecks) {
        PropertiesOverlay propValue = (PropertiesOverlay)this.value.get();
        Overlay field = Overlay.of((PropertiesOverlay)propValue, (String)name, fieldClass);
        this.checkJsonType(field, this.getAllowedJsonTypes(field), this.results);
        this.checkMissing(field, required);
        if (field != null && field.isPresent() && validator != null) {
            validator.validate(field);
            for (Consumer<Overlay<F>> otherCheck : otherChecks) {
                otherCheck.accept(field);
            }
        }
        return field;
    }

    public <X> Overlay<List<X>> validateListField(String name, boolean nonEmpty, boolean unique, Class<X> itemClass, Validator<X> itemValidator) {
        Overlay list = Overlay.of((PropertiesOverlay)((PropertiesOverlay)this.value.get()), (String)name, List.class);
        this.validateList(list, nonEmpty, unique, itemValidator);
        return list;
    }

    private <X> void validateList(Overlay<List<X>> list, boolean nonEmpty, boolean unique, Validator<X> itemValidator) {
        new ListValidator<X>(itemValidator).validate(list);
        this.checkListNotEmpty(list, nonEmpty);
        this.checkListUnique(list, unique);
    }

    private <X> void checkListNotEmpty(Overlay<List<X>> list, boolean nonEmpty) {
        if (nonEmpty) {
            ListOverlay listOverlay = Overlay.getListOverlay(list);
            if (list != null && !list.isPresent() && nonEmpty && listOverlay.size() == 0) {
                this.results.addError(Messages.msg(BaseValidationMessages.EmptyList, new Object[0]), list);
            }
        }
    }

    private <X> void checkListUnique(Overlay<List<X>> list, boolean unique) {
        if (unique) {
            ListOverlay listOverlay = Overlay.getListOverlay(list);
            HashSet<Object> seen = new HashSet<Object>();
            for (int i = 0; i < listOverlay.size(); ++i) {
                Object item = listOverlay.get(i);
                if (seen.contains(item)) {
                    this.results.addError(Messages.msg(BaseValidationMessages.DuplicateValue, item, i), Overlay.of((ListOverlay)listOverlay, (int)i));
                    continue;
                }
                seen.add(item);
            }
        }
    }

    public <X> Overlay<Map<String, X>> validateMapField(String name, boolean nonEmpty, boolean unique, Class<X> valueClass, Validator<X> valueValidator) {
        Overlay map = Overlay.of((PropertiesOverlay)((PropertiesOverlay)this.value.get()), (String)name, Map.class);
        this.validateMap(map, nonEmpty, unique, valueValidator);
        return map;
    }

    private <X> void validateMap(Overlay<Map<String, X>> map, boolean nonEmpty, boolean unique, Validator<X> valueValidator) {
        new MapValidator<X>(valueValidator).validate(map);
        this.checkMapNotEmpty(map, nonEmpty);
        this.checkMapUnique(map, unique);
    }

    private <X> void checkMapNotEmpty(Overlay<Map<String, X>> list, boolean nonEmpty) {
        if (nonEmpty) {
            MapOverlay mapOverlay = Overlay.getMapOverlay(list);
            if (list != null && !list.isPresent() && nonEmpty && mapOverlay.size() == 0) {
                this.results.addError(Messages.msg(BaseValidationMessages.EmptyList, new Object[0]), list);
            }
        }
    }

    private <X> void checkMapUnique(Overlay<Map<String, X>> map, boolean unique) {
        if (unique) {
            MapOverlay mapOverlay = Overlay.getMapOverlay(map);
            HashSet<Object> seen = new HashSet<Object>();
            for (String key : mapOverlay.keySet()) {
                Object value = mapOverlay.get(key);
                if (seen.contains(value)) {
                    this.results.addError(Messages.msg(BaseValidationMessages.DuplicateValue, value, key), Overlay.of((MapOverlay)mapOverlay, (String)key));
                    continue;
                }
                seen.add(value);
            }
        }
    }

    void checkMissing(Overlay<?> field, boolean required) {
        if (required && (field == null || !field.isPresent())) {
            this.results.addError(Messages.msg(BaseValidationMessages.MissingField, field.getPathInParent()), this.value);
        }
    }

    public Overlay<Map<String, Object>> validateExtensions(Map<String, Object> extensions) {
        return this.validateExtensions(extensions, null);
    }

    public Overlay<Map<String, Object>> validateExtensions(Map<String, Object> extensions, String crumb) {
        Overlay mapOverlay = Overlay.of(extensions);
        this.validateMap(mapOverlay, false, false, null);
        return mapOverlay;
    }

    public Overlay<String> validateFormatField(String name, boolean required, String type) {
        Overlay<String> field = this.validateStringField(name, required);
        if (field != null && field.isPresent()) {
            String normalType = null;
            switch ((String)field.get()) {
                case "int32": 
                case "int64": {
                    normalType = "integer";
                    break;
                }
                case "float": 
                case "double": {
                    normalType = "number";
                    break;
                }
                case "byte": 
                case "binary": 
                case "date": 
                case "date-time": 
                case "password": {
                    normalType = "string";
                }
            }
            if (!(normalType == null || type != null && type.equals(normalType))) {
                this.results.addWarning(Messages.msg(BaseValidationMessages.WrongTypeFormat, field, type, normalType), field);
            }
        }
        return field;
    }

    public void checkDefault(Overlay<?> overlay, String type) {
        if (overlay != null && overlay.isPresent() && type != null) {
            Object defaultValue = overlay.get();
            boolean ok = false;
            switch (type) {
                case "string": {
                    ok = defaultValue instanceof String;
                    break;
                }
                case "number": {
                    ok = NumericUtils.isNumeric(defaultValue);
                    break;
                }
                case "integer": {
                    ok = NumericUtils.isIntegral(defaultValue);
                    break;
                }
                case "boolean": {
                    ok = defaultValue instanceof Boolean;
                    break;
                }
                case "object": {
                    ok = defaultValue instanceof Map;
                    break;
                }
                case "array": {
                    ok = defaultValue instanceof List;
                }
            }
            if (!ok) {
                this.results.addError(Messages.msg(BaseValidationMessages.WrongTypeValue, type, defaultValue), overlay);
            }
        }
    }

    public void checkJsonType(Overlay<?> value, Collection<Class<? extends JsonNode>> allowedJsonTypes, ValidationResults results) {
        JsonNode json = value.getParsedJson();
        if (json != null && !json.isMissingNode()) {
            for (Class<? extends JsonNode> type2 : allowedJsonTypes) {
                if (!type2.isAssignableFrom(json.getClass())) continue;
                return;
            }
            String allowed = allowedJsonTypes.stream().map(type -> this.getJsonValueType((Class<? extends JsonNode>)type)).collect(Collectors.joining(", "));
            results.addError(Messages.msg(BaseValidationMessages.WrongTypeJson, this.getJsonValueType(json.getClass()), allowed), value);
        }
    }

    private String getJsonValueType(Class<? extends JsonNode> node) {
        String type = node.getSimpleName();
        return type.endsWith("Node") ? type.substring(0, type.length() - 4) : type;
    }

    protected Collection<Class<? extends JsonNode>> getAllowedJsonTypes(Overlay<?> value) {
        JsonOverlay overlay;
        if (allowedJsonTypes == null) {
            ValidatorBase.createAllowedJsonTypes();
        }
        return allowedJsonTypes.get((overlay = value.getOverlay()) instanceof PropertiesOverlay ? PropertiesOverlay.class : overlay.getClass());
    }

    private static void createAllowedJsonTypes() {
        HashMap types = new HashMap();
        types.put(StringOverlay.class, Arrays.asList(TextNode.class));
        types.put(BooleanOverlay.class, Arrays.asList(BooleanNode.class));
        types.put(IntegerOverlay.class, Arrays.asList(IntNode.class, ShortNode.class, BigIntegerNode.class));
        types.put(NumberOverlay.class, Arrays.asList(NumericNode.class));
        types.put(PrimitiveOverlay.class, Arrays.asList(TextNode.class, NumericNode.class, BooleanNode.class));
        types.put(ObjectOverlay.class, Arrays.asList(JsonNode.class));
        types.put(MapOverlay.class, Arrays.asList(ObjectNode.class));
        types.put(ListOverlay.class, Arrays.asList(ArrayNode.class));
        types.put(PropertiesOverlay.class, Arrays.asList(ObjectNode.class));
        allowedJsonTypes = types;
    }
}

